/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.schedulers;

import com.flowkraft.common.AppPaths;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GroovyScheduler {
    @Value(value="${POLLING_PATH:}")
    private String pollingPath;

    @PostConstruct
    public void init() throws Exception {
        if (!StringUtils.isBlank((CharSequence)this.pollingPath)) {
            File pollDirReceived;
            File pollDir = new File(this.pollingPath);
            if (!pollDir.exists()) {
                pollDir.mkdirs();
            }
            if (!(pollDirReceived = new File(this.pollingPath + "/received")).exists()) {
                pollDirReceived.mkdirs();
            }
            String scriptsFolderPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/scripts/batch/";
            String scriptName = "schedules.groovy";
            String scriptPath = Paths.get(scriptsFolderPath, scriptName).toString();
            if (Files.exists(Paths.get(scriptPath, new String[0]), new LinkOption[0])) {
                Binding binding = new Binding();
                binding.setVariable("PORTABLE_EXECUTABLE_DIR_PATH", (Object)AppPaths.PORTABLE_EXECUTABLE_DIR_PATH);
                binding.setVariable("POLLING_PATH", (Object)this.pollingPath);
                GroovyScriptEngine gse = new GroovyScriptEngine(new String[]{scriptsFolderPath});
                gse.run(scriptName, binding);
            }
        }
    }
}

