/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.models;

import java.io.File;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.Validate;

public class FileVO
implements Comparable<FileVO> {
    private static final boolean IS_WINDOWS = SystemUtils.OS_NAME.toLowerCase().indexOf("windows") >= 0;
    private File file;

    public FileVO(File file) {
        Validate.notNull((Object)file, (String)"Null file not allowed.", (Object[])new Object[0]);
        this.file = file;
    }

    public String getName() {
        if (this.file.getParent() == null) {
            return this.file.getPath().replace('\\', '/');
        }
        return this.file.getName();
    }

    public String getPath() {
        return this.file.getPath().replace('\\', '/');
    }

    public String getFullName() {
        return this.file.getAbsolutePath().replace('\\', '/');
    }

    public boolean isWritable() {
        return this.file.canWrite();
    }

    public boolean isReadable() {
        return this.file.canRead();
    }

    public boolean isExecutable() {
        if (IS_WINDOWS && this.localCanExecute(this.file) && (this.file.getName().endsWith(".cmd") || this.file.getName().endsWith(".bat"))) {
            return true;
        }
        if (IS_WINDOWS) {
            return false;
        }
        return this.localCanExecute(this.file);
    }

    private boolean localCanExecute(File file) {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6)) {
            try {
                Method canExecuteMethod = File.class.getMethod("canExecute", null);
                return (Boolean)canExecuteMethod.invoke((Object)file, (Object[])null);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't execute File.canExecute()", e);
            }
        }
        return false;
    }

    public String getAccessAttributes() {
        Object fileAttrs = "";
        fileAttrs = (String)fileAttrs + (this.file.isDirectory() ? "d" : "-");
        fileAttrs = (String)fileAttrs + (this.localCanExecute(this.file) ? "x" : "-");
        fileAttrs = (String)fileAttrs + (this.file.canRead() ? "r" : "-");
        fileAttrs = (String)fileAttrs + (this.file.canWrite() ? "w" : "-");
        return fileAttrs;
    }

    public String getSize() {
        if (this.file.length() > 0L && this.file.length() < 1024L) {
            return "1 KB";
        }
        return NumberFormat.getIntegerInstance().format(this.file.length() / 1024L) + " KB";
    }

    public String getDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy h:mm a");
        return format.format(new Date(this.file.lastModified()));
    }

    @Override
    public int compareTo(FileVO o) {
        return this.file.compareTo(o.file);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof FileVO) {
            FileVO rhs = (FileVO)obj;
            return this.file.equals(rhs.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        return new FileVO(this.file);
    }
}

