/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.flowkraft.common.AppPaths;
import com.flowkraft.jobman.dtos.DirCriteriaDto;
import com.flowkraft.jobman.dtos.FileCriteriaDto;
import com.flowkraft.jobman.dtos.FindCriteriaDto;
import com.flowkraft.jobman.dtos.InspectResultDto;
import com.flowkraft.jobman.dtos.ProcessOutputResultDto;
import com.flowkraft.jobman.models.FileInfo;
import com.flowkraft.jobman.models.SystemInfo;
import com.flowkraft.jobman.services.SystemService;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api/jobman/system"}, produces={"application/json"}, consumes={"application/json"})
public class SystemController {
    @Autowired
    SystemService systemService;

    @GetMapping(value={"/check-url"})
    public Mono<Boolean> checkUrl(@RequestParam String url) throws Exception {
        String decodedUrl = URLDecoder.decode(url, StandardCharsets.UTF_8.toString());
        WebClient webClient = WebClient.create();
        return webClient.get().uri(decodedUrl, new Object[0]).exchangeToMono(response -> {
            if (response.statusCode().equals(HttpStatus.OK)) {
                return Mono.just((Object)true);
            }
            return Mono.just((Object)false);
        }).onErrorResume(e -> Mono.just((Object)false));
    }

    @GetMapping(value={"/get-changelog"})
    public Mono<String> getChangeLog(@RequestParam String itemName) throws Exception {
        String itemNameDecoded = URLDecoder.decode(itemName, StandardCharsets.UTF_8.toString());
        String url = "https://www.pdfburst.com/store?edd_action=get_version&item_name=" + itemNameDecoded;
        WebClient webClient = WebClient.create();
        return webClient.get().uri(url, new Object[0]).exchangeToMono(response -> {
            if (response.statusCode().is3xxRedirection()) {
                String redirectUrl = response.headers().asHttpHeaders().getLocation().toString();
                return webClient.get().uri(redirectUrl, new Object[0]).retrieve().bodyToMono(String.class);
            }
            return response.bodyToMono(String.class);
        });
    }

    @GetMapping(value={"/get-blog-posts"})
    public Mono<String> getBlogPosts() {
        String url = "https://www.pdfburst.com/blog/feed/";
        WebClient webClient = WebClient.create();
        return webClient.get().uri(url, new Object[0]).retrieve().bodyToMono(String.class).flatMap(body -> {
            XmlMapper xmlMapper = new XmlMapper();
            ObjectMapper jsonMapper = new ObjectMapper();
            return Mono.fromCallable(() -> xmlMapper.readTree(body)).flatMap(xmlNode -> Mono.fromCallable(() -> jsonMapper.writeValueAsString(xmlNode)));
        }).onErrorMap(e -> new RuntimeException("Error converting XML to JSON", (Throwable)e));
    }

    @GetMapping(value={"/info"})
    public Mono<SystemInfo> getSystemInfo() throws Exception {
        SystemInfo info = this.systemService.getSystemInfo();
        return Mono.just((Object)info);
    }

    @GetMapping(value={"/unix-cli/find"})
    public Mono<List<String>> find(@RequestParam String path, @RequestParam List<String> matching, @RequestParam Optional<Boolean> files, @RequestParam Optional<Boolean> directories, @RequestParam Optional<Boolean> recursive, @RequestParam Optional<Boolean> ignoreCase) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        FindCriteriaDto criteriaDto = new FindCriteriaDto(matching, (Boolean)files.orElse(null), (Boolean)directories.orElse(null), (Boolean)recursive.orElse(null), (Boolean)ignoreCase.orElse(null));
        List results = this.systemService.unixCliFind(fullPath, criteriaDto);
        return Mono.just((Object)results);
    }

    @GetMapping(value={"/unix-cli/cat"}, produces={"text/plain"})
    Mono<String> cat(@RequestParam String path) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        String fileContent = this.systemService.unixCliCat(URLDecoder.decode(fullPath, StandardCharsets.UTF_8.toString()));
        return Mono.just((Object)fileContent);
    }

    @DeleteMapping(value={"/fs/delete-quietly"})
    public Mono<Boolean> deleteQuietly(@RequestParam String path) throws Exception {
        String normalizedBaseDirPath;
        String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        String normalizedDecodedPath = decodedPath.replace("\\", "/");
        Object fullPath = normalizedDecodedPath.startsWith(normalizedBaseDirPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH.replace("\\", "/")) ? decodedPath : AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + decodedPath;
        Boolean deleted = this.systemService.fsDelete((String)fullPath);
        return Mono.just((Object)deleted);
    }

    @GetMapping(value={"/fs/read-file-to-string"}, produces={"text/plain"})
    Mono<String> readFileToString(@RequestParam String path) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        String fileContent = this.systemService.unixCliCat(fullPath);
        return Mono.just((Object)fileContent);
    }

    @GetMapping(value={"/fs/resolve-absolute-path"})
    public Map<String, String> resolveAbsolutePath(@RequestParam(value="path") String relativePath) {
        String absolutePath = this.systemService.fsResolvePath(relativePath);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("absolutePath", absolutePath);
        return result;
    }

    @PostMapping(value={"/fs/write-string-to-file"}, consumes={"text/plain"})
    Mono<Void> writeStringToFile(@RequestParam String path, @RequestBody Optional<String> content) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        return Mono.fromCallable(() -> {
            this.systemService.fsWriteStringToFile(fullPath, content);
            return null;
        });
    }

    @PostMapping(value={"/fs/copy"})
    public Mono<Void> copy(@RequestParam String fromPath, @RequestParam String toPath, @RequestParam(defaultValue="false") boolean overwrite, @RequestParam(required=false) String[] matching, @RequestParam(defaultValue="false") boolean ignoreCase) throws Exception {
        String fullFromPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(fromPath, StandardCharsets.UTF_8.toString());
        String fullToPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(toPath, StandardCharsets.UTF_8.toString());
        return Mono.fromCallable(() -> {
            this.systemService.fsCopy(fullFromPath, fullToPath, overwrite, matching, ignoreCase);
            return null;
        });
    }

    @PostMapping(value={"/fs/move"})
    public Mono<Void> move(@RequestParam String fromPath, @RequestParam String toPath, @RequestParam(defaultValue="false") boolean overwrite) {
        return Mono.fromCallable(() -> {
            this.systemService.fsMove(Paths.get(URLDecoder.decode(fromPath, StandardCharsets.UTF_8.toString()), new String[0]), Paths.get(URLDecoder.decode(toPath, StandardCharsets.UTF_8.toString()), new String[0]), overwrite);
            return null;
        });
    }

    @GetMapping(value={"/fs/exists"}, produces={"text/plain"})
    public Mono<String> exists(@RequestParam String path) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        String exists = this.systemService.fsExists(fullPath);
        return Mono.just((Object)exists);
    }

    @PostMapping(value={"/fs/dir"})
    public Mono<Void> dir(@RequestParam String path, @RequestBody Optional<DirCriteriaDto> criteria) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        this.systemService.fsDir(fullPath, criteria);
        return Mono.empty();
    }

    @PostMapping(value={"/fs/file"})
    public Mono<String> file(@RequestParam String path, @RequestBody Optional<FileCriteriaDto> criteria) throws Exception {
        String file = this.systemService.fsFile(URLDecoder.decode(path, StandardCharsets.UTF_8.toString()), criteria);
        return Mono.just((Object)file);
    }

    @GetMapping(value={"/fs/inspect"})
    public Mono<Optional<InspectResultDto>> inspect(@RequestParam String path, @RequestParam Optional<String> checksum, @RequestParam Optional<Boolean> mode, @RequestParam Optional<Boolean> times, @RequestParam Optional<Boolean> absolutePath, @RequestParam Optional<String> symlinks) throws Exception {
        Optional inspect = this.systemService.fsInspect(URLDecoder.decode(path, StandardCharsets.UTF_8.toString()), checksum, mode, times, absolutePath, symlinks);
        return Mono.just((Object)inspect);
    }

    @GetMapping(value={"/fs/list"})
    public Flux<FileInfo> listFiles(@RequestParam String path) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        File directory = new File(fullPath);
        if (!directory.exists() || !directory.isDirectory()) {
            return Flux.empty();
        }
        return Flux.fromArray((Object[])directory.listFiles()).map(file -> {
            FileInfo info = new FileInfo(file.getName(), "", false);
            info.filePath = file.getAbsolutePath();
            info.fileSize = file.length();
            info.isDirectory = file.isDirectory();
            info.lastModified = file.lastModified();
            return info;
        });
    }

    @PostMapping(value={"/child-process/spawn"})
    public Mono<ProcessOutputResultDto> spawn(@RequestBody List<String> args, @RequestParam Optional<String> cwdPath) throws Exception {
        return this.systemService.spawn(args, cwdPath);
    }

    @PostMapping(value={"/install/chocolatey"})
    public Mono<ProcessOutputResultDto> installChocolatey() throws Exception {
        return this.systemService.installChocolatey();
    }

    @PostMapping(value={"/uninstall/chocolatey"})
    public Mono<ProcessOutputResultDto> unInstallChocolatey() throws Exception {
        return this.systemService.unInstallChocolatey();
    }

    @GetMapping(value={"/services/status"})
    public Mono<List<SystemService.ServiceStatusInfo>> getAllServicesStatus() throws Exception {
        List statuses = this.systemService.getAllServicesStatus();
        return Mono.just((Object)statuses);
    }
}

