/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.controllers;

import com.flowkraft.jobman.models.FileInfo;
import com.flowkraft.jobman.models.TailCommandInfo;
import com.flowkraft.jobman.services.LogsService;
import com.flowkraft.jobman.services.SystemService;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api/jobman"}, produces={"application/json"}, consumes={"application/json"})
public class LogsController {
    @Autowired
    LogsService logsService;
    @Autowired
    SystemService fsService;

    @GetMapping(value={"/logs"})
    public Flux<FileInfo> logs() throws Exception {
        return Flux.fromStream((Stream)this.logsService.ls());
    }

    @PutMapping(value={"/logs/tailer"})
    public Mono<ResponseEntity<Void>> tail(@RequestBody TailCommandInfo tailCommandInfo) throws Exception {
        if (tailCommandInfo.command.equals("start")) {
            try {
                this.fsService.startTailer(tailCommandInfo.fileName);
            }
            catch (Exception e) {
                this.fsService.stopTailer(tailCommandInfo.fileName);
                this.fsService.startTailer(tailCommandInfo.fileName);
            }
        } else {
            this.fsService.stopTailer(tailCommandInfo.fileName);
        }
        return Mono.just((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
    }

    @DeleteMapping(value={"/logs/{logFileName}"})
    public Mono<ResponseEntity<Void>> clearLogs(@PathVariable String logFileName) throws Exception {
        this.logsService.clearLogs(logFileName);
        return Mono.just((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
    }
}

