/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.controllers;

import com.flowkraft.common.AppPaths;
import com.flowkraft.jobman.models.ClientServerCommunicationInfo;
import com.flowkraft.jobman.models.FileInfo;
import com.flowkraft.jobman.services.JobsService;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api/jobman"}, produces={"application/json"}, consumes={"application/json"})
public class JobsController {
    @Autowired
    JobsService jobsService;

    @GetMapping(value={"/jobs"})
    public Flux<FileInfo> jobs() throws Exception {
        return Flux.fromStream((Stream)this.jobsService.fetchStats());
    }

    @PostMapping(value={"/jobs"})
    public Mono<ResponseEntity<Void>> doBurst(@RequestBody @NotNull ClientServerCommunicationInfo clientServerCommunicationInfo) throws Exception {
        this.jobsService.doBurst(clientServerCommunicationInfo);
        return Mono.just((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
    }

    @PostMapping(value={"/jobs/pause/cancel"})
    public Mono<ResponseEntity<Void>> doPauseCancelJob(@RequestBody @NotNull ClientServerCommunicationInfo clientServerCommunicationInfo) throws Exception {
        String pauseCancelFilePath = AppPaths.JOBS_DIR_PATH + "/" + FilenameUtils.getBaseName((String)clientServerCommunicationInfo.info) + "." + clientServerCommunicationInfo.id;
        FileUtils.touch((File)new File(pauseCancelFilePath));
        return Mono.just((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
    }

    @PostMapping(value={"/jobs/resume"})
    public Mono<ResponseEntity<Void>> doResumeJob(@RequestBody @NotNull ClientServerCommunicationInfo clientServerCommunicationInfo) throws Exception {
        this.jobsService.doResume(clientServerCommunicationInfo);
        return Mono.just((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
    }

    @DeleteMapping(value={"/jobs/cancel/resume"})
    public Mono<ResponseEntity<Void>> doCancelResumeJob(@RequestBody @NotNull ClientServerCommunicationInfo clientServerCommunicationInfo) throws Exception {
        FileUtils.deleteQuietly((File)new File(clientServerCommunicationInfo.id));
        FileUtils.deleteQuietly((File)new File(clientServerCommunicationInfo.info));
        return Mono.just((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
    }

    @DeleteMapping(value={"/files/quarantine"})
    public Mono<ResponseEntity<Void>> clearQuarantinedFiles() throws Exception {
        File quarantineDirectory = new File(AppPaths.QUARANTINE_DIR_PATH);
        boolean isEmpty = false;
        while (!isEmpty) {
            try {
                FileUtils.cleanDirectory((File)quarantineDirectory);
                isEmpty = FileUtils.isEmptyDirectory((File)quarantineDirectory);
            }
            catch (Exception e) {
                isEmpty = false;
            }
        }
        return Mono.just((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
    }

    @DeleteMapping(value={"/temp/{folderName}"})
    public Mono<ResponseEntity<Void>> clearTempFiles(@PathVariable String folderName) throws Exception {
        long activeJobs = this.jobsService.fetchStats().count();
        if (activeJobs == 0L) {
            FileUtils.deleteQuietly((File)new File(AppPaths.JOBS_DIR_PATH + "/" + folderName));
        }
        return Mono.just((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
    }
}

