/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.controllers;

import com.flowkraft.jobman.config.FileExplorerConfiguration;
import com.flowkraft.jobman.models.FileTreeVO;
import com.flowkraft.jobman.services.FileExplorerService;
import com.flowkraft.jobman.services.SystemService;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api/jobman/file-explorer"})
public class FileExplorerController {
    @Autowired
    private SystemService systemService;
    @Autowired
    private FileExplorerService fileExplorerService;
    @Autowired
    private FileExplorerConfiguration fileExplorerConfig;

    @GetMapping(value={"/meta-info"})
    public Mono<Map<String, Object>> getMetaInfo() {
        return Mono.fromCallable(() -> {
            HashMap<String, Object> metaInfo = new HashMap<String, Object>();
            metaInfo.put("title", this.fileExplorerConfig.getTitle());
            metaInfo.put("description", this.fileExplorerConfig.getDescription());
            metaInfo.put("quickLinks", this.fileExplorerConfig.getQuickLinks());
            metaInfo.put("baseDirPath", this.fileExplorerConfig.getBaseDirPath());
            return metaInfo;
        });
    }

    @GetMapping(value={"/file-tree"})
    public Mono<FileTreeVO> getFileTree(@RequestParam String dir) {
        return Mono.fromCallable(() -> {
            try {
                String decodedPath = URLDecoder.decode(dir, StandardCharsets.UTF_8.toString());
                String fullPath = this.resolveFullPath(decodedPath);
                return this.fileExplorerService.buildFileTree(fullPath);
            }
            catch (Exception e) {
                throw new RuntimeException("Error getting file tree", e);
            }
        });
    }

    @GetMapping(value={"/file-viewer"}, produces={"text/html"})
    public Mono<ResponseEntity<String>> viewFile(@RequestParam String file) {
        return Mono.fromCallable(() -> {
            try {
                String decodedPath = URLDecoder.decode(file, StandardCharsets.UTF_8.toString());
                String fullPath = this.resolveFullPath(decodedPath);
                File fileObj = new File(fullPath);
                if (!(fileObj.exists() && fileObj.isFile() && fileObj.canRead())) {
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"<html><body><h1>404 File Not Found or Not Readable</h1></body></html>");
                }
                String fileContent = this.systemService.unixCliCat(fullPath);
                String fileName = fileObj.getName();
                String fileExtension = FilenameUtils.getExtension((String)fileName).toLowerCase();
                StringBuilder htmlBuilder = new StringBuilder();
                htmlBuilder.append("<!DOCTYPE html>\n<html>\n<head>\n");
                htmlBuilder.append("<title>File Viewer: ").append(fileName).append("</title>\n");
                htmlBuilder.append("<meta charset=\"UTF-8\">\n");
                htmlBuilder.append("<style>\n");
                htmlBuilder.append("body { font-family: Arial, sans-serif; margin: 20px; }\n");
                htmlBuilder.append("pre { background-color: #f5f5f5; padding: 15px; border-radius: 5px; overflow-x: auto; }\n");
                htmlBuilder.append("h1 { color: #333; }\n");
                htmlBuilder.append("</style>\n");
                if (Arrays.asList("js", "ts", "java", "py", "html", "xml", "css", "json", "yml", "yaml").contains(fileExtension)) {
                    htmlBuilder.append("<link href=\"https://cdn.jsdelivr.net/npm/prismjs@1.29.0/themes/prism.min.css\" rel=\"stylesheet\">\n");
                }
                htmlBuilder.append("</head>\n<body>\n");
                htmlBuilder.append("<h1>").append(fileName).append("</h1>\n");
                if (Arrays.asList("jpg", "jpeg", "png", "gif", "bmp", "webp").contains(fileExtension)) {
                    htmlBuilder.append("<img src=\"/api/jobman/file-explorer/file-downloader?file=").append(URLDecoder.decode(file, StandardCharsets.UTF_8.toString())).append("\" style=\"max-width: 100%;\">");
                } else if (fileExtension.equals("pdf")) {
                    htmlBuilder.append("<object data=\"/api/jobman/file-explorer/file-downloader?file=").append(URLDecoder.decode(file, StandardCharsets.UTF_8.toString())).append("\" type=\"application/pdf\" width=\"100%\" height=\"800px\">").append("<p>Unable to display PDF. <a href=\"/api/jobman/file-explorer/file-downloader?file=").append(URLDecoder.decode(file, StandardCharsets.UTF_8.toString())).append("\">Download</a> instead.</p>").append("</object>");
                } else {
                    String language = "";
                    switch (fileExtension) {
                        case "js": {
                            language = "javascript";
                            break;
                        }
                        case "ts": {
                            language = "typescript";
                            break;
                        }
                        case "java": {
                            language = "java";
                            break;
                        }
                        case "py": {
                            language = "python";
                            break;
                        }
                        case "html": {
                            language = "html";
                            break;
                        }
                        case "xml": {
                            language = "xml";
                            break;
                        }
                        case "css": {
                            language = "css";
                            break;
                        }
                        case "json": {
                            language = "json";
                            break;
                        }
                        case "yml": 
                        case "yaml": {
                            language = "yaml";
                            break;
                        }
                        default: {
                            language = "";
                        }
                    }
                    if (!language.isEmpty()) {
                        htmlBuilder.append("<pre><code class=\"language-").append(language).append("\">").append(this.escapeHtml(fileContent)).append("</code></pre>\n");
                    } else {
                        htmlBuilder.append("<pre>").append(this.escapeHtml(fileContent)).append("</pre>\n");
                    }
                    if (!language.isEmpty()) {
                        htmlBuilder.append("<script src=\"https://cdn.jsdelivr.net/npm/prismjs@1.29.0/prism.min.js\"></script>\n");
                        htmlBuilder.append("<script src=\"https://cdn.jsdelivr.net/npm/prismjs@1.29.0/components/prism-").append(language).append(".min.js\"></script>\n");
                    }
                }
                htmlBuilder.append("</body>\n</html>");
                return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)htmlBuilder.toString());
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("<html><body><h1>500 Internal Server Error</h1><p>" + e.getMessage() + "</p></body></html>"));
            }
        });
    }

    @GetMapping(value={"/file-downloader"})
    public Mono<ResponseEntity<FileSystemResource>> downloadFile(@RequestParam String file) {
        return Mono.fromCallable(() -> {
            try {
                String decodedPath = URLDecoder.decode(file, StandardCharsets.UTF_8.toString());
                String fullPath = this.resolveFullPath(decodedPath);
                File fileObj = new File(fullPath);
                if (!(fileObj.exists() && fileObj.isFile() && fileObj.canRead())) {
                    return ResponseEntity.notFound().build();
                }
                String fileName = fileObj.getName();
                String contentType = this.determineContentType(fileName);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentDisposition(ContentDisposition.builder((String)"attachment").filename(fileName).build());
                headers.setContentType(MediaType.parseMediaType((String)contentType));
                headers.setContentLength(fileObj.length());
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)new FileSystemResource(fileObj));
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
            }
        });
    }

    @GetMapping(value={"/file-content"}, produces={"text/plain"})
    public Mono<ResponseEntity<String>> getFileContent(@RequestParam String file) {
        return Mono.fromCallable(() -> {
            try {
                String decodedPath = URLDecoder.decode(file, StandardCharsets.UTF_8.toString());
                String fullPath = this.resolveFullPath(decodedPath);
                File fileObj = new File(fullPath);
                if (!(fileObj.exists() && fileObj.isFile() && fileObj.canRead())) {
                    return ResponseEntity.notFound().build();
                }
                String fileContent = this.systemService.unixCliCat(fullPath);
                return ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).body((Object)fileContent);
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
            }
        });
    }

    @PostMapping(value={"/create-directory"})
    public Mono<Boolean> createDirectory(@RequestBody Map<String, String> request) {
        return Mono.fromCallable(() -> {
            try {
                String path = (String)request.get("path");
                String name = (String)request.get("name");
                if (path == null || name == null || name.trim().isEmpty()) {
                    return false;
                }
                String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
                String fullPath = this.resolveFullPath(decodedPath);
                File parentDir = new File(fullPath);
                if (!(parentDir.exists() && parentDir.isDirectory() && parentDir.canWrite())) {
                    return false;
                }
                File newDir = new File(parentDir, name);
                return newDir.mkdir();
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    @DeleteMapping(value={"/delete"})
    public Mono<Boolean> delete(@RequestParam String path) {
        return Mono.fromCallable(() -> {
            try {
                String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
                String fullPath = this.resolveFullPath(decodedPath);
                File file = new File(fullPath);
                if (!file.exists()) {
                    return false;
                }
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory((File)file);
                } else {
                    file.delete();
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    public Mono<Boolean> upload(@RequestPart(value="file") FilePart filePart, @RequestParam String dir) {
        return Mono.fromCallable(() -> {
            try {
                String decodedDir = URLDecoder.decode(dir, StandardCharsets.UTF_8.toString());
                String fullDir = this.resolveFullPath(decodedDir);
                File targetDir = new File(fullDir);
                if (!(targetDir.exists() && targetDir.isDirectory() && targetDir.canWrite())) {
                    return false;
                }
                Path tempFile = Files.createTempFile("upload-", "-temp", new FileAttribute[0]);
                return (Boolean)filePart.transferTo(tempFile).then(Mono.fromCallable(() -> {
                    File targetFile = new File(targetDir, filePart.filename());
                    Files.copy(tempFile, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    Files.deleteIfExists(tempFile);
                    return true;
                })).onErrorReturn((Object)false).block();
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    private String resolveFullPath(String path) {
        if (path == null || path.trim().isEmpty()) {
            return this.fileExplorerConfig.getBaseDirPath();
        }
        if (path.matches("^/[A-Za-z]:.*")) {
            path = path.substring(1);
        }
        if (!path.matches("^[A-Za-z]:.*") && !path.startsWith("/")) {
            return this.fileExplorerConfig.getBaseDirPath() + "/" + path;
        }
        if (this.fileExplorerConfig.getRestrictToBaseDir().booleanValue()) {
            try {
                File requestedFile = new File(path);
                File baseDir = new File(this.fileExplorerConfig.getBaseDirPath());
                String canonicalRequestedPath = requestedFile.getCanonicalPath();
                String canonicalBasePath = baseDir.getCanonicalPath();
                if (!canonicalRequestedPath.startsWith(canonicalBasePath)) {
                    return this.fileExplorerConfig.getBaseDirPath();
                }
            }
            catch (Exception e) {
                return this.fileExplorerConfig.getBaseDirPath();
            }
        }
        return path;
    }

    private String determineContentType(String fileName) {
        String extension;
        switch (extension = FilenameUtils.getExtension((String)fileName).toLowerCase()) {
            case "png": {
                return "image/png";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "gif": {
                return "image/gif";
            }
            case "svg": {
                return "image/svg+xml";
            }
            case "webp": {
                return "image/webp";
            }
            case "ico": {
                return "image/x-icon";
            }
            case "bmp": {
                return "image/bmp";
            }
            case "pdf": {
                return "application/pdf";
            }
            case "doc": {
                return "application/msword";
            }
            case "docx": {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
            case "xls": {
                return "application/vnd.ms-excel";
            }
            case "xlsx": {
                return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            }
            case "ppt": {
                return "application/vnd.ms-powerpoint";
            }
            case "pptx": {
                return "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            }
            case "css": {
                return "text/css";
            }
            case "js": {
                return "application/javascript";
            }
            case "json": {
                return "application/json";
            }
            case "xml": {
                return "application/xml";
            }
            case "html": 
            case "htm": {
                return "text/html";
            }
            case "txt": {
                return "text/plain";
            }
            case "md": {
                return "text/markdown";
            }
            case "csv": {
                return "text/csv";
            }
            case "zip": {
                return "application/zip";
            }
            case "rar": {
                return "application/x-rar-compressed";
            }
            case "7z": {
                return "application/x-7z-compressed";
            }
            case "tar": {
                return "application/x-tar";
            }
            case "gz": {
                return "application/gzip";
            }
        }
        return "application/octet-stream";
    }

    private String escapeHtml(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }
}

