/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.config;

import com.flowkraft.jobman.security.ApiKeyManager;
import com.flowkraft.jobman.security.WebSocketHandshakeInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfiguration
implements WebSocketMessageBrokerConfigurer {
    @Autowired
    private ApiKeyManager apiKeyManager;
    @Value(value="${reportburster.security.enabled:true}")
    private boolean securityEnabled;

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableSimpleBroker(new String[]{"/topic/execution-stats", "/topic/tailer"});
        config.setApplicationDestinationPrefixes(new String[]{"/api/jobman"});
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/api/jobman/ws"}).setAllowedOriginPatterns(new String[]{"*"}).addInterceptors(new HandshakeInterceptor[]{new WebSocketHandshakeInterceptor(this.apiKeyManager, false)}).withSockJS();
    }
}

