/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.cfgman;

import com.flowkraft.common.AppPaths;
import com.flowkraft.jobman.dtos.FindCriteriaDto;
import com.flowkraft.jobman.services.SystemService;
import com.sourcekraft.documentburster.common.chart.ChartOptions;
import com.sourcekraft.documentburster.common.chart.ChartOptionsParser;
import com.sourcekraft.documentburster.common.pivottable.PivotTableOptions;
import com.sourcekraft.documentburster.common.pivottable.PivotTableOptionsParser;
import com.sourcekraft.documentburster.common.reportparameters.ReportParametersHelper;
import com.sourcekraft.documentburster.common.settings.Settings;
import com.sourcekraft.documentburster.common.settings.model.ConfigurationFileInfo;
import com.sourcekraft.documentburster.common.settings.model.ConnectionFileInfo;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterConnectionDatabaseSettings;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterConnectionEmailSettings;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterSettings;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterSettingsInternal;
import com.sourcekraft.documentburster.common.settings.model.ReportingSettings;
import com.sourcekraft.documentburster.common.tabulator.TabulatorOptions;
import com.sourcekraft.documentburster.common.tabulator.TabulatorOptionsParser;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentBursterSettingsService {
    @Autowired
    SystemService systemService;

    private String extractXmlTagValue(String xmlContent, String tagName, String defaultValue) {
        String openTag = "<" + tagName + ">";
        String closeTag = "</" + tagName + ">";
        int startPos = xmlContent.indexOf(openTag);
        int endPos = xmlContent.indexOf(closeTag);
        if (startPos >= 0 && endPos > startPos) {
            return xmlContent.substring(startPos + openTag.length(), endPos).trim();
        }
        return defaultValue;
    }

    public Stream<ConfigurationFileInfo> loadSettingsAllMinimal() throws Exception {
        ArrayList<ConfigurationFileInfo> configurationFiles = new ArrayList<ConfigurationFileInfo>();
        ArrayList<String> matching = new ArrayList<String>();
        matching.add("*.xml");
        Optional<Boolean> files = Optional.of(true);
        Optional<Boolean> directories = Optional.of(false);
        Optional<Boolean> recursive = Optional.of(false);
        Optional<Boolean> ignoreCase = Optional.of(true);
        FindCriteriaDto criteriaDto = new FindCriteriaDto(matching, (Boolean)files.orElse(null), (Boolean)directories.orElse(null), (Boolean)recursive.orElse(null), (Boolean)ignoreCase.orElse(null));
        List burstConfigFilePaths = this.systemService.unixCliFind(AppPaths.CONFIG_DIR_PATH + "/burst", criteriaDto);
        matching = new ArrayList();
        matching.add("settings.xml");
        files = Optional.of(true);
        directories = Optional.of(false);
        recursive = Optional.of(true);
        ignoreCase = Optional.of(true);
        criteriaDto = new FindCriteriaDto(matching, (Boolean)files.orElse(null), (Boolean)directories.orElse(null), (Boolean)recursive.orElse(null), (Boolean)ignoreCase.orElse(null));
        List reportsConfigFilePaths = this.systemService.unixCliFind(AppPaths.CONFIG_DIR_PATH + "/reports", criteriaDto);
        List samplesConfigFilePaths = this.systemService.unixCliFind(AppPaths.CONFIG_DIR_PATH + "/samples", criteriaDto);
        ArrayList configFilePaths = new ArrayList();
        configFilePaths.addAll(burstConfigFilePaths);
        configFilePaths.addAll(reportsConfigFilePaths);
        configFilePaths.addAll(samplesConfigFilePaths);
        for (String filePath : configFilePaths) {
            String configurationFileName = Paths.get(filePath, new String[0]).getFileName().toString();
            boolean isFallbackSettings = filePath.endsWith("burst/settings.xml");
            boolean isRealSettingsXmlFile = !filePath.endsWith("_defaults/settings.xml") && !filePath.endsWith("preferences/settings.xml") && !filePath.contains("/_frend/");
            if (!isRealSettingsXmlFile) continue;
            String fullFilePath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + filePath;
            String settingsFileContent = this.systemService.unixCliCat(fullFilePath);
            String configurationName = this.extractXmlTagValue(settingsFileContent, "template", "Unknown");
            boolean boolReportDistribution = Boolean.parseBoolean(this.extractXmlTagValue(settingsFileContent, "reportdistribution", "false"));
            boolean boolReportGenerationMailMerge = Boolean.parseBoolean(this.extractXmlTagValue(settingsFileContent, "reportgenerationmailmerge", "false"));
            String strVisibility = this.extractXmlTagValue(settingsFileContent, "visibility", "visible");
            boolean boolUseEmailConnection = Boolean.parseBoolean(this.extractXmlTagValue(settingsFileContent, "useconn", "false"));
            String strEmailConnectionCode = this.extractXmlTagValue(settingsFileContent, "conncode", "");
            String templateRelativeFilePath = "./config/burst/" + configurationFileName;
            String typeOfConfiguration = "config-burst-legacy";
            String folderName = Paths.get(filePath, new String[0]).getParent().getFileName().toString();
            String dsInputType = "";
            String scriptOptionsSelectFileExplorer = "globpattern";
            if (filePath.contains("config/reports/" + folderName)) {
                typeOfConfiguration = "config-reports";
                templateRelativeFilePath = "./config/reports/" + folderName + "/settings.xml";
            } else if (filePath.contains("config/samples/" + folderName)) {
                typeOfConfiguration = "config-samples";
                templateRelativeFilePath = "./config/samples/" + folderName + "/settings.xml";
            }
            if (boolReportGenerationMailMerge) {
                String reportingXmlFilePath = Paths.get(fullFilePath, new String[0]).getParent().toString() + "/reporting.xml";
                String reportingXmlFileContent = this.systemService.unixCliCat(reportingXmlFilePath);
                dsInputType = this.extractXmlTagValue(reportingXmlFileContent, "type", "");
                scriptOptionsSelectFileExplorer = this.extractXmlTagValue(reportingXmlFileContent, "selectfileexplorer", "globpattern");
            }
            ConfigurationFileInfo configFile = new ConfigurationFileInfo();
            configFile.fileName = configurationFileName;
            configFile.filePath = filePath.replace("\\", "/");
            configFile.relativeFilePath = templateRelativeFilePath;
            configFile.templateName = configurationName;
            configFile.isFallback = isFallbackSettings;
            configFile.capReportDistribution = boolReportDistribution;
            configFile.capReportGenerationMailMerge = boolReportGenerationMailMerge;
            configFile.dsInputType = dsInputType;
            configFile.scriptOptionsSelectFileExplorer = scriptOptionsSelectFileExplorer;
            configFile.visibility = strVisibility;
            configFile.notes = "";
            configFile.folderName = folderName;
            configFile.type = typeOfConfiguration;
            configFile.activeClicked = false;
            configFile.useEmlConn = boolUseEmailConnection;
            configFile.emlConnCode = strEmailConnectionCode;
            configurationFiles.add(configFile);
        }
        return configurationFiles.stream();
    }

    public ConfigurationFileInfo loadConfigDetails(String settingsFilePath) throws Exception {
        String pivotConfigFileName;
        Path pivotConfigPath;
        String chartConfigFileName;
        Path chartConfigPath;
        String tabulatorConfigFileName;
        Path tabulatorConfigPath;
        String fullFilePath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + settingsFilePath;
        Path settingsPath = Paths.get(fullFilePath, new String[0]);
        if (!Files.exists(settingsPath, new LinkOption[0])) {
            return null;
        }
        Path itemDir = settingsPath.getParent();
        String folderName = itemDir.getFileName().toString();
        ConfigurationFileInfo configDetails = new ConfigurationFileInfo();
        configDetails.folderName = folderName;
        configDetails.filePath = settingsFilePath.replace("\\", "/");
        if (settingsFilePath.contains("/config/reports/")) {
            configDetails.type = "config-reports";
        } else if (settingsFilePath.contains("/config/samples/")) {
            configDetails.type = "config-samples";
        } else {
            return configDetails;
        }
        String paramsSpecFileName = folderName + "-report-parameters-spec.groovy";
        Path paramsSpecPath = itemDir.resolve(paramsSpecFileName);
        if (Files.exists(paramsSpecPath, new LinkOption[0])) {
            try {
                configDetails.reportParameters = ReportParametersHelper.parseGroovyParametersDslCode((String)Files.readString(paramsSpecPath));
            }
            catch (Exception e) {
                System.err.println("Failed to parse Report Parameters DSL for " + folderName + ": " + e.getMessage());
            }
        }
        if (Files.exists(tabulatorConfigPath = itemDir.resolve(tabulatorConfigFileName = folderName + "-tabulator-config.groovy"), new LinkOption[0])) {
            try {
                TabulatorOptions tabulatorOptions = TabulatorOptionsParser.parseGroovyTabulatorDslCode((String)Files.readString(tabulatorConfigPath));
                if (tabulatorOptions != null) {
                    configDetails.tabulatorOptions = new HashMap();
                    if (tabulatorOptions.getLayoutOptions() != null) {
                        configDetails.tabulatorOptions.put("layoutOptions", tabulatorOptions.getLayoutOptions());
                    }
                    if (tabulatorOptions.getColumns() != null) {
                        configDetails.tabulatorOptions.put("columns", tabulatorOptions.getColumns());
                    }
                    if (tabulatorOptions.getData() != null) {
                        configDetails.tabulatorOptions.put("data", tabulatorOptions.getData());
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to parse Tabulator DSL for " + folderName + ": " + e.getMessage());
            }
        }
        if (Files.exists(chartConfigPath = itemDir.resolve(chartConfigFileName = folderName + "-chart-config.groovy"), new LinkOption[0])) {
            try {
                ChartOptions chartOptions = ChartOptionsParser.parseGroovyChartDslCode((String)Files.readString(chartConfigPath));
                if (chartOptions != null) {
                    configDetails.chartOptions = new HashMap();
                    if (chartOptions.getType() != null) {
                        configDetails.chartOptions.put("type", chartOptions.getType());
                    }
                    if (chartOptions.getLabelField() != null) {
                        configDetails.chartOptions.put("labelField", chartOptions.getLabelField());
                    }
                    if (chartOptions.getOptions() != null && !chartOptions.getOptions().isEmpty()) {
                        configDetails.chartOptions.put("options", chartOptions.getOptions());
                    }
                    if (chartOptions.getLabels() != null && !chartOptions.getLabels().isEmpty()) {
                        configDetails.chartOptions.put("labels", chartOptions.getLabels());
                    }
                    if (chartOptions.getDatasets() != null && !chartOptions.getDatasets().isEmpty()) {
                        configDetails.chartOptions.put("datasets", chartOptions.getDatasets());
                    }
                    if (chartOptions.getData() != null && !chartOptions.getData().isEmpty()) {
                        configDetails.chartOptions.put("data", chartOptions.getData());
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to parse Chart DSL for " + folderName + ": " + e.getMessage());
            }
        }
        if (Files.exists(pivotConfigPath = itemDir.resolve(pivotConfigFileName = folderName + "-pivot-config.groovy"), new LinkOption[0])) {
            try {
                PivotTableOptions pivotOptions = PivotTableOptionsParser.parseGroovyPivotTableDslCode((String)Files.readString(pivotConfigPath));
                if (pivotOptions != null) {
                    configDetails.pivotTableOptions = new HashMap();
                    if (pivotOptions.getRows() != null && !pivotOptions.getRows().isEmpty()) {
                        configDetails.pivotTableOptions.put("rows", pivotOptions.getRows());
                    }
                    if (pivotOptions.getCols() != null && !pivotOptions.getCols().isEmpty()) {
                        configDetails.pivotTableOptions.put("cols", pivotOptions.getCols());
                    }
                    if (pivotOptions.getVals() != null && !pivotOptions.getVals().isEmpty()) {
                        configDetails.pivotTableOptions.put("vals", pivotOptions.getVals());
                    }
                    if (pivotOptions.getAggregatorName() != null) {
                        configDetails.pivotTableOptions.put("aggregatorName", pivotOptions.getAggregatorName());
                    }
                    if (pivotOptions.getRendererName() != null) {
                        configDetails.pivotTableOptions.put("rendererName", pivotOptions.getRendererName());
                    }
                    if (pivotOptions.getRowOrder() != null) {
                        configDetails.pivotTableOptions.put("rowOrder", pivotOptions.getRowOrder());
                    }
                    if (pivotOptions.getColOrder() != null) {
                        configDetails.pivotTableOptions.put("colOrder", pivotOptions.getColOrder());
                    }
                    if (pivotOptions.getValueFilter() != null && !pivotOptions.getValueFilter().isEmpty()) {
                        configDetails.pivotTableOptions.put("valueFilter", pivotOptions.getValueFilter());
                    }
                    if (pivotOptions.getOptions() != null && !pivotOptions.getOptions().isEmpty()) {
                        configDetails.pivotTableOptions.put("options", pivotOptions.getOptions());
                    }
                    if (pivotOptions.getData() != null && !pivotOptions.getData().isEmpty()) {
                        configDetails.pivotTableOptions.put("data", pivotOptions.getData());
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to parse Pivot Table DSL for " + folderName + ": " + e.getMessage());
            }
        }
        return configDetails;
    }

    public Stream<ConfigurationFileInfo> loadSettingsAll() throws Exception {
        ArrayList<ConfigurationFileInfo> configurationFiles = new ArrayList<ConfigurationFileInfo>();
        ArrayList<String> matching = new ArrayList<String>();
        matching.add("*.xml");
        Optional<Boolean> files = Optional.of(true);
        Optional<Boolean> directories = Optional.of(false);
        Optional<Boolean> recursive = Optional.of(false);
        Optional<Boolean> ignoreCase = Optional.of(true);
        FindCriteriaDto criteriaDto = new FindCriteriaDto(matching, (Boolean)files.orElse(null), (Boolean)directories.orElse(null), (Boolean)recursive.orElse(null), (Boolean)ignoreCase.orElse(null));
        List burstConfigFilePaths = this.systemService.unixCliFind(AppPaths.CONFIG_DIR_PATH + "/burst", criteriaDto);
        matching = new ArrayList();
        matching.add("settings.xml");
        files = Optional.of(true);
        directories = Optional.of(false);
        recursive = Optional.of(true);
        ignoreCase = Optional.of(true);
        criteriaDto = new FindCriteriaDto(matching, (Boolean)files.orElse(null), (Boolean)directories.orElse(null), (Boolean)recursive.orElse(null), (Boolean)ignoreCase.orElse(null));
        List reportsConfigFilePaths = this.systemService.unixCliFind(AppPaths.CONFIG_DIR_PATH + "/reports", criteriaDto);
        List samplesConfigFilePaths = this.systemService.unixCliFind(AppPaths.CONFIG_DIR_PATH + "/samples", criteriaDto);
        ArrayList configFilePaths = new ArrayList();
        configFilePaths.addAll(burstConfigFilePaths);
        configFilePaths.addAll(reportsConfigFilePaths);
        configFilePaths.addAll(samplesConfigFilePaths);
        for (String filePath : configFilePaths) {
            String configurationFileName = Paths.get(filePath, new String[0]).getFileName().toString();
            boolean isFallbackSettings = filePath.endsWith("burst/settings.xml");
            boolean isRealSettingsXmlFile = !filePath.endsWith("_defaults/settings.xml") && !filePath.endsWith("preferences/settings.xml") && !filePath.contains("/_frend/");
            if (!isRealSettingsXmlFile) continue;
            String fullFilePath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + filePath;
            String settingsFileContent = this.systemService.unixCliCat(fullFilePath);
            int startPos = settingsFileContent.indexOf("<template>") + "<template>".length();
            int endPos = settingsFileContent.indexOf("</template>");
            String configurationName = settingsFileContent.substring(startPos, endPos).trim();
            startPos = settingsFileContent.indexOf("<reportdistribution>") + "<reportdistribution>".length();
            endPos = settingsFileContent.indexOf("</reportdistribution>");
            boolean boolReportDistribution = Boolean.parseBoolean(settingsFileContent.substring(startPos, endPos).trim());
            startPos = settingsFileContent.indexOf("<reportgenerationmailmerge>") + "<reportgenerationmailmerge>".length();
            endPos = settingsFileContent.indexOf("</reportgenerationmailmerge>");
            boolean boolReportGenerationMailMerge = Boolean.parseBoolean(settingsFileContent.substring(startPos, endPos).trim());
            startPos = settingsFileContent.indexOf("<visibility>") + "<visibility>".length();
            endPos = settingsFileContent.indexOf("</visibility>");
            String strVisibility = settingsFileContent.substring(startPos, endPos).trim();
            startPos = settingsFileContent.indexOf("<useconn>") + "<useconn>".length();
            endPos = settingsFileContent.indexOf("</useconn>");
            boolean boolUseEmailConnection = Boolean.parseBoolean(settingsFileContent.substring(startPos, endPos).trim());
            String strEmailConnectionCode = "";
            if (settingsFileContent.contains("<conncode>")) {
                startPos = settingsFileContent.indexOf("<conncode>") + "<conncode>".length();
                endPos = settingsFileContent.indexOf("</conncode>");
                strEmailConnectionCode = settingsFileContent.substring(startPos, endPos).trim();
            }
            String templateRelativeFilePath = "./config/burst/" + configurationFileName;
            String typeOfConfiguration = "config-burst-legacy";
            String folderName = Paths.get(filePath, new String[0]).getParent().getFileName().toString();
            String dsInputType = "";
            String scriptOptionsSelectFileExplorer = "globpattern";
            if (filePath.contains("config/reports/" + folderName)) {
                typeOfConfiguration = "config-reports";
                templateRelativeFilePath = "./config/reports/" + folderName + "/settings.xml";
            } else if (filePath.contains("config/samples/" + folderName)) {
                typeOfConfiguration = "config-samples";
                templateRelativeFilePath = "./config/samples/" + folderName + "/settings.xml";
            }
            if (boolReportGenerationMailMerge) {
                String reportingXmlFilePath = Paths.get(fullFilePath, new String[0]).getParent().toString() + "/reporting.xml";
                String reportingXmlFileContent = this.systemService.unixCliCat(reportingXmlFilePath);
                startPos = reportingXmlFileContent.indexOf("<type>") + "<type>".length();
                endPos = reportingXmlFileContent.indexOf("</type>");
                dsInputType = reportingXmlFileContent.substring(startPos, endPos).trim();
                startPos = reportingXmlFileContent.indexOf("<selectfileexplorer>") + "<selectfileexplorer>".length();
                endPos = reportingXmlFileContent.indexOf("</selectfileexplorer>");
                if (startPos >= 0 && endPos > startPos) {
                    scriptOptionsSelectFileExplorer = reportingXmlFileContent.substring(startPos, endPos).trim();
                }
            }
            ConfigurationFileInfo configFile = new ConfigurationFileInfo();
            configFile.fileName = configurationFileName;
            configFile.filePath = filePath.replace("\\", "/");
            configFile.relativeFilePath = templateRelativeFilePath;
            configFile.templateName = configurationName;
            configFile.isFallback = isFallbackSettings;
            configFile.capReportDistribution = boolReportDistribution;
            configFile.capReportGenerationMailMerge = boolReportGenerationMailMerge;
            configFile.dsInputType = dsInputType;
            configFile.scriptOptionsSelectFileExplorer = scriptOptionsSelectFileExplorer;
            configFile.visibility = strVisibility;
            configFile.notes = "";
            configFile.folderName = folderName;
            configFile.type = typeOfConfiguration;
            configFile.activeClicked = false;
            configFile.useEmlConn = boolUseEmailConnection;
            configFile.emlConnCode = strEmailConnectionCode;
            if (configFile.capReportGenerationMailMerge && ("config-reports".equals(configFile.type) || "config-samples".equals(configFile.type))) {
                String pivotConfigFileName;
                Path pivotConfigPath;
                String chartConfigFileName;
                Path chartConfigPath;
                String tabulatorConfigFileName;
                Path tabulatorConfigPath;
                String paramsSpecFileName;
                Path baseConfigDir = "config-reports".equals(configFile.type) ? Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "config", "reports") : Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "config", "samples");
                Path itemDir = baseConfigDir.resolve(configFile.folderName);
                Path paramsSpecPath = itemDir.resolve(paramsSpecFileName = configFile.folderName + "-report-parameters-spec.groovy");
                if (Files.exists(paramsSpecPath, new LinkOption[0])) {
                    configFile.reportParameters = ReportParametersHelper.parseGroovyParametersDslCode((String)Files.readString(paramsSpecPath));
                }
                if (Files.exists(tabulatorConfigPath = itemDir.resolve(tabulatorConfigFileName = configFile.folderName + "-tabulator-config.groovy"), new LinkOption[0])) {
                    try {
                        TabulatorOptions tabulatorOptions = TabulatorOptionsParser.parseGroovyTabulatorDslCode((String)Files.readString(tabulatorConfigPath));
                        if (tabulatorOptions != null) {
                            configFile.tabulatorOptions = new HashMap();
                            if (tabulatorOptions.getLayoutOptions() != null) {
                                configFile.tabulatorOptions.put("layoutOptions", tabulatorOptions.getLayoutOptions());
                            }
                            if (tabulatorOptions.getColumns() != null) {
                                configFile.tabulatorOptions.put("columns", tabulatorOptions.getColumns());
                            }
                            if (tabulatorOptions.getData() != null) {
                                configFile.tabulatorOptions.put("data", tabulatorOptions.getData());
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Failed to parse Tabulator DSL for " + configFile.folderName + ": " + e.getMessage());
                    }
                }
                if (Files.exists(chartConfigPath = itemDir.resolve(chartConfigFileName = configFile.folderName + "-chart-config.groovy"), new LinkOption[0])) {
                    try {
                        ChartOptions chartOptions = ChartOptionsParser.parseGroovyChartDslCode((String)Files.readString(chartConfigPath));
                        if (chartOptions != null) {
                            configFile.chartOptions = new HashMap();
                            if (chartOptions.getType() != null) {
                                configFile.chartOptions.put("type", chartOptions.getType());
                            }
                            if (chartOptions.getLabelField() != null) {
                                configFile.chartOptions.put("labelField", chartOptions.getLabelField());
                            }
                            if (chartOptions.getOptions() != null && !chartOptions.getOptions().isEmpty()) {
                                configFile.chartOptions.put("options", chartOptions.getOptions());
                            }
                            if (chartOptions.getLabels() != null && !chartOptions.getLabels().isEmpty()) {
                                configFile.chartOptions.put("labels", chartOptions.getLabels());
                            }
                            if (chartOptions.getDatasets() != null && !chartOptions.getDatasets().isEmpty()) {
                                configFile.chartOptions.put("datasets", chartOptions.getDatasets());
                            }
                            if (chartOptions.getData() != null && !chartOptions.getData().isEmpty()) {
                                configFile.chartOptions.put("data", chartOptions.getData());
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Failed to parse Chart DSL for " + configFile.folderName + ": " + e.getMessage());
                    }
                }
                if (Files.exists(pivotConfigPath = itemDir.resolve(pivotConfigFileName = configFile.folderName + "-pivot-config.groovy"), new LinkOption[0])) {
                    try {
                        PivotTableOptions pivotOptions = PivotTableOptionsParser.parseGroovyPivotTableDslCode((String)Files.readString(pivotConfigPath));
                        if (pivotOptions != null) {
                            configFile.pivotTableOptions = new HashMap();
                            if (pivotOptions.getRows() != null && !pivotOptions.getRows().isEmpty()) {
                                configFile.pivotTableOptions.put("rows", pivotOptions.getRows());
                            }
                            if (pivotOptions.getCols() != null && !pivotOptions.getCols().isEmpty()) {
                                configFile.pivotTableOptions.put("cols", pivotOptions.getCols());
                            }
                            if (pivotOptions.getVals() != null && !pivotOptions.getVals().isEmpty()) {
                                configFile.pivotTableOptions.put("vals", pivotOptions.getVals());
                            }
                            if (pivotOptions.getAggregatorName() != null) {
                                configFile.pivotTableOptions.put("aggregatorName", pivotOptions.getAggregatorName());
                            }
                            if (pivotOptions.getRendererName() != null) {
                                configFile.pivotTableOptions.put("rendererName", pivotOptions.getRendererName());
                            }
                            if (pivotOptions.getRowOrder() != null) {
                                configFile.pivotTableOptions.put("rowOrder", pivotOptions.getRowOrder());
                            }
                            if (pivotOptions.getColOrder() != null) {
                                configFile.pivotTableOptions.put("colOrder", pivotOptions.getColOrder());
                            }
                            if (pivotOptions.getValueFilter() != null && !pivotOptions.getValueFilter().isEmpty()) {
                                configFile.pivotTableOptions.put("valueFilter", pivotOptions.getValueFilter());
                            }
                            if (pivotOptions.getOptions() != null && !pivotOptions.getOptions().isEmpty()) {
                                configFile.pivotTableOptions.put("options", pivotOptions.getOptions());
                            }
                            if (pivotOptions.getData() != null && !pivotOptions.getData().isEmpty()) {
                                configFile.pivotTableOptions.put("data", pivotOptions.getData());
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Failed to parse Pivot Table DSL for " + configFile.folderName + ": " + e.getMessage());
                    }
                }
            }
            configurationFiles.add(configFile);
        }
        return configurationFiles.stream();
    }

    public DocumentBursterSettings loadSettings(String configFilePath) throws Exception {
        Settings settings = new Settings(configFilePath);
        return settings.loadSettings();
    }

    public void saveSettings(DocumentBursterSettings settings, String configFilePath) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{DocumentBursterSettings.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        try (FileOutputStream os = new FileOutputStream(configFilePath);){
            marshaller.marshal((Object)settings, (OutputStream)os);
        }
    }

    public ReportingSettings loadSettingsReporting(String configFilePath) throws Exception {
        Settings settings = new Settings(configFilePath);
        settings.loadSettings();
        return settings.reportingSettings;
    }

    public void saveSettingsReporting(ReportingSettings settings, String configFilePath) throws Exception {
        String configFolderPath = Paths.get(configFilePath, new String[0]).getParent().toString();
        String reportingConfigFilePath = configFolderPath + "/reporting.xml";
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ReportingSettings.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        try (FileOutputStream os = new FileOutputStream(reportingConfigFilePath);){
            marshaller.marshal((Object)settings, (OutputStream)os);
        }
    }

    public Stream<ConnectionFileInfo> loadSettingsConnectionEmailAll() throws Exception {
        ArrayList<ConnectionFileInfo> connectionFiles = new ArrayList<ConnectionFileInfo>();
        ArrayList<String> matching = new ArrayList<String>();
        matching.add("*.xml");
        Optional<Boolean> files = Optional.of(true);
        Optional<Boolean> directories = Optional.of(false);
        Optional<Boolean> recursive = Optional.of(false);
        Optional<Boolean> ignoreCase = Optional.of(true);
        FindCriteriaDto criteriaDto = new FindCriteriaDto(matching, (Boolean)files.orElse(null), (Boolean)directories.orElse(null), (Boolean)recursive.orElse(null), (Boolean)ignoreCase.orElse(null));
        List connectionFilePaths = this.systemService.unixCliFind(AppPaths.CONFIG_DIR_PATH + "/connections", criteriaDto);
        for (String filePath : connectionFilePaths) {
            String connectionFileName = Paths.get(filePath, new String[0]).getFileName().toString();
            DocumentBursterConnectionEmailSettings rbConnection = this.loadSettingsConnectionEmail(filePath);
            ConnectionFileInfo connFileInfo = new ConnectionFileInfo();
            connFileInfo.fileName = connectionFileName;
            connFileInfo.filePath = filePath.replace("\\", "/");
            connFileInfo.connectionCode = rbConnection.connection.code;
            connFileInfo.connectionName = rbConnection.connection.name;
            connFileInfo.connectionType = connectionFileName.startsWith("eml-") ? "email-connection" : "database-connection";
            connFileInfo.activeClicked = false;
            connFileInfo.defaultConnection = rbConnection.connection.defaultConnection;
            connFileInfo.usedBy = "";
            connFileInfo.emailserver.host = rbConnection.connection.emailserver.host;
            connFileInfo.emailserver.port = rbConnection.connection.emailserver.port;
            connFileInfo.emailserver.userid = rbConnection.connection.emailserver.userid;
            connFileInfo.emailserver.userpassword = rbConnection.connection.emailserver.userpassword;
            connFileInfo.emailserver.usessl = rbConnection.connection.emailserver.usessl;
            connFileInfo.emailserver.usetls = rbConnection.connection.emailserver.usetls;
            connFileInfo.emailserver.fromaddress = rbConnection.connection.emailserver.fromaddress;
            connFileInfo.emailserver.name = rbConnection.connection.emailserver.name;
            connectionFiles.add(connFileInfo);
        }
        return connectionFiles.stream();
    }

    public DocumentBursterConnectionEmailSettings loadSettingsConnectionEmail(String connectionCode) throws Exception {
        Settings settings = new Settings(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/config/burst/settings.xml");
        settings.loadSettingsConnectionEmail(connectionCode);
        return settings.connectionEmailSettings;
    }

    public void saveSettingsConnectionEmail(DocumentBursterConnectionEmailSettings settings, String connectionFilePath) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{DocumentBursterConnectionEmailSettings.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        try (FileOutputStream os = new FileOutputStream(connectionFilePath);){
            marshaller.marshal((Object)settings, (OutputStream)os);
        }
    }

    public Stream<ConnectionFileInfo> loadSettingsConnectionDatabaseAll() throws Exception {
        File connectionsFolder = new File(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/config/connections");
        if (!connectionsFolder.exists()) {
            return Stream.empty();
        }
        File[] connectionFolders = connectionsFolder.listFiles((dir, name) -> new File(dir, name).isDirectory() && name.toLowerCase().startsWith("db-"));
        if (connectionFolders == null || connectionFolders.length == 0) {
            return Stream.empty();
        }
        ArrayList<ConnectionFileInfo> connectionInfoFiles = new ArrayList<ConnectionFileInfo>();
        for (File connectionFolder : connectionFolders) {
            DocumentBursterConnectionDatabaseSettings connectionSettings;
            File mainXmlFile = new File(connectionFolder, connectionFolder.getName() + ".xml");
            if (!mainXmlFile.exists() || (connectionSettings = this.loadSettingsConnectionDatabase(mainXmlFile.getAbsolutePath())) == null || connectionSettings.connection == null) continue;
            ConnectionFileInfo connectionInfo = new ConnectionFileInfo();
            connectionInfo.fileName = mainXmlFile.getName();
            connectionInfo.filePath = mainXmlFile.getAbsolutePath().replace("\\", "/");
            connectionInfo.connectionCode = connectionSettings.connection.code;
            connectionInfo.connectionName = connectionSettings.connection.name;
            connectionInfo.connectionType = "database-connection";
            connectionInfo.defaultConnection = connectionSettings.connection.defaultConnection;
            connectionInfo.usedBy = "";
            connectionInfo.dbserver.type = connectionSettings.connection.databaseserver.type;
            connectionInfo.dbserver.host = connectionSettings.connection.databaseserver.host;
            connectionInfo.dbserver.port = connectionSettings.connection.databaseserver.port;
            connectionInfo.dbserver.database = connectionSettings.connection.databaseserver.database;
            connectionInfo.dbserver.userid = connectionSettings.connection.databaseserver.userid;
            connectionInfo.dbserver.userpassword = connectionSettings.connection.databaseserver.userpassword;
            connectionInfo.dbserver.usessl = connectionSettings.connection.databaseserver.usessl;
            connectionInfo.dbserver.defaultquery = connectionSettings.connection.databaseserver.defaultquery;
            connectionInfo.dbserver.driver = connectionSettings.connection.databaseserver.driver;
            connectionInfo.dbserver.url = connectionSettings.connection.databaseserver.url;
            connectionInfoFiles.add(connectionInfo);
        }
        return connectionInfoFiles.stream();
    }

    public DocumentBursterConnectionDatabaseSettings loadSettingsConnectionDatabase(String filePath) throws Exception {
        File connectionFile = new File(filePath);
        if (!connectionFile.exists()) {
            throw new Exception("Database connection file not found: " + filePath);
        }
        try (FileInputStream inputStream = new FileInputStream(connectionFile);){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DocumentBursterConnectionDatabaseSettings.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            DocumentBursterConnectionDatabaseSettings documentBursterConnectionDatabaseSettings = (DocumentBursterConnectionDatabaseSettings)unmarshaller.unmarshal((InputStream)inputStream);
            return documentBursterConnectionDatabaseSettings;
        }
    }

    public void saveSettingsConnectionDatabase(DocumentBursterConnectionDatabaseSettings dbSettings, String filePath) throws Exception {
        File file = new File(filePath);
        File folderPath = file.getParentFile();
        if (!folderPath.exists()) {
            folderPath.mkdirs();
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DocumentBursterConnectionDatabaseSettings.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        try (FileOutputStream outputStream = new FileOutputStream(filePath);){
            marshaller.marshal((Object)dbSettings, (OutputStream)outputStream);
        }
    }

    public DocumentBursterSettingsInternal loadSettingsInternal(String internalConfigFilePath) throws Exception {
        Settings settings = new Settings(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/config/burst/settings.xml");
        return settings.loadSettingsInternal();
    }

    public void saveSettingsInternal(DocumentBursterSettingsInternal dbSettingsInternal, String internalConfigFilePath) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{DocumentBursterSettingsInternal.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        try (FileOutputStream os = new FileOutputStream(internalConfigFilePath);){
            marshaller.marshal((Object)dbSettingsInternal, (OutputStream)os);
        }
    }

    public Stream<ConfigurationFileInfo> loadRbTemplatesAll() throws Exception {
        ArrayList<ConfigurationFileInfo> templateFiles = new ArrayList<ConfigurationFileInfo>();
        ArrayList<String> matching = new ArrayList<String>();
        matching.add("*.docx");
        matching.add("*.html");
        matching.add("*.fo");
        matching.add("*.xsl");
        matching.add("*.xslt");
        Optional<Boolean> files = Optional.of(true);
        Optional<Boolean> directories = Optional.of(false);
        Optional<Boolean> recursive = Optional.of(true);
        Optional<Boolean> ignoreCase = Optional.of(true);
        FindCriteriaDto criteriaDto = new FindCriteriaDto(matching, (Boolean)files.orElse(null), (Boolean)directories.orElse(null), (Boolean)recursive.orElse(null), (Boolean)ignoreCase.orElse(null));
        List reportTemplatesFilePaths = this.systemService.unixCliFind(AppPaths.TEMPLATES_DIR_PATH + "/reports", criteriaDto);
        List samplesTemplatesFilePaths = this.systemService.unixCliFind(AppPaths.SAMPLES_DIR_PATH + "/reports", criteriaDto);
        ArrayList templateFilePaths = new ArrayList();
        templateFilePaths.addAll(reportTemplatesFilePaths);
        templateFilePaths.addAll(samplesTemplatesFilePaths);
        for (String filePath : templateFilePaths) {
            String reportTemplateFileName = Paths.get(filePath, new String[0]).getFileName().toString();
            String folderName = Paths.get(filePath, new String[0]).getParent().getFileName().toString();
            String relativeFilePath = filePath.replace("templates/reports/", "");
            String tplType = "template-report";
            if (filePath.contains("samples/reports")) {
                tplType = "template-report-sample";
                relativeFilePath = filePath.replace("samples/reports/", "");
            }
            ConfigurationFileInfo templateFile = new ConfigurationFileInfo();
            templateFile.fileName = reportTemplateFileName;
            templateFile.filePath = filePath.replace("\\", "/");
            templateFile.folderName = folderName;
            templateFile.type = tplType;
            templateFile.relativeFilePath = relativeFilePath;
            templateFiles.add(templateFile);
        }
        return templateFiles.stream();
    }
}

