/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft;

import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EnableScheduling
@ComponentScan(basePackages={"com.flowkraft"})
public class ServerApplication
implements ExitCodeGenerator {
    private static int exitCode;

    public static void main(String[] args) {
        String serveWebProp = System.getProperty("SERVE_WEB");
        String serveWebEnv = System.getenv("SERVE_WEB");
        boolean serveWeb = "true".equalsIgnoreCase(serveWebProp) || "true".equalsIgnoreCase(serveWebEnv);
        SpringApplicationBuilder appBuilder = new SpringApplicationBuilder(new Class[]{ServerApplication.class});
        long pid = ServerApplication.getPid();
        if (!serveWeb) {
            System.out.println("Started ServerApplication with PID " + pid + " serveWeb=false");
            appBuilder.web(WebApplicationType.NONE);
            exitCode = SpringApplication.exit((ApplicationContext)appBuilder.run(args), (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        } else {
            appBuilder.web(WebApplicationType.SERVLET);
            appBuilder.listeners(new ApplicationListener[]{event -> {
                if (event instanceof ApplicationReadyEvent) {
                    System.out.println("Started ServerApplication with PID " + pid + " serveWeb=true");
                }
            }});
            appBuilder.run(args);
        }
        System.setProperty("spring.devtools.restart.enabled", "false");
    }

    private static long getPid() {
        try {
            return ProcessHandle.current().pid();
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public int getExitCode() {
        return exitCode;
    }
}

