/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.crypto.SecretKey;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKEKRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEGenerator;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;

public class SMIMEEnvelopedGenerator
extends SMIMEGenerator {
    public static final String DES_EDE3_CBC = CMSEnvelopedDataGenerator.DES_EDE3_CBC;
    public static final String RC2_CBC = CMSEnvelopedDataGenerator.RC2_CBC;
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = CMSEnvelopedDataGenerator.AES128_CBC;
    public static final String AES192_CBC = CMSEnvelopedDataGenerator.AES192_CBC;
    public static final String AES256_CBC = CMSEnvelopedDataGenerator.AES256_CBC;
    public static final String CAMELLIA128_CBC = CMSEnvelopedDataGenerator.CAMELLIA128_CBC;
    public static final String CAMELLIA192_CBC = CMSEnvelopedDataGenerator.CAMELLIA192_CBC;
    public static final String CAMELLIA256_CBC = CMSEnvelopedDataGenerator.CAMELLIA256_CBC;
    public static final String SEED_CBC = CMSEnvelopedDataGenerator.SEED_CBC;
    public static final String DES_EDE3_WRAP = CMSEnvelopedDataGenerator.DES_EDE3_WRAP;
    public static final String AES128_WRAP = CMSEnvelopedDataGenerator.AES128_WRAP;
    public static final String AES256_WRAP = CMSEnvelopedDataGenerator.AES256_WRAP;
    public static final String CAMELLIA128_WRAP = CMSEnvelopedDataGenerator.CAMELLIA128_WRAP;
    public static final String CAMELLIA192_WRAP = CMSEnvelopedDataGenerator.CAMELLIA192_WRAP;
    public static final String CAMELLIA256_WRAP = CMSEnvelopedDataGenerator.CAMELLIA256_WRAP;
    public static final String SEED_WRAP = CMSEnvelopedDataGenerator.SEED_WRAP;
    public static final String ECDH_SHA1KDF = CMSEnvelopedDataGenerator.ECDH_SHA1KDF;
    private static final String ENCRYPTED_CONTENT_TYPE = "application/pkcs7-mime; name=\"smime.p7m\"; smime-type=enveloped-data";
    private EnvelopedGenerator fact;
    private List recipients = new ArrayList();

    private static MailcapCommandMap addCommands(CommandMap commandMap) {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)commandMap;
        mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        return mailcapCommandMap;
    }

    public SMIMEEnvelopedGenerator() {
        this.fact = new EnvelopedGenerator();
    }

    public void addRecipientInfoGenerator(RecipientInfoGenerator recipientInfoGenerator) throws IllegalArgumentException {
        this.fact.addRecipientInfoGenerator(recipientInfoGenerator);
    }

    public void addKeyTransRecipient(X509Certificate x509Certificate) throws IllegalArgumentException {
        try {
            JceKeyTransRecipientInfoGenerator jceKeyTransRecipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(x509Certificate);
            this.recipients.add(jceKeyTransRecipientInfoGenerator);
            this.fact.addRecipientInfoGenerator(jceKeyTransRecipientInfoGenerator);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException(certificateEncodingException.toString());
        }
    }

    public void addKeyTransRecipient(PublicKey publicKey, byte[] byArray) throws IllegalArgumentException {
        JceKeyTransRecipientInfoGenerator jceKeyTransRecipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(byArray, publicKey);
        this.recipients.add(jceKeyTransRecipientInfoGenerator);
        this.fact.addRecipientInfoGenerator(jceKeyTransRecipientInfoGenerator);
    }

    public void addKEKRecipient(SecretKey secretKey, byte[] byArray) throws IllegalArgumentException {
        JceKEKRecipientInfoGenerator jceKEKRecipientInfoGenerator = new JceKEKRecipientInfoGenerator(byArray, secretKey);
        this.recipients.add(jceKEKRecipientInfoGenerator);
        this.fact.addRecipientInfoGenerator(jceKEKRecipientInfoGenerator);
    }

    public void addKeyAgreementRecipient(String string, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string2, String string3) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipient(string, privateKey, publicKey, x509Certificate, string2, string3);
    }

    public void addKeyAgreementRecipient(String string, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string2, Provider provider) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        try {
            JceKeyAgreeRecipientInfoGenerator jceKeyAgreeRecipientInfoGenerator = new JceKeyAgreeRecipientInfoGenerator(new ASN1ObjectIdentifier(string), privateKey, publicKey, new ASN1ObjectIdentifier(string2));
            jceKeyAgreeRecipientInfoGenerator.addRecipient(x509Certificate);
            if (provider != null) {
                jceKeyAgreeRecipientInfoGenerator.setProvider(provider);
            }
            this.fact.addRecipientInfoGenerator(jceKeyAgreeRecipientInfoGenerator);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new NoSuchAlgorithmException("cannot set up generator: " + certificateEncodingException);
        }
        catch (CMSException cMSException) {
            throw new NoSuchAlgorithmException("cannot set up generator: " + cMSException);
        }
    }

    public void setBerEncodeRecipients(boolean bl) {
        this.fact.setBEREncodeRecipients(bl);
    }

    private MimeBodyPart make(MimeBodyPart mimeBodyPart, ASN1ObjectIdentifier aSN1ObjectIdentifier, int n, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        this.createSymmetricKeyGenerator(aSN1ObjectIdentifier.getId(), provider);
        try {
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart2.setContent((Object)new ContentEncryptor(mimeBodyPart, aSN1ObjectIdentifier, n, provider), ENCRYPTED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Type", ENCRYPTED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            mimeBodyPart2.addHeader("Content-Description", "S/MIME Encrypted Message");
            mimeBodyPart2.addHeader("Content-Transfer-Encoding", this.encoding);
            return mimeBodyPart2;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting S/MIME message together.", (Exception)((Object)messagingException));
        }
        catch (CMSException cMSException) {
            throw new SMIMEException("exception putting envelope together.", cMSException);
        }
    }

    private MimeBodyPart make(MimeBodyPart mimeBodyPart, OutputEncryptor outputEncryptor) throws SMIMEException {
        try {
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart2.setContent((Object)new ContentEncryptor(mimeBodyPart, outputEncryptor), ENCRYPTED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Type", ENCRYPTED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            mimeBodyPart2.addHeader("Content-Description", "S/MIME Encrypted Message");
            mimeBodyPart2.addHeader("Content-Transfer-Encoding", this.encoding);
            return mimeBodyPart2;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)messagingException));
        }
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, OutputEncryptor outputEncryptor) throws SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), outputEncryptor);
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, OutputEncryptor outputEncryptor) throws SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.make(this.makeContentBodyPart(mimeMessage), outputEncryptor);
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), new ASN1ObjectIdentifier(string), 0, SMIMEUtil.getProvider(string2));
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, String string, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), new ASN1ObjectIdentifier(string), 0, provider);
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.generate(mimeMessage, string, SMIMEUtil.getProvider(string2));
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, String string, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.make(this.makeContentBodyPart(mimeMessage), new ASN1ObjectIdentifier(string), 0, provider);
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.generate(mimeBodyPart, string, n, SMIMEUtil.getProvider(string2));
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, String string, int n, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), new ASN1ObjectIdentifier(string), n, provider);
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.generate(mimeMessage, string, n, SMIMEUtil.getProvider(string2));
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, String string, int n, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.make(this.makeContentBodyPart(mimeMessage), new ASN1ObjectIdentifier(string), n, provider);
    }

    static {
        CommandMap.setDefaultCommandMap((CommandMap)SMIMEEnvelopedGenerator.addCommands(CommandMap.getDefaultCommandMap()));
    }

    private class ContentEncryptor
    implements SMIMEStreamingProcessor {
        private final MimeBodyPart _content;
        private OutputEncryptor _encryptor;
        private boolean _firstTime = true;

        ContentEncryptor(MimeBodyPart mimeBodyPart, ASN1ObjectIdentifier aSN1ObjectIdentifier, int n, Provider provider) throws CMSException {
            this._content = mimeBodyPart;
            this._encryptor = n == 0 ? new JceCMSContentEncryptorBuilder(aSN1ObjectIdentifier).setProvider(provider).build() : new JceCMSContentEncryptorBuilder(aSN1ObjectIdentifier, n).setProvider(provider).build();
            if (provider != null) {
                for (RecipientInfoGenerator recipientInfoGenerator : SMIMEEnvelopedGenerator.this.recipients) {
                    try {
                        if (recipientInfoGenerator instanceof JceKeyTransRecipientInfoGenerator) {
                            ((JceKeyTransRecipientInfoGenerator)recipientInfoGenerator).setProvider(provider);
                            continue;
                        }
                        if (!(recipientInfoGenerator instanceof JceKEKRecipientInfoGenerator)) continue;
                        ((JceKEKRecipientInfoGenerator)recipientInfoGenerator).setProvider(provider);
                    }
                    catch (OperatorCreationException operatorCreationException) {
                        throw new CMSException("cannot create recipient: " + operatorCreationException.getMessage(), operatorCreationException);
                    }
                }
            }
        }

        ContentEncryptor(MimeBodyPart mimeBodyPart, OutputEncryptor outputEncryptor) {
            this._content = mimeBodyPart;
            this._encryptor = outputEncryptor;
        }

        public void write(OutputStream outputStream) throws IOException {
            try {
                OutputStream outputStream2;
                if (this._firstTime) {
                    outputStream2 = SMIMEEnvelopedGenerator.this.fact.open(outputStream, this._encryptor);
                    this._firstTime = false;
                } else {
                    outputStream2 = SMIMEEnvelopedGenerator.this.fact.regenerate(outputStream, this._encryptor);
                }
                this._content.getDataHandler().setCommandMap((CommandMap)SMIMEEnvelopedGenerator.addCommands(CommandMap.getDefaultCommandMap()));
                this._content.writeTo(outputStream2);
                outputStream2.close();
            }
            catch (MessagingException messagingException) {
                throw new WrappingIOException(messagingException.toString(), messagingException);
            }
            catch (CMSException cMSException) {
                throw new WrappingIOException(cMSException.toString(), cMSException);
            }
        }
    }

    private class EnvelopedGenerator
    extends CMSEnvelopedDataStreamGenerator {
        private ASN1ObjectIdentifier dataType;
        private ASN1EncodableVector recipientInfos;

        private EnvelopedGenerator() {
        }

        protected OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, ASN1EncodableVector aSN1EncodableVector, OutputEncryptor outputEncryptor) throws IOException {
            this.dataType = aSN1ObjectIdentifier;
            this.recipientInfos = aSN1EncodableVector;
            return super.open(aSN1ObjectIdentifier, outputStream, aSN1EncodableVector, outputEncryptor);
        }

        OutputStream regenerate(OutputStream outputStream, OutputEncryptor outputEncryptor) throws IOException {
            return super.open(this.dataType, outputStream, this.recipientInfos, outputEncryptor);
        }
    }

    private static class WrappingIOException
    extends IOException {
        private Throwable cause;

        WrappingIOException(String string, Throwable throwable) {
            super(string);
            this.cause = throwable;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }
}

