/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.utils;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.sourcekraft.documentburster.common.settings.model.EmailSettings;
import com.sourcekraft.documentburster.common.settings.model.SmsSettings;
import com.sourcekraft.documentburster.common.settings.model.UploadSettings;
import com.sourcekraft.documentburster.common.settings.model.WebUploadSettings;
import com.sourcekraft.documentburster.context.BurstingContext;
import com.sourcekraft.documentburster.utils.DocumentBursterFreemarkerInitializer;
import com.sourcekraft.documentburster.variables.DateRenderer;
import com.sourcekraft.documentburster.variables.Variables;
import freemarker.template.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static Logger log = LoggerFactory.getLogger(Utils.class);
    public static final String SPLIT_2ND_TIME = "split_2nd_time";
    public static final String PDFBURST_WEBSITE = "https://www.pdfburst.com";
    public static final String NULL_STRING_VALUE = "null";

    public static String getProduct() {
        if (new File("startServer.bat").exists() || new File("startServer.sh").exists()) {
            return "DocumentBurster Server";
        }
        return "DocumentBurster";
    }

    public static String getProductPermalink() {
        if (new File("startServer.bat").exists() || new File("startServer.sh").exists()) {
            return "documentburster-server";
        }
        return "documentburster";
    }

    public static String getProductName(String version) {
        return "DocumentBurster " + version;
    }

    public static String getFileNameOfBurstDocument(String defaultFileName, String token) {
        if (StringUtils.isNotEmpty((CharSequence)defaultFileName)) {
            return defaultFileName;
        }
        return token + ".pdf";
    }

    public static String getTempFolder() {
        String portableDir = System.getProperty("PORTABLE_EXECUTABLE_DIR");
        if (StringUtils.isNotBlank((CharSequence)portableDir)) {
            return new File(portableDir, "temp").getAbsolutePath() + "/";
        }
        String homeDir = System.getProperty("DOCUMENTBURSTER_HOME");
        if (StringUtils.isNotBlank((CharSequence)homeDir)) {
            return new File(homeDir, "temp").getAbsolutePath() + "/";
        }
        return "./temp/";
    }

    public static String getDbFolderPath() {
        String portableDir = System.getProperty("PORTABLE_EXECUTABLE_DIR");
        if (StringUtils.isNotBlank((CharSequence)portableDir)) {
            return new File(portableDir, "db").getAbsolutePath() + "/";
        }
        String homeDir = System.getProperty("DOCUMENTBURSTER_HOME");
        if (StringUtils.isNotBlank((CharSequence)homeDir)) {
            return new File(homeDir, "db").getAbsolutePath() + "/";
        }
        return "./db/";
    }

    public static String getAppsFolderPath() {
        String portableDir = System.getProperty("PORTABLE_EXECUTABLE_DIR");
        if (StringUtils.isNotBlank((CharSequence)portableDir)) {
            return new File(portableDir, "_apps").getAbsolutePath() + "/";
        }
        String homeDir = System.getProperty("DOCUMENTBURSTER_HOME");
        if (StringUtils.isNotBlank((CharSequence)homeDir)) {
            return new File(homeDir, "_apps").getAbsolutePath() + "/";
        }
        return "./_apps/";
    }

    public static String getConfigurationFolderPath(String configurationFilePath) {
        if (StringUtils.isBlank((CharSequence)configurationFilePath)) {
            return "./config";
        }
        return Utils.getParentFolderPathHavingName(configurationFilePath, "config");
    }

    public static String getPortableExecutableDir() {
        String portableDir = System.getProperty("PORTABLE_EXECUTABLE_DIR");
        boolean fromSystemProperty = true;
        if (StringUtils.isBlank((CharSequence)portableDir)) {
            portableDir = System.getenv("PORTABLE_EXECUTABLE_DIR");
            fromSystemProperty = false;
        }
        if (StringUtils.isBlank((CharSequence)portableDir)) {
            return "";
        }
        if (fromSystemProperty) {
            try {
                Path p = Paths.get(portableDir, new String[0]);
                if (!p.isAbsolute()) {
                    p = p.toAbsolutePath().normalize();
                }
                return p.toString().replace("\\", "/");
            }
            catch (Exception e) {
                return portableDir.replace("\\", "/");
            }
        }
        try {
            Path p = Paths.get(portableDir, new String[0]);
            if (p.isAbsolute()) {
                return p.toAbsolutePath().normalize().toString().replace("\\", "/");
            }
            return portableDir.replace("\\", "/");
        }
        catch (Exception e) {
            return portableDir.replace("\\", "/");
        }
    }

    public static String getRandomJobFileName() {
        return Utils.getRandomFileName("temp.job");
    }

    public static String getRandomFileName(String fileName) {
        return FilenameUtils.getBaseName((String)fileName) + "-" + StringUtils.substring((String)UUID.randomUUID().toString(), (int)0, (int)3) + "." + FilenameUtils.getExtension((String)fileName);
    }

    public static void archiveLogFiles(String logsArchivesFolder) throws Exception {
        String logsFolderPath = Utils.getParentFolderPathHavingName(logsArchivesFolder, "logs");
        ArrayList<File> logFiles = new ArrayList<File>();
        logFiles.add(new File(logsFolderPath + "/info.log"));
        logFiles.add(new File(logsFolderPath + "/errors.log"));
        logFiles.add(new File(logsFolderPath + "/warnings.log"));
        for (File logFile : logFiles) {
            String destFilePath = logsArchivesFolder + "/" + FilenameUtils.getName((String)logFile.getCanonicalPath());
            try {
                FileUtils.copyFile((File)logFile, (File)new File(destFilePath));
            }
            catch (Exception exception) {}
        }
    }

    public static String getOutputFolder(String outputFolder) {
        int pos = outputFolder.indexOf(34, 0);
        if (pos >= 0) {
            return outputFolder.substring(1, outputFolder.length() - 1);
        }
        return outputFolder;
    }

    public static int getQuarter(Date date, Locale locale) {
        Calendar cal = locale == null ? Calendar.getInstance() : Calendar.getInstance(locale);
        cal.setTime(date);
        int month = cal.get(2);
        return month / 3 + 1;
    }

    public static String getStringFromTemplate(String template, Variables variables, String token) throws Exception {
        log.debug("getStringFromTemplate(String template,Variables variables) : template=" + template + ", variables=" + variables);
        String freeMarkerTest = StringUtils.substringBetween((String)template, (String)"${", (String)"}");
        String stringTemplateTest = "";
        if (StringUtils.isEmpty((CharSequence)freeMarkerTest)) {
            stringTemplateTest = StringUtils.substringBetween((String)template, (String)"$", (String)"$");
        }
        if (StringUtils.isEmpty((CharSequence)stringTemplateTest) && StringUtils.isEmpty((CharSequence)freeMarkerTest)) {
            return template;
        }
        if (!StringUtils.isEmpty((CharSequence)stringTemplateTest) && StringUtils.isEmpty((CharSequence)freeMarkerTest)) {
            StringTemplate engine = new StringTemplate();
            engine.registerRenderer(Date.class, (AttributeRenderer)new DateRenderer());
            engine.setTemplate(template);
            engine.setAttributes(variables.getUserVariables(token));
            log.debug("getStringFromTemplate(String template,Variables variables) : returns = " + engine);
            return engine.toString();
        }
        Template engine = new Template("template", template, DocumentBursterFreemarkerInitializer.FREE_MARKER_CFG);
        StringWriter stringWriter = new StringWriter();
        engine.process(variables.getUserVariables(token), (Writer)stringWriter);
        stringWriter.flush();
        return stringWriter.toString();
    }

    public static boolean isValidFtpCommand(BurstingContext ctx, UploadSettings uploadSettings) throws Exception {
        String command = Utils.getStringFromTemplate(uploadSettings.ftpcommand, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)command);
    }

    public static boolean isValidFileShareCommand(BurstingContext ctx, UploadSettings uploadSettings) throws Exception {
        String command = Utils.getStringFromTemplate(uploadSettings.filesharecommand, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)command);
    }

    public static boolean isValidFtpsCommand(BurstingContext ctx, UploadSettings uploadSettings) throws Exception {
        String command = Utils.getStringFromTemplate(uploadSettings.ftpscommand, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)command);
    }

    public static boolean isValidSftpCommand(BurstingContext ctx, UploadSettings uploadSettings) throws Exception {
        String command = Utils.getStringFromTemplate(uploadSettings.sftpcommand, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)command);
    }

    public static boolean isValidHttpCommand(BurstingContext ctx, UploadSettings uploadSettings) throws Exception {
        String command = Utils.getStringFromTemplate(uploadSettings.httpcommand, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)command);
    }

    public static boolean isValidCloudUploadCommand(BurstingContext ctx, UploadSettings uploadSettings) throws Exception {
        String command = Utils.getStringFromTemplate(uploadSettings.cloudcommand, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)command);
    }

    public static boolean isValidDocumentBursterWebCommand(BurstingContext ctx, WebUploadSettings webUploadSettings) throws Exception {
        String command = Utils.getStringFromTemplate(webUploadSettings.documentbursterwebcommand, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)command);
    }

    public static boolean isValidMSSharePointCommand(BurstingContext ctx, WebUploadSettings webUploadSettings) throws Exception {
        String command = Utils.getStringFromTemplate(webUploadSettings.mssharepointcommand, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)command);
    }

    public static boolean isValidWordPressCommand(BurstingContext ctx, WebUploadSettings webUploadSettings) throws Exception {
        String command = Utils.getStringFromTemplate(webUploadSettings.wordpresscommand, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)command);
    }

    public static boolean isValidDrupalCommand(BurstingContext ctx, WebUploadSettings webUploadSettings) throws Exception {
        String command = Utils.getStringFromTemplate(webUploadSettings.drupalcommand, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)command);
    }

    public static boolean isValidJoomlaCommand(BurstingContext ctx, WebUploadSettings webUploadSettings) throws Exception {
        String command = Utils.getStringFromTemplate(webUploadSettings.joomlacommand, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)command);
    }

    public static boolean isValidOtherWebCommand(BurstingContext ctx, WebUploadSettings webUploadSettings) throws Exception {
        String command = Utils.getStringFromTemplate(webUploadSettings.otherwebcommand, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)command);
    }

    public static boolean isValidEmailMessage(BurstingContext ctx, EmailSettings emailSettings) throws Exception {
        log.debug("ctx = " + ctx + ", destination = destination");
        boolean isValidToEmailAddress = Utils.isValidEmailAddress(emailSettings.to, ctx);
        log.debug("isValidToEmailAddress = " + isValidToEmailAddress);
        boolean isValidCcEmailAddress = Utils.isValidEmailAddress(emailSettings.cc, ctx);
        log.debug("isValidCcEmailAddress = " + isValidCcEmailAddress);
        boolean isValidBccEmailAddress = Utils.isValidEmailAddress(emailSettings.bcc, ctx);
        log.debug("isValidBccEmailAddress = " + isValidBccEmailAddress);
        return isValidToEmailAddress || isValidCcEmailAddress || isValidBccEmailAddress;
    }

    public static List<EmailAddressCriteria> getEmailAddressRfc2822ValidationOptions(BurstingContext ctx) {
        ArrayList<EmailAddressCriteria> options = new ArrayList<EmailAddressCriteria>();
        if (ctx.settings.getEmailRfc2822Validator().allowdomainliterals) {
            options.add(EmailAddressCriteria.ALLOW_DOMAIN_LITERALS);
        }
        if (ctx.settings.getEmailRfc2822Validator().allowquotedidentifiers) {
            options.add(EmailAddressCriteria.ALLOW_QUOTED_IDENTIFIERS);
        }
        if (ctx.settings.getEmailRfc2822Validator().allowdotinatext) {
            options.add(EmailAddressCriteria.ALLOW_DOT_IN_A_TEXT);
        }
        if (ctx.settings.getEmailRfc2822Validator().allowsquarebracketsinatext) {
            options.add(EmailAddressCriteria.ALLOW_SQUARE_BRACKETS_IN_A_TEXT);
        }
        if (ctx.settings.getEmailRfc2822Validator().allowparensinlocalpart) {
            options.add(EmailAddressCriteria.ALLOW_PARENS_IN_LOCALPART);
        }
        return options;
    }

    public static boolean isValidEmailAddress(String addressesTemplates, BurstingContext ctx) throws Exception {
        boolean isValidEmailAddress = true;
        String addresses = Utils.getStringFromTemplate(addressesTemplates, ctx.variables, ctx.token);
        if (StringUtils.isNotEmpty((CharSequence)addresses)) {
            String[] ads;
            String separator = ";";
            if (addresses.contains(",")) {
                separator = ",";
            }
            if ((ads = addresses.split(separator)) == null || ads.length == 0) {
                isValidEmailAddress = false;
            }
            List<EmailAddressCriteria> emailRfc2822ValidationOptions = Utils.getEmailAddressRfc2822ValidationOptions(ctx);
            String skipValidationForAddresses = ctx.settings.getEmailRfc2822Validator().skipvalidationfor;
            for (String address : ads) {
                if (StringUtils.isNotBlank((CharSequence)skipValidationForAddresses) && skipValidationForAddresses.toLowerCase().contains(address.toLowerCase())) continue;
                boolean isCurrentEmailAddressValid = true;
                isCurrentEmailAddressValid = emailRfc2822ValidationOptions.size() > 0 ? EmailAddressValidator.isValid((String)address, EnumSet.copyOf(emailRfc2822ValidationOptions)) : EmailAddressValidator.isValid((String)address);
                if (isCurrentEmailAddressValid) continue;
                isValidEmailAddress = false;
            }
        } else {
            isValidEmailAddress = false;
        }
        if (!isValidEmailAddress && StringUtils.isNotEmpty((CharSequence)addresses)) {
            throw new IllegalArgumentException("Invalid email address '" + addresses + "' found for the token '" + ctx.token + "'");
        }
        return isValidEmailAddress;
    }

    public static boolean isEmptyFile(String filePath) throws Exception {
        FileInputStream stream = new FileInputStream(new File(filePath));
        int size = ((InputStream)stream).available();
        ((InputStream)stream).close();
        return size == 0;
    }

    public static double getFileSize(long fileSizeInBytes, FileSizeUnit unit) {
        double bytes = fileSizeInBytes;
        if (unit == FileSizeUnit.BYTE) {
            return bytes;
        }
        double kilobytes = bytes / 1024.0;
        if (unit == FileSizeUnit.KILOBYTE) {
            return kilobytes;
        }
        double megabytes = kilobytes / 1024.0;
        if (unit == FileSizeUnit.MEGABYTE) {
            return megabytes;
        }
        double gigabytes = megabytes / 1024.0;
        if (unit == FileSizeUnit.GIGABYTE) {
            return gigabytes;
        }
        return 0.0;
    }

    public static void copyFileToQuarantine(String quarantineFolderPath, String filePath) throws Exception {
        log.debug("copyFileToQuarantine(String quarantineFolderPath, String filePath): " + quarantineFolderPath + ", " + filePath);
        File quarantineDir = new File(quarantineFolderPath);
        if (!quarantineDir.exists()) {
            FileUtils.forceMkdir((File)quarantineDir);
        }
        FileUtils.copyFile((File)new File(filePath), (File)new File(quarantineFolderPath + "/" + FilenameUtils.getName((String)filePath)));
    }

    public static String encodeURIComponent(String s) throws Exception {
        return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
    }

    public static String getHumanReadableTime(Long nanos) {
        long tempSec = nanos / 1000000000L;
        long sec = tempSec % 60L;
        long min = tempSec / 60L % 60L;
        long hour = tempSec / 3600L % 24L;
        long day = tempSec / 86400L % 24L;
        if (day > 0L) {
            return String.format("%d days %d hours %d minutes %d seconds", day, hour, min, sec);
        }
        if (hour > 0L) {
            return String.format("%d hours %d minutes %d seconds", hour, min, sec);
        }
        if (min > 0L) {
            return String.format("%d minutes %d seconds", min, sec);
        }
        return String.format("%d seconds", sec);
    }

    public static boolean isValidSmsMessage(BurstingContext ctx, SmsSettings smsSettings) throws Exception {
        String text = Utils.getStringFromTemplate(smsSettings.text, ctx.variables, ctx.token);
        return StringUtils.isNotEmpty((CharSequence)text);
    }

    public static boolean isValidTwilioMessage(BurstingContext ctx, SmsSettings smsSettings) throws Exception {
        String accountSid = Utils.getStringFromTemplate(smsSettings.twilio.accountsid, ctx.variables, ctx.token);
        String authToken = Utils.getStringFromTemplate(smsSettings.twilio.authtoken, ctx.variables, ctx.token);
        return Utils.isValidSmsMessage(ctx, smsSettings) && StringUtils.isNotEmpty((CharSequence)accountSid) && StringUtils.isNotEmpty((CharSequence)authToken);
    }

    public static Map<String, Object> loadHeadersPropertiesFromText(String text) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Pattern pattern = Pattern.compile("\\s*(\"[^\"]*\"|[^,]*)\\s*");
        Scanner scanner = new Scanner(text);
        while (scanner.hasNextLine()) {
            String key = "";
            String value = "";
            String line = scanner.nextLine();
            Matcher matcher = pattern.matcher(line);
            int count = 0;
            while (matcher.find()) {
                if (++count == 1) {
                    key = matcher.group(1);
                    continue;
                }
                if (count != 2) continue;
                value = matcher.group(1);
            }
            if (!StringUtils.isNotBlank((CharSequence)key) || !StringUtils.isNotBlank((CharSequence)value)) continue;
            properties.put(key.trim(), Utils._parsePropertyValue(value.trim()));
        }
        scanner.close();
        return properties;
    }

    private static Object _parsePropertyValue(String propertyValue) {
        HashMap<String, Boolean> booleanConversionMap = new HashMap<String, Boolean>();
        booleanConversionMap.put("0", false);
        booleanConversionMap.put("1", true);
        booleanConversionMap.put("false", false);
        booleanConversionMap.put("true", true);
        booleanConversionMap.put("no", false);
        booleanConversionMap.put("yes", true);
        if (booleanConversionMap.containsKey(propertyValue)) {
            return booleanConversionMap.get(propertyValue.toLowerCase());
        }
        try {
            return Long.valueOf(propertyValue);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(propertyValue);
            }
            catch (NumberFormatException numberFormatException2) {
                return propertyValue;
            }
        }
    }

    public static String removeControlCharactersFromString(String inputString) {
        return inputString.replaceAll("(?U)\\p{Cntrl}|\\p{Gc=Cf}", "");
    }

    public static String dumpRowAsXml(Map<String, Object> row) throws Exception {
        XmlMapper xmlMapper = new XmlMapper();
        return xmlMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new RowWrapper(row));
    }

    public static String getParentFolderPathHavingName(String filePath, String folderName) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return "./config";
        }
        File file = new File(filePath);
        for (File parentFolder = file.getParentFile(); parentFolder != null; parentFolder = parentFolder.getParentFile()) {
            if (!parentFolder.getName().equalsIgnoreCase(folderName)) continue;
            return parentFolder.getAbsolutePath();
        }
        return "";
    }

    public static String ibContent(String htmlContent, String bType, String ea) {
        if (StringUtils.isBlank((CharSequence)htmlContent)) {
            return htmlContent;
        }
        try {
            int bodyIndex;
            Path brandingPath = Paths.get("./scripts/burst/internal/bb.html", new String[0]);
            if (!Files.exists(brandingPath, new LinkOption[0]) && !Files.exists(brandingPath = Paths.get("src/main/external-resources/template/scripts/burst/internal/bb.html", new String[0]), new LinkOption[0])) {
                return htmlContent;
            }
            String brandingContent = Files.readString(brandingPath);
            brandingContent = brandingContent.replace("Built by", bType);
            String urlSuffix = "Sent by".equals(bType) ? "eml" : ("Built by".equals(bType) ? "gr" : "gr");
            brandingContent = brandingContent.replaceAll("href=\"https://www.reportburster.com/g/rb/\\w+\"", "href=\"https://www.reportburster.com/g/rb/" + urlSuffix + "\"");
            if (StringUtils.isNotBlank((CharSequence)ea)) {
                try {
                    String encodedEmail = Base64.getEncoder().encodeToString(ea.getBytes(StandardCharsets.UTF_8));
                    String urlEncodedEmail = URLEncoder.encode(encodedEmail, StandardCharsets.UTF_8);
                    brandingContent = brandingContent.replaceAll("href=\"(https://www.reportburster.com/g/rb/" + urlSuffix + ")\"", "href=\"$1?ee=" + urlEncodedEmail + "\"");
                }
                catch (Exception e) {
                    System.err.println("Failed to encode email address: " + e.getMessage());
                }
            }
            if ((bodyIndex = htmlContent.toLowerCase().lastIndexOf("</body>")) != -1) {
                return htmlContent.substring(0, bodyIndex) + brandingContent + htmlContent.substring(bodyIndex);
            }
            return htmlContent + brandingContent;
        }
        catch (Exception e) {
            return htmlContent;
        }
    }

    public static String ibContent(String htmlContent, String bType) {
        return Utils.ibContent(htmlContent, bType, null);
    }

    public static boolean isPortOpen(String host, int port, int timeoutMs) {
        boolean bl;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(host, port), timeoutMs);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public static boolean isRunningInDocker() {
        String dockerEnv = System.getenv("RUNNING_IN_DOCKER");
        return "true".equalsIgnoreCase(dockerEnv);
    }

    public static String getEffectiveHost(String configuredHost) {
        if (Utils.isRunningInDocker() && Utils.isLocalhostHost(configuredHost)) {
            log.debug("Docker environment detected - converting {} to host.docker.internal", (Object)configuredHost);
            return "host.docker.internal";
        }
        return configuredHost;
    }

    private static boolean isLocalhostHost(String host) {
        if (host == null) {
            return false;
        }
        String h = host.trim().toLowerCase();
        return "localhost".equals(h) || "127.0.0.1".equals(h);
    }

    public static String sanitizeFileName(String input) {
        if (input == null) {
            return "report";
        }
        String s = Normalizer.normalize(input, Normalizer.Form.NFKD).replaceAll("\\p{M}", "");
        s = FilenameUtils.getName((String)s);
        s = s.replaceAll("[\\\\/:*?\"<>|\\p{Cntrl}]+", "_");
        s = s.replaceAll("[^A-Za-z0-9._\\- ]+", "_");
        s = s.replaceAll("[ _]{2,}", "_");
        s = s.trim();
        if ((s = s.replaceAll("^\\.+|\\.+$", "")).isEmpty()) {
            s = "report";
        }
        String upper = s.toUpperCase();
        HashSet<String> reserved = new HashSet<String>();
        reserved.add("CON");
        reserved.add("PRN");
        reserved.add("AUX");
        reserved.add("NUL");
        for (int i = 1; i <= 9; ++i) {
            reserved.add("COM" + i);
            reserved.add("LPT" + i);
        }
        if (reserved.contains(upper)) {
            s = "_" + s;
        }
        int max = 200;
        if (s.length() > max) {
            s = s.substring(0, max);
        }
        return s;
    }

    public static enum FileSizeUnit {
        BYTE,
        KILOBYTE,
        MEGABYTE,
        GIGABYTE,
        TERABYTE,
        PETABYTE,
        EXABYTE,
        ZETTABYTE,
        YOTTABYTE;

    }

    public static class RowWrapper {
        public Map<String, Object> record;

        public RowWrapper(Map<String, Object> row) {
            this.record = row;
        }

        public RowWrapper() {
        }
    }
}

