/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.utils;

import com.sourcekraft.documentburster.common.settings.model.FreeMarkerSettings;
import com.sourcekraft.documentburster.common.settings.model.Locale;
import fr.opensagres.xdocreport.document.discovery.ITemplateEngineInitializerDiscovery;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.freemarker.FreemarkerTemplateEngine;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentBursterFreemarkerInitializer
implements ITemplateEngineInitializerDiscovery {
    private static final Logger log = LoggerFactory.getLogger(DocumentBursterFreemarkerInitializer.class);
    public static final Configuration FREE_MARKER_CFG = new Configuration(Configuration.VERSION_2_3_29);
    private static final java.util.Locale DEFAULT_LOCALE = java.util.Locale.US;
    private static final String DEFAULT_NUMBER_FORMAT = "0.######";
    private static final String DEFAULT_DATE_FORMAT = "MM/dd/yyyy";
    private static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    private static final String DEFAULT_DATETIME_FORMAT = "MM/dd/yyyy HH:mm:ss";
    private static final String DEFAULT_TIMEZONE = "UTC";

    public static void configureFreeMarker(Locale localeSettings, FreeMarkerSettings fmSettings) {
        java.util.Locale javaLocale;
        if (localeSettings == null) {
            javaLocale = DEFAULT_LOCALE;
        } else {
            String language = localeSettings.language;
            String country = localeSettings.country;
            if (StringUtils.isBlank((CharSequence)language)) {
                log.warn("No language specified in locale, defaulting to {}", (Object)DEFAULT_LOCALE);
                javaLocale = DEFAULT_LOCALE;
            } else {
                javaLocale = StringUtils.isBlank((CharSequence)country) ? new Locale.Builder().setLanguage(language).build() : new Locale.Builder().setLanguage(language).setRegion(country).build();
            }
        }
        FREE_MARKER_CFG.setLocale(javaLocale);
        FREE_MARKER_CFG.setDefaultEncoding("UTF-8");
        FREE_MARKER_CFG.setOutputEncoding("UTF-8");
        if (fmSettings != null) {
            if (StringUtils.isNotBlank((CharSequence)fmSettings.dateformat)) {
                FREE_MARKER_CFG.setDateFormat(fmSettings.dateformat);
            } else {
                FREE_MARKER_CFG.setDateFormat(DEFAULT_DATE_FORMAT);
            }
            if (StringUtils.isNotBlank((CharSequence)fmSettings.timeformat)) {
                FREE_MARKER_CFG.setTimeFormat(fmSettings.timeformat);
            } else {
                FREE_MARKER_CFG.setTimeFormat(DEFAULT_TIME_FORMAT);
            }
            if (StringUtils.isNotBlank((CharSequence)fmSettings.datetimeformat)) {
                FREE_MARKER_CFG.setDateTimeFormat(fmSettings.datetimeformat);
            } else {
                FREE_MARKER_CFG.setDateTimeFormat(DEFAULT_DATETIME_FORMAT);
            }
            if (StringUtils.isNotBlank((CharSequence)fmSettings.numberformat)) {
                FREE_MARKER_CFG.setNumberFormat(fmSettings.numberformat);
            } else {
                FREE_MARKER_CFG.setNumberFormat(DEFAULT_NUMBER_FORMAT);
            }
            if (StringUtils.isNotBlank((CharSequence)fmSettings.timezone)) {
                FREE_MARKER_CFG.setTimeZone(TimeZone.getTimeZone(fmSettings.timezone));
            } else {
                FREE_MARKER_CFG.setTimeZone(TimeZone.getTimeZone(DEFAULT_TIMEZONE));
            }
        } else {
            FREE_MARKER_CFG.setDateFormat(DEFAULT_DATE_FORMAT);
            FREE_MARKER_CFG.setTimeFormat(DEFAULT_TIME_FORMAT);
            FREE_MARKER_CFG.setDateTimeFormat(DEFAULT_DATETIME_FORMAT);
            FREE_MARKER_CFG.setNumberFormat(DEFAULT_NUMBER_FORMAT);
            FREE_MARKER_CFG.setTimeZone(TimeZone.getTimeZone(DEFAULT_TIMEZONE));
        }
        log.debug("Configured FREE_MARKER_CFG: locale={}, timezone={}, date={}, time={}, datetime={}, number={}", new Object[]{FREE_MARKER_CFG.getLocale(), FREE_MARKER_CFG.getTimeZone(), FREE_MARKER_CFG.getDateFormat(), FREE_MARKER_CFG.getTimeFormat(), FREE_MARKER_CFG.getDateTimeFormat(), FREE_MARKER_CFG.getNumberFormat()});
    }

    public String getId() {
        return DocumentBursterFreemarkerInitializer.class.getName();
    }

    public String getDescription() {
        return "DocumentBurster FreeMarker SPI initializer (applies conservative defaults)";
    }

    public String getDocumentKind() {
        return null;
    }

    public void initialize(ITemplateEngine templateEngine) {
        if (!TemplateEngineKind.Freemarker.name().equals(templateEngine.getKind())) {
            return;
        }
        try {
            FreemarkerTemplateEngine fmEngine = (FreemarkerTemplateEngine)templateEngine;
            Configuration cfg = fmEngine.getFreemarkerConfiguration();
            cfg.setDefaultEncoding("UTF-8");
            cfg.setOutputEncoding("UTF-8");
            cfg.setLocale(DEFAULT_LOCALE);
            cfg.setNumberFormat(DEFAULT_NUMBER_FORMAT);
            cfg.setDateFormat(DEFAULT_DATE_FORMAT);
            cfg.setTimeFormat(DEFAULT_TIME_FORMAT);
            cfg.setDateTimeFormat(DEFAULT_DATETIME_FORMAT);
            cfg.setTimeZone(TimeZone.getTimeZone(DEFAULT_TIMEZONE));
            log.debug("XDocReport FreeMarker initialized with conservative defaults (SPI).");
        }
        catch (Throwable t) {
            log.warn("Could not apply default FreeMarker settings in SPI initialize(): {}", (Object)t.toString());
        }
    }

    public static void applySettingsTo(ITemplateEngine templateEngine) {
        if (templateEngine == null) {
            return;
        }
        try {
            TemplateExceptionHandler teh;
            FreemarkerTemplateEngine fmEngine = (FreemarkerTemplateEngine)templateEngine;
            Configuration cfg = fmEngine.getFreemarkerConfiguration();
            if (FREE_MARKER_CFG.getLocale() != null) {
                cfg.setLocale(FREE_MARKER_CFG.getLocale());
            }
            if (FREE_MARKER_CFG.getNumberFormat() != null) {
                cfg.setNumberFormat(FREE_MARKER_CFG.getNumberFormat());
            }
            if (FREE_MARKER_CFG.getDateFormat() != null) {
                cfg.setDateFormat(FREE_MARKER_CFG.getDateFormat());
            }
            if (FREE_MARKER_CFG.getTimeFormat() != null) {
                cfg.setTimeFormat(FREE_MARKER_CFG.getTimeFormat());
            }
            if (FREE_MARKER_CFG.getDateTimeFormat() != null) {
                cfg.setDateTimeFormat(FREE_MARKER_CFG.getDateTimeFormat());
            }
            if ((teh = FREE_MARKER_CFG.getTemplateExceptionHandler()) != null) {
                cfg.setTemplateExceptionHandler(teh);
            }
            log.debug("Applied FREE_MARKER_CFG into XDocReport FreemarkerTemplateEngine (controlled).");
        }
        catch (ClassCastException e) {
            log.warn("applySettingsTo: templateEngine is not FreemarkerTemplateEngine: {}", (Object)e.toString());
        }
        catch (Throwable t) {
            log.warn("applySettingsTo failed: {}", (Object)t.toString());
        }
    }
}

