/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.tabulator;

import com.sourcekraft.documentburster.common.tabulator.TabulatorOptions;
import com.sourcekraft.documentburster.common.tabulator.TabulatorOptionsScript;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilerConfiguration;

public class TabulatorOptionsParser {
    public static TabulatorOptions parseGroovyTabulatorDslCode(String groovyDslCode) throws Exception {
        if (groovyDslCode == null || groovyDslCode.trim().isEmpty()) {
            return new TabulatorOptions();
        }
        Binding binding = new Binding();
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(TabulatorOptionsScript.class.getName());
        GroovyShell shell = new GroovyShell(binding, config);
        TabulatorOptionsScript script = (TabulatorOptionsScript)shell.parse(groovyDslCode);
        script.setBinding(binding);
        script.run();
        Map<String, Object> map = script.getOptions();
        TabulatorOptions opts = new TabulatorOptions();
        if (map.containsKey("layoutOptions")) {
            opts.setLayoutOptions((Map)map.get("layoutOptions"));
        }
        if (map.containsKey("columns")) {
            opts.setColumns((List)map.get("columns"));
        }
        if (map.containsKey("data")) {
            opts.setData((List)map.get("data"));
        }
        return opts;
    }
}

