/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.settings;

import com.sourcekraft.documentburster.common.settings.model.license.LicenseDetails;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class License {
    private Logger log = LoggerFactory.getLogger(License.class);
    private String licenseFilePath = "config/_internal/license.xml";
    private LicenseDetails licenseDetails = new LicenseDetails();
    private boolean mockPaid = false;
    public static String STATUS_DEMO = "DEMO";
    public static String STATUS_VALID = "VALID";
    public static String STATUS_EXPIRED = "EXPIRED";

    public String getLicenseFilePath() {
        return this.licenseFilePath;
    }

    public void setLicenseFilePath(String licenseFilePath) {
        this.licenseFilePath = licenseFilePath;
    }

    public void loadLicense() throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{LicenseDetails.class});
        Unmarshaller u = jc.createUnmarshaller();
        this.licenseDetails = (LicenseDetails)u.unmarshal(new File(this.licenseFilePath));
        this.log.debug("loadLicense - license = [" + this.licenseDetails + "]");
    }

    public void saveLicense() throws Exception {
        this.log.debug("saveLicense - licenseFilePath='" + this.licenseFilePath + "', license = [" + this.licenseDetails + "]");
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{LicenseDetails.class});
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)this.licenseDetails, new File(this.licenseFilePath));
    }

    public String getKey() {
        return this.licenseDetails.key;
    }

    public String getProduct() {
        return this.licenseDetails.product;
    }

    public String getStatus() {
        return this.licenseDetails.status;
    }

    public String getCustomerName() {
        return this.licenseDetails.customername;
    }

    public String getCustomerEmail() {
        return this.licenseDetails.customeremail;
    }

    public String getExpires() {
        return this.licenseDetails.expires;
    }

    public String getWhatsNew() {
        return this.licenseDetails.changelog;
    }

    public void setKey(String key) {
        this.licenseDetails.key = key;
    }

    public void setProduct(String product) {
        this.licenseDetails.product = product;
    }

    public void setStatus(String status) {
        this.licenseDetails.status = status;
    }

    public void setCustomerName(String customerName) {
        this.licenseDetails.customername = customerName;
    }

    public void setCustomerEmail(String customerEmail) {
        this.licenseDetails.customeremail = customerEmail;
    }

    public void setExpires(String expires) {
        this.licenseDetails.expires = expires;
    }

    public void setChangeLog(String changeLog) {
        this.licenseDetails.changelog = changeLog;
    }

    public void setLatestVersion(String latestVersion) {
        this.licenseDetails.latestversion = latestVersion;
    }

    public boolean isValid() {
        return this.getStatus().equalsIgnoreCase("valid");
    }

    public boolean isExpired() {
        return this.getStatus().equalsIgnoreCase("expired");
    }

    public boolean itWasPaid() {
        return this.isValid() || this.isExpired() || this.mockPaid;
    }

    public boolean isInvalid() {
        return this.getStatus().equalsIgnoreCase("invalid");
    }

    public boolean isDemo() {
        return StringUtils.isEmpty((CharSequence)this.getStatus());
    }

    public void setMockPaid(boolean mockPaid) {
        this.mockPaid = mockPaid;
    }
}

