/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.pivottable;

import groovy.lang.Closure;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class PivotTableOptionsScript
extends Script {
    private final List<String> rows = new ArrayList<String>();
    private final List<String> cols = new ArrayList<String>();
    private final List<String> vals = new ArrayList<String>();
    private String aggregatorName = null;
    private String rendererName = null;
    private String rowOrder = null;
    private String colOrder = null;
    private final Map<String, Map<String, Boolean>> valueFilter = new LinkedHashMap<String, Map<String, Boolean>>();
    private final Map<String, Object> options = new LinkedHashMap<String, Object>();
    private final List<Map<String, Object>> dataRows = new ArrayList<Map<String, Object>>();
    private final List<String> hiddenAttributes = new ArrayList<String>();
    private final List<String> hiddenFromAggregators = new ArrayList<String>();
    private final List<String> hiddenFromDragDrop = new ArrayList<String>();
    private Integer unusedOrientationCutoff = null;
    private Integer menuLimit = null;
    private final Map<String, Object> sorters = new LinkedHashMap<String, Object>();
    private final Map<String, String> derivedAttributes = new LinkedHashMap<String, String>();

    public void pivotTable(Closure<?> body) {
        body.setDelegate((Object)this);
        body.setResolveStrategy(1);
        body.call();
    }

    public void rows(String ... fields) {
        if (fields != null) {
            this.rows.addAll(Arrays.asList(fields));
        }
    }

    public void rows(List<String> fields) {
        if (fields != null) {
            this.rows.addAll(fields);
        }
    }

    public void cols(String ... fields) {
        if (fields != null) {
            this.cols.addAll(Arrays.asList(fields));
        }
    }

    public void cols(List<String> fields) {
        if (fields != null) {
            this.cols.addAll(fields);
        }
    }

    public void vals(String ... fields) {
        if (fields != null) {
            this.vals.addAll(Arrays.asList(fields));
        }
    }

    public void vals(List<String> fields) {
        if (fields != null) {
            this.vals.addAll(fields);
        }
    }

    public void aggregatorName(String name) {
        this.aggregatorName = name;
    }

    public void rendererName(String name) {
        this.rendererName = name;
    }

    public void rowOrder(String order) {
        this.rowOrder = order;
    }

    public void colOrder(String order) {
        this.colOrder = order;
    }

    public void valueFilter(Closure<?> body) {
        ValueFilterDelegate d = new ValueFilterDelegate(this.valueFilter);
        body.setDelegate((Object)d);
        body.setResolveStrategy(1);
        body.call();
    }

    public void options(Map<String, Object> args) {
        if (args != null) {
            this.options.putAll(args);
        }
    }

    public void options(Closure<?> body) {
        NestedMapDelegate d = new NestedMapDelegate(this.options);
        body.setDelegate((Object)d);
        body.setResolveStrategy(1);
        body.call();
    }

    public void data(List<Map<String, Object>> rows) {
        if (rows != null) {
            for (Map<String, Object> r : rows) {
                this.dataRows.add(new LinkedHashMap<String, Object>(r));
            }
        }
    }

    public void hiddenAttributes(String ... attrs) {
        if (attrs != null) {
            this.hiddenAttributes.addAll(Arrays.asList(attrs));
        }
    }

    public void hiddenAttributes(List<String> attrs) {
        if (attrs != null) {
            this.hiddenAttributes.addAll(attrs);
        }
    }

    public void hiddenFromAggregators(String ... attrs) {
        if (attrs != null) {
            this.hiddenFromAggregators.addAll(Arrays.asList(attrs));
        }
    }

    public void hiddenFromAggregators(List<String> attrs) {
        if (attrs != null) {
            this.hiddenFromAggregators.addAll(attrs);
        }
    }

    public void hiddenFromDragDrop(String ... attrs) {
        if (attrs != null) {
            this.hiddenFromDragDrop.addAll(Arrays.asList(attrs));
        }
    }

    public void hiddenFromDragDrop(List<String> attrs) {
        if (attrs != null) {
            this.hiddenFromDragDrop.addAll(attrs);
        }
    }

    public void unusedOrientationCutoff(int value) {
        this.unusedOrientationCutoff = value;
    }

    public void menuLimit(int value) {
        this.menuLimit = value;
    }

    public void sorters(Map<String, Object> map) {
        if (map != null) {
            this.sorters.putAll(map);
        }
    }

    public void derivedAttributes(Map<String, String> map) {
        if (map != null) {
            this.derivedAttributes.putAll(map);
        }
    }

    public Map<String, Object> getOptions() {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        if (!this.rows.isEmpty()) {
            out.put("rows", new ArrayList<String>(this.rows));
        }
        if (!this.cols.isEmpty()) {
            out.put("cols", new ArrayList<String>(this.cols));
        }
        if (!this.vals.isEmpty()) {
            out.put("vals", new ArrayList<String>(this.vals));
        }
        if (this.aggregatorName != null) {
            out.put("aggregatorName", this.aggregatorName);
        }
        if (this.rendererName != null) {
            out.put("rendererName", this.rendererName);
        }
        if (this.rowOrder != null) {
            out.put("rowOrder", this.rowOrder);
        }
        if (this.colOrder != null) {
            out.put("colOrder", this.colOrder);
        }
        if (!this.valueFilter.isEmpty()) {
            out.put("valueFilter", new LinkedHashMap<String, Map<String, Boolean>>(this.valueFilter));
        }
        if (!this.options.isEmpty()) {
            out.put("options", new LinkedHashMap<String, Object>(this.options));
        }
        if (!this.dataRows.isEmpty()) {
            out.put("data", new ArrayList<Map<String, Object>>(this.dataRows));
        }
        if (!this.hiddenAttributes.isEmpty()) {
            out.put("hiddenAttributes", new ArrayList<String>(this.hiddenAttributes));
        }
        if (!this.hiddenFromAggregators.isEmpty()) {
            out.put("hiddenFromAggregators", new ArrayList<String>(this.hiddenFromAggregators));
        }
        if (!this.hiddenFromDragDrop.isEmpty()) {
            out.put("hiddenFromDragDrop", new ArrayList<String>(this.hiddenFromDragDrop));
        }
        if (this.unusedOrientationCutoff != null) {
            out.put("unusedOrientationCutoff", this.unusedOrientationCutoff);
        }
        if (this.menuLimit != null) {
            out.put("menuLimit", this.menuLimit);
        }
        if (!this.sorters.isEmpty()) {
            out.put("sorters", new LinkedHashMap<String, Object>(this.sorters));
        }
        if (!this.derivedAttributes.isEmpty()) {
            out.put("derivedAttributes", new LinkedHashMap<String, String>(this.derivedAttributes));
        }
        return out;
    }

    public Object run() {
        return null;
    }

    private static class ValueFilterDelegate {
        private final Map<String, Map<String, Boolean>> filters;

        ValueFilterDelegate(Map<String, Map<String, Boolean>> filters) {
            this.filters = filters;
        }

        public void filter(String attribute, Map<String, Object> args) {
            LinkedHashMap<String, Boolean> attrFilter = new LinkedHashMap<String, Boolean>();
            Object excludeObj = args.get("exclude");
            if (excludeObj instanceof List) {
                for (Object val : (List)excludeObj) {
                    attrFilter.put(String.valueOf(val), true);
                }
            }
            if (!attrFilter.isEmpty()) {
                this.filters.put(attribute, attrFilter);
            }
        }

        public Object methodMissing(String name, Object args) {
            Object[] arr;
            if (args instanceof Object[] && (arr = (Object[])args).length > 0 && arr[0] instanceof Map) {
                this.filter(name, (Map)arr[0]);
            }
            return null;
        }
    }

    private static class NestedMapDelegate {
        private final Map<String, Object> map;

        NestedMapDelegate(Map<String, Object> map) {
            this.map = map;
        }

        public Object methodMissing(String name, Object args) {
            if (args instanceof Object[]) {
                Object[] arr = (Object[])args;
                if (arr.length == 1 && arr[0] instanceof Closure) {
                    LinkedHashMap<String, Object> subMap = new LinkedHashMap<String, Object>();
                    Closure c = (Closure)arr[0];
                    NestedMapDelegate sub = new NestedMapDelegate(subMap);
                    c.setDelegate((Object)sub);
                    c.setResolveStrategy(1);
                    c.call();
                    this.map.put(name, subMap);
                } else if (arr.length > 0) {
                    this.map.put(name, arr[0]);
                }
            } else {
                this.map.put(name, args);
            }
            return null;
        }
    }
}

