/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db.northwind.entities;

import com.sourcekraft.documentburster.common.db.northwind.entities.Product;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="\"Suppliers\"")
public class Supplier {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="\"SupplierID\"")
    private Integer supplierId;
    @Column(name="\"CompanyName\"", length=40, nullable=false)
    private String companyName;
    @Column(name="\"ContactName\"", length=30)
    private String contactName;
    @Column(name="\"ContactTitle\"", length=30)
    private String contactTitle;
    @Column(name="\"Address\"", length=60)
    private String address;
    @Column(name="\"City\"", length=15)
    private String city;
    @Column(name="\"Region\"", length=15)
    private String region;
    @Column(name="\"PostalCode\"", length=10)
    private String postalCode;
    @Column(name="\"Country\"", length=15)
    private String country;
    @Column(name="\"Phone\"", length=24)
    private String phone;
    @Column(name="\"Fax\"", length=24)
    private String fax;
    @Column(name="\"Email\"", length=225)
    private String email;
    @Lob
    @Column(name="\"HomePage\"")
    private String homePage;
    @OneToMany(mappedBy="supplier", fetch=FetchType.LAZY)
    private List<Product> products = new ArrayList<Product>();

    public Supplier() {
    }

    public Supplier(String companyName, String contactName) {
        this.companyName = companyName;
        this.contactName = contactName;
    }

    public Supplier(String companyName, String contactName, String contactTitle, String address, String city, String country, String phone) {
        this.companyName = companyName;
        this.contactName = contactName;
        this.contactTitle = contactTitle;
        this.address = address;
        this.city = city;
        this.country = country;
        this.phone = phone;
    }

    public Integer getSupplierId() {
        return this.supplierId;
    }

    public void setSupplierId(Integer supplierId) {
        this.supplierId = supplierId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getContactTitle() {
        return this.contactTitle;
    }

    public void setContactTitle(String contactTitle) {
        this.contactTitle = contactTitle;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getHomePage() {
        return this.homePage;
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public void setProducts(List<Product> products) {
        this.products = products;
    }

    public void addProduct(Product product) {
        this.products.add(product);
        product.setSupplier(this);
    }

    public void removeProduct(Product product) {
        this.products.remove(product);
        product.setSupplier(null);
    }

    public String getFullContactInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.contactName != null) {
            sb.append(this.contactName);
            if (this.contactTitle != null) {
                sb.append(", ").append(this.contactTitle);
            }
        }
        return sb.toString();
    }

    public String getFullAddress() {
        StringBuilder sb = new StringBuilder();
        if (this.address != null) {
            sb.append(this.address);
        }
        if (this.city != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.city);
        }
        if (this.region != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.region);
        }
        if (this.postalCode != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(this.postalCode);
        }
        if (this.country != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.country);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Supplier supplier = (Supplier)o;
        return Objects.equals(this.supplierId, supplier.supplierId);
    }

    public int hashCode() {
        return Objects.hash(this.supplierId);
    }

    public String toString() {
        return "Supplier{supplierId=" + this.supplierId + ", companyName='" + this.companyName + '\'' + ", contactName='" + this.contactName + '\'' + ", productCount=" + (this.products != null ? this.products.size() : 0) + '}';
    }
}

