/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db.northwind.entities;

import com.sourcekraft.documentburster.common.db.northwind.entities.Order;
import com.sourcekraft.documentburster.common.db.northwind.entities.OrderDetailId;
import com.sourcekraft.documentburster.common.db.northwind.entities.Product;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.Objects;

@Entity
@Table(name="\"Order Details\"")
@IdClass(value=OrderDetailId.class)
public class OrderDetail {
    @Id
    @Column(name="\"OrderID\"", nullable=false)
    private Integer orderId;
    @Id
    @Column(name="\"ProductID\"", nullable=false)
    private Integer productId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"OrderID\"", insertable=false, updatable=false)
    private Order order;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"ProductID\"", insertable=false, updatable=false)
    private Product product;
    @Column(name="\"UnitPrice\"", nullable=false, precision=19, scale=4)
    private BigDecimal unitPrice;
    @Column(name="\"Quantity\"", nullable=false)
    private Short quantity;
    @Column(name="\"Discount\"", nullable=false, precision=8, scale=4)
    private BigDecimal discount;

    public OrderDetail() {
        this.quantity = 1;
        this.discount = BigDecimal.ZERO;
    }

    public OrderDetail(Order order, Product product, BigDecimal unitPrice, Short quantity) {
        this.order = order;
        this.product = product;
        this.orderId = order.getOrderId();
        this.productId = product.getProductId();
        this.unitPrice = unitPrice;
        this.quantity = quantity;
        this.discount = BigDecimal.ZERO;
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
    }

    public Integer getProductId() {
        return this.productId;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
        if (order != null) {
            this.orderId = order.getOrderId();
        }
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
        if (product != null) {
            this.productId = product.getProductId();
        }
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public Short getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Short quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public BigDecimal getLineTotal() {
        BigDecimal total = this.unitPrice.multiply(new BigDecimal(this.quantity.shortValue()));
        BigDecimal discountAmount = total.multiply(this.discount);
        return total.subtract(discountAmount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderDetail that = (OrderDetail)o;
        return Objects.equals(this.orderId, that.orderId) && Objects.equals(this.productId, that.productId);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.productId);
    }

    public String toString() {
        return "OrderDetail{orderId=" + this.orderId + ", productId=" + this.productId + ", product=" + (this.product != null ? this.product.getProductName() : null) + ", quantity=" + this.quantity + ", unitPrice=" + this.unitPrice + '}';
    }
}

