/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db.northwind.entities;

import com.sourcekraft.documentburster.common.db.northwind.entities.Customer;
import com.sourcekraft.documentburster.common.db.northwind.entities.Employee;
import com.sourcekraft.documentburster.common.db.northwind.entities.OrderDetail;
import com.sourcekraft.documentburster.common.db.northwind.entities.Product;
import com.sourcekraft.documentburster.common.db.northwind.entities.Shipper;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="\"Orders\"")
public class Order {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="\"OrderID\"")
    private Integer orderId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"CustomerID\"")
    private Customer customer;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"EmployeeID\"")
    private Employee employee;
    @Column(name="\"OrderDate\"")
    private LocalDateTime orderDate;
    @Column(name="\"RequiredDate\"")
    private LocalDateTime requiredDate;
    @Column(name="\"ShippedDate\"")
    private LocalDateTime shippedDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"ShipVia\"")
    private Shipper shipper;
    @Column(name="\"Freight\"", precision=19, scale=4)
    private BigDecimal freight;
    @Column(name="\"ShipName\"", length=40)
    private String shipName;
    @Column(name="\"ShipAddress\"", length=60)
    private String shipAddress;
    @Column(name="\"ShipCity\"", length=15)
    private String shipCity;
    @Column(name="\"ShipRegion\"", length=15)
    private String shipRegion;
    @Column(name="\"ShipPostalCode\"", length=10)
    private String shipPostalCode;
    @Column(name="\"ShipCountry\"", length=15)
    private String shipCountry;
    @OneToMany(mappedBy="order", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<OrderDetail> orderDetails = new ArrayList<OrderDetail>();

    public Order() {
        this.orderDate = LocalDateTime.now();
        this.freight = BigDecimal.ZERO;
    }

    public Order(Customer customer, Employee employee) {
        this();
        this.customer = customer;
        this.employee = employee;
        if (customer != null) {
            this.shipName = customer.getCompanyName();
            this.shipAddress = customer.getAddress();
            this.shipCity = customer.getCity();
            this.shipRegion = customer.getRegion();
            this.shipPostalCode = customer.getPostalCode();
            this.shipCountry = customer.getCountry();
        }
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public LocalDateTime getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(LocalDateTime orderDate) {
        this.orderDate = orderDate;
    }

    public LocalDateTime getRequiredDate() {
        return this.requiredDate;
    }

    public void setRequiredDate(LocalDateTime requiredDate) {
        this.requiredDate = requiredDate;
    }

    public LocalDateTime getShippedDate() {
        return this.shippedDate;
    }

    public void setShippedDate(LocalDateTime shippedDate) {
        this.shippedDate = shippedDate;
    }

    public Shipper getShipper() {
        return this.shipper;
    }

    public void setShipper(Shipper shipper) {
        this.shipper = shipper;
    }

    public BigDecimal getFreight() {
        return this.freight;
    }

    public void setFreight(BigDecimal freight) {
        this.freight = freight;
    }

    public String getShipName() {
        return this.shipName;
    }

    public void setShipName(String shipName) {
        this.shipName = shipName;
    }

    public String getShipAddress() {
        return this.shipAddress;
    }

    public void setShipAddress(String shipAddress) {
        this.shipAddress = shipAddress;
    }

    public String getShipCity() {
        return this.shipCity;
    }

    public void setShipCity(String shipCity) {
        this.shipCity = shipCity;
    }

    public String getShipRegion() {
        return this.shipRegion;
    }

    public void setShipRegion(String shipRegion) {
        this.shipRegion = shipRegion;
    }

    public String getShipPostalCode() {
        return this.shipPostalCode;
    }

    public void setShipPostalCode(String shipPostalCode) {
        this.shipPostalCode = shipPostalCode;
    }

    public String getShipCountry() {
        return this.shipCountry;
    }

    public void setShipCountry(String shipCountry) {
        this.shipCountry = shipCountry;
    }

    public List<OrderDetail> getOrderDetails() {
        return this.orderDetails;
    }

    public void setOrderDetails(List<OrderDetail> orderDetails) {
        this.orderDetails = orderDetails;
    }

    public void addOrderDetail(OrderDetail orderDetail) {
        this.orderDetails.add(orderDetail);
        orderDetail.setOrder(this);
    }

    public void removeOrderDetail(OrderDetail orderDetail) {
        this.orderDetails.remove(orderDetail);
        orderDetail.setOrder(null);
    }

    public OrderDetail addProduct(Product product, int quantity) {
        OrderDetail detail = new OrderDetail();
        detail.setProduct(product);
        detail.setUnitPrice(product.getUnitPrice());
        detail.setQuantity((short)quantity);
        detail.setDiscount(BigDecimal.ZERO);
        this.addOrderDetail(detail);
        return detail;
    }

    public boolean isShipped() {
        return this.shippedDate != null;
    }

    public BigDecimal getOrderTotal() {
        BigDecimal total = this.orderDetails.stream().map(detail -> detail.getUnitPrice().multiply(new BigDecimal(detail.getQuantity().shortValue())).multiply(BigDecimal.ONE.subtract(detail.getDiscount()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        return this.freight != null ? total.add(this.freight) : total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        return Objects.equals(this.orderId, order.orderId);
    }

    public int hashCode() {
        return Objects.hash(this.orderId);
    }

    public String toString() {
        return "Order{orderId=" + this.orderId + ", customer=" + (this.customer != null ? this.customer.getCompanyName() : null) + ", orderDate=" + this.orderDate + ", shipped=" + this.isShipped() + ", itemCount=" + this.orderDetails.size() + ", total=" + this.getOrderTotal() + '}';
    }
}

