/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db.northwind.entities;

import com.sourcekraft.documentburster.common.db.northwind.entities.Employee;
import com.sourcekraft.documentburster.common.db.northwind.entities.EmployeeTerritoriesId;
import com.sourcekraft.documentburster.common.db.northwind.entities.Territory;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;

@Entity
@Table(name="\"EmployeeTerritories\"")
@IdClass(value=EmployeeTerritoriesId.class)
public class EmployeeTerritories {
    @Id
    @Column(name="\"EmployeeID\"")
    private Integer employeeId;
    @Id
    @Column(name="\"TerritoryID\"")
    private String territoryId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"EmployeeID\"", insertable=false, updatable=false)
    private Employee employee;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"TerritoryID\"", insertable=false, updatable=false)
    private Territory territory;

    public EmployeeTerritories() {
    }

    public EmployeeTerritories(Employee employee, Territory territory) {
        this.employee = employee;
        this.territory = territory;
        this.employeeId = employee.getEmployeeId();
        this.territoryId = territory.getTerritoryId();
    }

    public Integer getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(Integer employeeId) {
        this.employeeId = employeeId;
    }

    public String getTerritoryId() {
        return this.territoryId;
    }

    public void setTerritoryId(String territoryId) {
        this.territoryId = territoryId;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
        if (employee != null) {
            this.employeeId = employee.getEmployeeId();
        }
    }

    public Territory getTerritory() {
        return this.territory;
    }

    public void setTerritory(Territory territory) {
        this.territory = territory;
        if (territory != null) {
            this.territoryId = territory.getTerritoryId();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployeeTerritories that = (EmployeeTerritories)o;
        return Objects.equals(this.employeeId, that.employeeId) && Objects.equals(this.territoryId, that.territoryId);
    }

    public int hashCode() {
        return Objects.hash(this.employeeId, this.territoryId);
    }

    public String toString() {
        return "EmployeeTerritories{employee=" + (this.employee != null ? this.employee.getLastName() : null) + ", territory=" + (this.territory != null ? this.territory.getTerritoryDescription() : null) + '}';
    }
}

