/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db;

import com.sourcekraft.documentburster.common.db.DatabaseConnectionManager;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlExecutor {
    private static final Logger log = LoggerFactory.getLogger(SqlExecutor.class);
    private final DatabaseConnectionManager dbManager;

    public SqlExecutor(DatabaseConnectionManager dbManager) {
        if (dbManager == null) {
            throw new IllegalArgumentException("DatabaseConnectionManager cannot be null for SqlExecutor.");
        }
        this.dbManager = dbManager;
        log.debug("SqlExecutor initialized.");
    }

    public List<Map<String, Object>> query(String sql, Map<String, Object> params) throws Exception {
        log.debug("Executing primary query: {}", (Object)sql);
        String primaryCode = this.dbManager.getSettings().getReportingPrimaryDatabaseConnectionCode();
        Jdbi jdbi = this.dbManager.getJdbi(primaryCode);
        return (List)jdbi.withHandle(handle -> this.executeQuery(handle, sql, params));
    }

    public List<Map<String, Object>> query(String sql) throws Exception {
        return this.query(sql, null);
    }

    public int update(String sql, Map<String, Object> params) throws Exception {
        log.debug("Executing primary update: {}", (Object)sql);
        String primaryCode = this.dbManager.getSettings().getReportingPrimaryDatabaseConnectionCode();
        Jdbi jdbi = this.dbManager.getJdbi(primaryCode);
        return (Integer)jdbi.withHandle(handle -> this.executeUpdate(handle, sql, params));
    }

    public int update(String sql) throws Exception {
        return this.update(sql, null);
    }

    public List<Map<String, Object>> queryOn(String connectionCode, String sql, Map<String, Object> params) throws Exception {
        log.debug("Executing query on '{}': {}", (Object)connectionCode, (Object)sql);
        if (StringUtils.isBlank((CharSequence)connectionCode)) {
            throw new IllegalArgumentException("Connection code cannot be blank for queryOn.");
        }
        Jdbi jdbi = this.dbManager.getJdbi(connectionCode);
        return (List)jdbi.withHandle(handle -> this.executeQuery(handle, sql, params));
    }

    public List<Map<String, Object>> queryOn(String connectionCode, String sql) throws Exception {
        return this.queryOn(connectionCode, sql, null);
    }

    public int updateOn(String connectionCode, String sql, Map<String, Object> params) throws Exception {
        log.debug("Executing update on '{}': {}", (Object)connectionCode, (Object)sql);
        if (StringUtils.isBlank((CharSequence)connectionCode)) {
            throw new IllegalArgumentException("Connection code cannot be blank for updateOn.");
        }
        Jdbi jdbi = this.dbManager.getJdbi(connectionCode);
        return (Integer)jdbi.withHandle(handle -> this.executeUpdate(handle, sql, params));
    }

    public int updateOn(String connectionCode, String sql) throws Exception {
        return this.updateOn(connectionCode, sql, null);
    }

    private List<Map<String, Object>> executeQuery(Handle handle, String sql, Map<String, Object> params) {
        Query query = handle.createQuery(sql);
        if (params != null && !params.isEmpty()) {
            query.bindMap(params);
        }
        return query.mapToMap().list();
    }

    private int executeUpdate(Handle handle, String sql, Map<String, Object> params) {
        Update updateStmt = handle.createUpdate(sql);
        if (params != null && !params.isEmpty()) {
            updateStmt.bindMap(params);
        }
        return updateStmt.execute();
    }
}

