/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db;

import com.sourcekraft.documentburster.common.db.DatabaseConnectionManager;
import com.sourcekraft.documentburster.common.settings.Settings;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterConnectionDatabaseSettings;
import java.sql.Connection;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConnectionTester {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConnectionTester.class);

    public void testConnection(String connectionFilePath) throws Exception {
        Settings settings = new Settings("");
        DocumentBursterConnectionDatabaseSettings dbSettings = settings.loadSettingsConnectionDatabaseByPath(connectionFilePath);
        DatabaseConnectionManager dbManager = new DatabaseConnectionManager(settings);
        try (Connection connection = dbManager.getJdbcConnection(dbSettings.connection.code);
             Statement stmt = connection.createStatement();){
            String testSql = this.getTestQueryForDatabase(dbSettings.connection.databaseserver.type);
            stmt.executeQuery(testSql);
        }
    }

    private String getTestQueryForDatabase(String dbType) {
        String type;
        switch (type = dbType != null ? dbType.toLowerCase() : "") {
            case "oracle": {
                return "SELECT 1 FROM DUAL";
            }
            case "db2": 
            case "ibmdb2": {
                return "SELECT 1 FROM SYSIBM.SYSDUMMY1";
            }
        }
        return "SELECT 1";
    }
}

