/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.chart;

import groovy.lang.Closure;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class ChartOptionsScript
extends Script {
    private String type = null;
    private String labelField = null;
    private Map<String, Object> options = new LinkedHashMap<String, Object>();
    private final List<String> labels = new ArrayList<String>();
    private final List<Map<String, Object>> datasets = new ArrayList<Map<String, Object>>();
    private final List<Map<String, Object>> dataRows = new ArrayList<Map<String, Object>>();

    public void chart(Closure<?> body) {
        body.setDelegate((Object)this);
        body.setResolveStrategy(1);
        body.call();
    }

    public void type(String t) {
        this.type = t;
    }

    public void labelField(String f) {
        this.labelField = f;
    }

    public void options(Map<String, Object> args) {
        if (args != null) {
            this.options.putAll(args);
        }
    }

    public void options(Closure<?> body) {
        NestedMapDelegate d = new NestedMapDelegate(this.options);
        body.setDelegate((Object)d);
        body.setResolveStrategy(1);
        body.call();
    }

    public void labels(List<String> vals) {
        if (vals != null) {
            this.labels.addAll(vals);
        }
    }

    public void data(List<Map<String, Object>> rows) {
        if (rows != null) {
            for (Map<String, Object> r : rows) {
                this.dataRows.add(new LinkedHashMap<String, Object>(r));
            }
        }
    }

    public void datasets(Closure<?> body) {
        body.setDelegate((Object)this);
        body.setResolveStrategy(1);
        body.call();
    }

    public void dataset(Map<String, Object> args) {
        if (args != null) {
            this.datasets.add(new LinkedHashMap<String, Object>(args));
        }
    }

    public void series(Closure<?> body) {
        SeriesContainer sc = new SeriesContainer();
        body.setDelegate((Object)sc);
        body.setResolveStrategy(1);
        body.call();
        this.datasets.addAll(sc.getSeries());
    }

    public void series(Map<String, Object> args) {
        if (args != null) {
            this.datasets.add(new LinkedHashMap<String, Object>(args));
        }
    }

    public Map<String, Object> getOptions() {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        if (this.type != null) {
            out.put("type", this.type);
        }
        if (this.labelField != null) {
            out.put("labelField", this.labelField);
        }
        if (!this.options.isEmpty()) {
            out.put("options", new LinkedHashMap<String, Object>(this.options));
        }
        if (!this.labels.isEmpty()) {
            out.put("labels", new ArrayList<String>(this.labels));
        }
        if (!this.datasets.isEmpty()) {
            out.put("datasets", new ArrayList<Map<String, Object>>(this.datasets));
        }
        if (!this.dataRows.isEmpty()) {
            out.put("data", new ArrayList<Map<String, Object>>(this.dataRows));
        }
        return out;
    }

    public Object run() {
        return null;
    }

    public Object methodMissing(String name, Object args) {
        if (args instanceof Object[] && ((Object[])args).length > 0) {
            this.options.put(name, ((Object[])args)[0]);
        } else {
            this.options.put(name, args);
        }
        return null;
    }

    private static class NestedMapDelegate {
        private final Map<String, Object> map;

        NestedMapDelegate(Map<String, Object> map) {
            this.map = map;
        }

        public Object methodMissing(String name, Object args) {
            if (args instanceof Object[]) {
                Object[] arr = (Object[])args;
                if (arr.length == 1 && arr[0] instanceof Closure) {
                    LinkedHashMap<String, Object> subMap = new LinkedHashMap<String, Object>();
                    Closure c = (Closure)arr[0];
                    NestedMapDelegate sub = new NestedMapDelegate(subMap);
                    c.setDelegate((Object)sub);
                    c.setResolveStrategy(1);
                    c.call();
                    this.map.put(name, subMap);
                } else if (arr.length > 0) {
                    this.map.put(name, arr[0]);
                }
            } else {
                this.map.put(name, args);
            }
            return null;
        }
    }

    private static class SeriesContainer {
        private final List<Map<String, Object>> series = new ArrayList<Map<String, Object>>();

        private SeriesContainer() {
        }

        public void series(Map<String, Object> args) {
            if (args != null) {
                this.series.add(new LinkedHashMap<String, Object>(args));
            }
        }

        public void series(Closure<?> body) {
            LinkedHashMap<String, Object> s = new LinkedHashMap<String, Object>();
            SeriesDelegate d = new SeriesDelegate(s);
            body.setDelegate((Object)d);
            body.setResolveStrategy(1);
            body.call();
            this.series.add(s);
        }

        public List<Map<String, Object>> getSeries() {
            return this.series;
        }
    }

    private static class SeriesDelegate {
        private final Map<String, Object> map;

        SeriesDelegate(Map<String, Object> map) {
            this.map = map;
        }

        public void field(String f) {
            this.map.put("field", f);
        }

        public void label(String l) {
            this.map.put("label", l);
        }

        public void color(String c) {
            this.map.put("color", c);
        }

        public void backgroundColor(String c) {
            this.map.put("backgroundColor", c);
        }

        public void borderColor(String c) {
            this.map.put("borderColor", c);
        }

        public void type(String t) {
            this.map.put("type", t);
        }

        public void yAxisID(String id) {
            this.map.put("yAxisID", id);
        }

        public void xAxisID(String id) {
            this.map.put("xAxisID", id);
        }

        public void borderWidth(Object w) {
            this.map.put("borderWidth", w);
        }

        public void fill(Object f) {
            this.map.put("fill", f);
        }

        public void tension(Object t) {
            this.map.put("tension", t);
        }

        public void pointRadius(Object r) {
            this.map.put("pointRadius", r);
        }

        public void pointStyle(Object s) {
            this.map.put("pointStyle", s);
        }

        public void hidden(Object h) {
            this.map.put("hidden", h);
        }

        public void order(Object o) {
            this.map.put("order", o);
        }

        public void methodMissing(String name, Object args) {
            if (args instanceof Object[] && ((Object[])args).length > 0) {
                this.map.put(name, ((Object[])args)[0]);
            } else {
                this.map.put(name, args);
            }
        }
    }
}

