/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.run;

import org.docx4j.UnitsOfMeasurement;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.model.properties.run.AbstractRunProperty;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public class RBorder
extends AbstractRunProperty {
    protected static Logger log = LoggerFactory.getLogger(RBorder.class);
    public static final String CSS_NAME_STYLE = "border-style";
    public static final String CSS_NAME_WIDTH = "border-width";
    public static final String CSS_NAME_COLOR = "border-color";

    @Override
    public String getCssName() {
        return "border";
    }

    public RBorder(CTBorder val) {
        this.setObject(val);
    }

    public RBorder(CSSValue value) {
    }

    @Override
    public String getCssProperty() {
        CTBorder border = (CTBorder)this.getObject();
        if (border == null) {
            return "";
        }
        String val = "";
        if (border.getVal() != null) {
            STBorder stBorder = border.getVal();
            log.debug("border: " + stBorder);
            if (stBorder.equals((Object)STBorder.NIL) || stBorder == STBorder.NONE) {
                val = "none";
            } else if (stBorder == STBorder.SINGLE) {
                val = "solid";
            } else if (stBorder == STBorder.DOUBLE || stBorder == STBorder.DOTTED || stBorder == STBorder.DASHED || stBorder == STBorder.OUTSET || stBorder == STBorder.INSET) {
                val = stBorder.value();
            } else {
                log.warn("Falling back to solid");
                val = "solid";
            }
            val = RBorder.composeCss(CSS_NAME_STYLE, val);
        }
        Object sz = "";
        if (border.getSz() != null) {
            float mm = this.eighthsToMM(border.getSz().intValue());
            sz = (double)mm < 0.262 ? "1px" : UnitsOfMeasurement.format2DP.format(mm) + "mm";
            sz = RBorder.composeCss(CSS_NAME_WIDTH, (String)sz);
        }
        Object color = "";
        if (border.getColor() != null) {
            color = border.getColor().equals("auto") ? "#000000" : "#" + border.getColor();
            color = RBorder.composeCss(CSS_NAME_COLOR, (String)color);
        }
        return val + (String)sz + (String)color;
    }

    public float eighthsToMM(int eighths) {
        float inches = (float)eighths / 576.0f;
        return inches / 0.0394f;
    }

    @Override
    public void setXslFO(Element foElement) {
        Object val = null;
        CTBorder border = (CTBorder)this.getObject();
        if (border == null) {
            return;
        }
        if (border.getVal() != null) {
            STBorder stBorder = border.getVal();
            log.debug("border: " + stBorder);
            if (stBorder.equals((Object)STBorder.NIL) || stBorder == STBorder.NONE) {
                val = "none";
            } else if (stBorder == STBorder.SINGLE) {
                val = "solid";
            } else if (stBorder == STBorder.DOUBLE || stBorder == STBorder.DOTTED || stBorder == STBorder.DASHED || stBorder == STBorder.OUTSET || stBorder == STBorder.INSET) {
                val = stBorder.value();
            } else {
                log.warn("Falling back to solid");
                val = "solid";
            }
            foElement.setAttribute(CSS_NAME_STYLE, (String)val);
        }
        if (border.getSz() != null) {
            float mm = this.eighthsToMM(border.getSz().intValue());
            val = UnitsOfMeasurement.format2DP.format(mm) + "mm";
            foElement.setAttribute(CSS_NAME_WIDTH, (String)val);
        }
        if (border.getColor() != null) {
            val = border.getColor().equals("auto") ? "#000000" : "#" + border.getColor();
            foElement.setAttribute(CSS_NAME_COLOR, (String)val);
        }
    }

    @Override
    public void set(RPr rPr) {
        rPr.setBdr((CTBorder)this.getObject());
    }

    @Override
    public void set(CTTextCharacterProperties rPr) {
    }
}

