/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.postgresql;

import com.querydsl.core.QueryFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.AbstractSQLQuery;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.RelationalPath;
import java.sql.Connection;
import java.util.function.Supplier;

public abstract class AbstractPostgreSQLQuery<T, C extends AbstractPostgreSQLQuery<T, C>>
extends AbstractSQLQuery<T, C> {
    public AbstractPostgreSQLQuery(Connection conn, Configuration configuration, QueryMetadata metadata) {
        super(conn, configuration, metadata);
    }

    public AbstractPostgreSQLQuery(Supplier<Connection> connProvider, Configuration configuration, QueryMetadata metadata) {
        super(connProvider, configuration, metadata);
    }

    @Override
    public C forShare() {
        return (C)((AbstractPostgreSQLQuery)super.forShare());
    }

    public C noWait() {
        QueryFlag noWaitFlag = this.configuration.getTemplates().getNoWaitFlag();
        return (C)((AbstractPostgreSQLQuery)this.addFlag(noWaitFlag));
    }

    public C of(RelationalPath<?> ... paths) {
        StringBuilder builder = new StringBuilder(" of ");
        for (RelationalPath<?> path : paths) {
            if (builder.length() > 4) {
                builder.append(", ");
            }
            builder.append(this.getConfiguration().getTemplates().quoteIdentifier(path.getTableName()));
        }
        return (C)((AbstractPostgreSQLQuery)this.addFlag(QueryFlag.Position.END, builder.toString()));
    }

    public C distinctOn(Expression<?> ... exprs) {
        return (C)((AbstractPostgreSQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, (Expression)Expressions.template(Object.class, (String)"distinct on({0}) ", (Object[])new Object[]{ExpressionUtils.list(Object.class, exprs)})));
    }
}

