/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.smimesupport.builder;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.internal.smimesupport.builder.SmimeParseResult;
import org.simplejavamail.api.internal.smimesupport.model.AttachmentDecryptionResult;
import org.simplejavamail.internal.smimesupport.model.OriginalSmimeDetailsImpl;

public class SmimeParseResultBuilder
implements SmimeParseResult {
    @NotNull
    private final List<AttachmentDecryptionResult> decryptedAttachments = new ArrayList<AttachmentDecryptionResult>();
    @NotNull
    private final OriginalSmimeDetailsImpl originalSmimeDetails = OriginalSmimeDetailsImpl.builder().build();
    @Nullable
    private AttachmentResource smimeSignedEmailToProcess;

    public void addDecryptedAttachments(@NotNull List<AttachmentDecryptionResult> attachments) {
        this.decryptedAttachments.addAll(attachments);
    }

    public void setSmimeSignedEmailToProcess(@NotNull AttachmentResource smimeSignedEmailToProcess) {
        this.smimeSignedEmailToProcess = smimeSignedEmailToProcess;
    }

    @NotNull
    public OriginalSmimeDetailsImpl getOriginalSmimeDetails() {
        return this.originalSmimeDetails;
    }

    @Nullable
    public AttachmentResource getSmimeSignedEmail() {
        return this.smimeSignedEmailToProcess;
    }

    @NotNull
    public List<AttachmentDecryptionResult> getDecryptedAttachmentResults() {
        return this.decryptedAttachments;
    }

    @NotNull
    public List<AttachmentResource> getDecryptedAttachments() {
        ArrayList<AttachmentResource> attachmentResources = new ArrayList<AttachmentResource>();
        for (AttachmentDecryptionResult decryptedAttachment : this.decryptedAttachments) {
            attachmentResources.add(decryptedAttachment.getAttachmentResource());
        }
        return attachmentResources;
    }
}

