/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.genericobjectpool.expirypolicies;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bbottema.genericobjectpool.ExpirationPolicy;
import org.bbottema.genericobjectpool.PoolableObject;
import org.jetbrains.annotations.NotNull;

public abstract class SpreadedTimeoutExpirationPolicy<T>
implements ExpirationPolicy<T> {
    private final long lowerBoundMs;
    private final long upperBoundMs;

    /*
     * WARNING - void declaration
     */
    SpreadedTimeoutExpirationPolicy(long lowerBound, long upperBound, TimeUnit timeUnit) {
        void unit;
        if (timeUnit == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/genericobjectpool/expirypolicies/SpreadedTimeoutExpirationPolicy.<init> must not be null");
        }
        if (lowerBound < 1L) {
            throw new IllegalArgumentException("The lower bound cannot be less than 1.");
        }
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("The upper bound must be greater than the lower bound.");
        }
        this.lowerBoundMs = unit.toMillis(lowerBound);
        this.upperBoundMs = unit.toMillis(upperBound);
    }

    @Override
    public boolean hasExpired(@NotNull PoolableObject<T> poolableObject) {
        if (poolableObject == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/expirypolicies/SpreadedTimeoutExpirationPolicy.hasExpired must not be null");
        }
        Map<ExpirationPolicy, Long> expiriesMs = poolableObject.getExpiriesMs();
        if (!expiriesMs.containsKey(this)) {
            expiriesMs.put(this, this.lowerBoundMs + (long)(Math.random() * (double)(this.upperBoundMs - this.lowerBoundMs)));
        }
        return this._hasExpired(poolableObject);
    }

    abstract boolean _hasExpired(@NotNull PoolableObject<T> var1);

    public long getLowerBoundMs() {
        return this.lowerBoundMs;
    }

    public long getUpperBoundMs() {
        return this.upperBoundMs;
    }

    public boolean equals(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/expirypolicies/SpreadedTimeoutExpirationPolicy.equals must not be null");
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpreadedTimeoutExpirationPolicy)) {
            return false;
        }
        SpreadedTimeoutExpirationPolicy other = (SpreadedTimeoutExpirationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLowerBoundMs() != other.getLowerBoundMs()) {
            return false;
        }
        return this.getUpperBoundMs() == other.getUpperBoundMs();
    }

    protected boolean canEqual(Object other) {
        if (other == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/expirypolicies/SpreadedTimeoutExpirationPolicy.canEqual must not be null");
        }
        return other instanceof SpreadedTimeoutExpirationPolicy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lowerBoundMs = this.getLowerBoundMs();
        result = result * 59 + (int)($lowerBoundMs >>> 32 ^ $lowerBoundMs);
        long $upperBoundMs = this.getUpperBoundMs();
        result = result * 59 + (int)($upperBoundMs >>> 32 ^ $upperBoundMs);
        return result;
    }

    public String toString() {
        String string = "SpreadedTimeoutExpirationPolicy(lowerBoundMs=" + this.getLowerBoundMs() + ", upperBoundMs=" + this.getUpperBoundMs() + ")";
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/genericobjectpool/expirypolicies/SpreadedTimeoutExpirationPolicy.toString must not return null");
        }
        return string;
    }
}

