/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.genericobjectpool;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bbottema.genericobjectpool.ExpirationPolicy;
import org.bbottema.genericobjectpool.GenericObjectPool;
import org.jetbrains.annotations.NotNull;

public class PoolableObject<T> {
    private final GenericObjectPool<T> pool;
    @NotNull
    private T allocatedObject;
    private final Date createdOn;
    private final long creationStampMs;
    private long allocationStampMs;
    @NotNull
    private Map<ExpirationPolicy, Long> expiriesMs;
    @NotNull
    private PoolStatus currentPoolStatus;

    PoolableObject(GenericObjectPool<T> pool, @NotNull T allocatedObject) {
        if (pool == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/PoolableObject.<init> must not be null");
        }
        if (allocatedObject == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/genericobjectpool/PoolableObject.<init> must not be null");
        }
        this.createdOn = new Date();
        this.expiriesMs = new HashMap<ExpirationPolicy, Long>();
        this.pool = pool;
        this.allocatedObject = allocatedObject;
        this.allocationStampMs = this.creationStampMs = System.currentTimeMillis();
        this.currentPoolStatus = PoolStatus.AVAILABLE;
    }

    public void release() {
        this.pool.releasePoolableObject(this);
    }

    public void invalidate() {
        this.pool.invalidatePoolableObject(this);
    }

    void resetAllocationTimestamp() {
        this.allocationStampMs = System.currentTimeMillis();
    }

    public long ageMs() {
        return System.currentTimeMillis() - this.creationStampMs;
    }

    public long allocationAgeMs() {
        return System.currentTimeMillis() - this.allocationStampMs;
    }

    void dereferenceObject() {
        this.allocatedObject = ObjectDeallocated.INSTANCE;
    }

    @NotNull
    public T getAllocatedObject() {
        if (this.currentPoolStatus == PoolStatus.DEALLOCATED) {
            throw new IllegalStateException("This object has already been deallocated, you can't use it anymore!");
        }
        T t = this.allocatedObject;
        if (t == null) {
            throw new IllegalStateException("NotNull method org/bbottema/genericobjectpool/PoolableObject.getAllocatedObject must not return null");
        }
        return t;
    }

    public String toString() {
        String string = "PoolableObject(allocatedObject=" + this.getAllocatedObject() + ", createdOn=" + this.getCreatedOn() + ", creationStampMs=" + this.creationStampMs + ", allocationStampMs=" + this.allocationStampMs + ", expiriesMs=" + this.getExpiriesMs() + ", currentPoolStatus=" + (Object)((Object)this.getCurrentPoolStatus()) + ")";
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/genericobjectpool/PoolableObject.toString must not return null");
        }
        return string;
    }

    public Date getCreatedOn() {
        Date date = this.createdOn;
        if (date == null) {
            throw new IllegalStateException("NotNull method org/bbottema/genericobjectpool/PoolableObject.getCreatedOn must not return null");
        }
        return date;
    }

    public Map<ExpirationPolicy, Long> getExpiriesMs() {
        Map<ExpirationPolicy, Long> map = this.expiriesMs;
        if (map == null) {
            throw new IllegalStateException("NotNull method org/bbottema/genericobjectpool/PoolableObject.getExpiriesMs must not return null");
        }
        return map;
    }

    PoolStatus getCurrentPoolStatus() {
        PoolStatus poolStatus = this.currentPoolStatus;
        if (poolStatus == null) {
            throw new IllegalStateException("NotNull method org/bbottema/genericobjectpool/PoolableObject.getCurrentPoolStatus must not return null");
        }
        return poolStatus;
    }

    void setCurrentPoolStatus(PoolStatus currentPoolStatus) {
        if (currentPoolStatus == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/PoolableObject.setCurrentPoolStatus must not be null");
        }
        this.currentPoolStatus = currentPoolStatus;
    }

    static class ObjectDeallocated {
        static final ObjectDeallocated INSTANCE = new ObjectDeallocated();

        ObjectDeallocated() {
        }
    }

    static enum PoolStatus {
        AVAILABLE,
        CLAIMED,
        WAITING_FOR_DEALLOCATION,
        DEALLOCATED;


        private PoolStatus() {
            if (string == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/PoolableObject$PoolStatus.<init> must not be null");
            }
        }
    }
}

