/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.genericobjectpool;

public class PoolMetrics {
    private final int currentlyClaimed;
    private final int currentlyWaitingCount;
    private final int currentlyAllocated;
    private final int corePoolsize;
    private final int maxPoolsize;
    private final long totalAllocated;
    private final long totalClaimed;

    public PoolMetrics(int currentlyClaimed, int currentlyWaitingCount, int currentlyAllocated, int corePoolsize, int maxPoolsize, long totalAllocated, long totalClaimed) {
        this.currentlyClaimed = currentlyClaimed;
        this.currentlyWaitingCount = currentlyWaitingCount;
        this.currentlyAllocated = currentlyAllocated;
        this.corePoolsize = corePoolsize;
        this.maxPoolsize = maxPoolsize;
        this.totalAllocated = totalAllocated;
        this.totalClaimed = totalClaimed;
    }

    public int getCurrentlyClaimed() {
        return this.currentlyClaimed;
    }

    public int getCurrentlyWaitingCount() {
        return this.currentlyWaitingCount;
    }

    public int getCurrentlyAllocated() {
        return this.currentlyAllocated;
    }

    public int getCorePoolsize() {
        return this.corePoolsize;
    }

    public int getMaxPoolsize() {
        return this.maxPoolsize;
    }

    public long getTotalAllocated() {
        return this.totalAllocated;
    }

    public long getTotalClaimed() {
        return this.totalClaimed;
    }

    public boolean equals(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/PoolMetrics.equals must not be null");
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof PoolMetrics)) {
            return false;
        }
        PoolMetrics other = (PoolMetrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrentlyClaimed() != other.getCurrentlyClaimed()) {
            return false;
        }
        if (this.getCurrentlyWaitingCount() != other.getCurrentlyWaitingCount()) {
            return false;
        }
        if (this.getCurrentlyAllocated() != other.getCurrentlyAllocated()) {
            return false;
        }
        if (this.getCorePoolsize() != other.getCorePoolsize()) {
            return false;
        }
        if (this.getMaxPoolsize() != other.getMaxPoolsize()) {
            return false;
        }
        if (this.getTotalAllocated() != other.getTotalAllocated()) {
            return false;
        }
        return this.getTotalClaimed() == other.getTotalClaimed();
    }

    protected boolean canEqual(Object other) {
        if (other == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/PoolMetrics.canEqual must not be null");
        }
        return other instanceof PoolMetrics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrentlyClaimed();
        result = result * 59 + this.getCurrentlyWaitingCount();
        result = result * 59 + this.getCurrentlyAllocated();
        result = result * 59 + this.getCorePoolsize();
        result = result * 59 + this.getMaxPoolsize();
        long $totalAllocated = this.getTotalAllocated();
        result = result * 59 + (int)($totalAllocated >>> 32 ^ $totalAllocated);
        long $totalClaimed = this.getTotalClaimed();
        result = result * 59 + (int)($totalClaimed >>> 32 ^ $totalClaimed);
        return result;
    }

    public String toString() {
        String string = "PoolMetrics(currentlyClaimed=" + this.getCurrentlyClaimed() + ", currentlyWaitingCount=" + this.getCurrentlyWaitingCount() + ", currentlyAllocated=" + this.getCurrentlyAllocated() + ", corePoolsize=" + this.getCorePoolsize() + ", maxPoolsize=" + this.getMaxPoolsize() + ", totalAllocated=" + this.getTotalAllocated() + ", totalClaimed=" + this.getTotalClaimed() + ")";
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/genericobjectpool/PoolMetrics.toString must not return null");
        }
        return string;
    }
}

