/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.genericobjectpool;

import org.bbottema.genericobjectpool.PoolableObject;
import org.jetbrains.annotations.NotNull;

public interface ExpirationPolicy<T> {
    public boolean hasExpired(@NotNull PoolableObject<T> var1);

    public static class NeverExpirePolicy<T>
    implements ExpirationPolicy<T> {
        private static final NeverExpirePolicy<?> NEVER_EXPIRE_POLICY = new NeverExpirePolicy();

        static <T> NeverExpirePolicy<T> getInstance() {
            NeverExpirePolicy<?> neverExpirePolicy = NEVER_EXPIRE_POLICY;
            if (neverExpirePolicy == null) {
                throw new IllegalStateException("NotNull method org/bbottema/genericobjectpool/ExpirationPolicy$NeverExpirePolicy.getInstance must not return null");
            }
            return neverExpirePolicy;
        }

        @Override
        public boolean hasExpired(@NotNull PoolableObject<T> poolableObject) {
            if (poolableObject == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/ExpirationPolicy$NeverExpirePolicy.hasExpired must not be null");
            }
            return false;
        }

        public boolean equals(Object o) {
            if (o == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/ExpirationPolicy$NeverExpirePolicy.equals must not be null");
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof NeverExpirePolicy)) {
                return false;
            }
            NeverExpirePolicy other = (NeverExpirePolicy)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            if (other == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/ExpirationPolicy$NeverExpirePolicy.canEqual must not be null");
            }
            return other instanceof NeverExpirePolicy;
        }

        public int hashCode() {
            int result = 1;
            return result;
        }

        public String toString() {
            if ("ExpirationPolicy.NeverExpirePolicy()" == null) {
                throw new IllegalStateException("NotNull method org/bbottema/genericobjectpool/ExpirationPolicy$NeverExpirePolicy.toString must not return null");
            }
            return "ExpirationPolicy.NeverExpirePolicy()";
        }

        private NeverExpirePolicy() {
        }
    }
}

