/*
 * Decompiled with CFR 0.152.
 */
package org.hazlewood.connor.bottema.emailaddress;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import java.util.regex.Matcher;
import javax.mail.internet.InternetAddress;
import org.hazlewood.connor.bottema.emailaddress.Dragons;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmailAddressParser {
    private EmailAddressParser() {
    }

    public static boolean isValidReturnPath(@Nullable String email, @NotNull EnumSet<EmailAddressCriteria> criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.isValidReturnPath must not be null");
        }
        return email != null && Dragons.fromCriteria(criteria).RETURN_PATH_PATTERN.matcher(email).matches();
    }

    @Nullable
    public static String getReturnPathBracketContents(@Nullable String email, @NotNull EnumSet<EmailAddressCriteria> criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.getReturnPathBracketContents must not be null");
        }
        if (email == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).RETURN_PATH_PATTERN.matcher(email);
        return m.matches() ? m.group(1) : null;
    }

    @Nullable
    public static String getReturnPathAddress(@Nullable String email, @NotNull EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.getReturnPathAddress must not be null");
        }
        if (!EmailAddressParser.isValidReturnPath(email, criteria)) {
            return null;
        }
        InternetAddress ia = EmailAddressParser.getInternetAddress(email, criteria, extractCfwsPersonalNames);
        return ia == null ? "" : ia.getAddress();
    }

    public static boolean isValidMailboxList(@NotNull String header_txt, @NotNull EnumSet<EmailAddressCriteria> criteria) {
        if (header_txt == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.isValidMailboxList must not be null");
        }
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.isValidMailboxList must not be null");
        }
        return Dragons.fromCriteria(criteria).MAILBOX_LIST_PATTERN.matcher(header_txt).matches();
    }

    public static boolean isValidAddressList(@NotNull String header_txt, @NotNull EnumSet<EmailAddressCriteria> criteria) {
        if (header_txt == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.isValidAddressList must not be null");
        }
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.isValidAddressList must not be null");
        }
        Matcher m = Dragons.fromCriteria(criteria).ADDRESS_PATTERN.matcher(header_txt);
        int max = header_txt.length();
        while (m.lookingAt()) {
            if (m.end() == max) {
                return true;
            }
            if (header_txt.charAt(m.end()) == ',') {
                m.region(m.end() + 1, max);
                continue;
            }
            return false;
        }
        return false;
    }

    @Nullable
    public static InternetAddress getInternetAddress(@Nullable String email, @NotNull EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.getInternetAddress must not be null");
        }
        if (email == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).MAILBOX_PATTERN.matcher(email);
        return m.matches() ? EmailAddressParser.pullFromGroups(m, criteria, extractCfwsPersonalNames) : null;
    }

    @Nullable
    public static String[] getAddressParts(@Nullable String email, @NotNull EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.getAddressParts must not be null");
        }
        if (email == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).MAILBOX_PATTERN.matcher(email);
        return m.matches() ? EmailAddressParser.getMatcherParts(m, criteria, extractCfwsPersonalNames) : null;
    }

    @Nullable
    public static String getPersonalName(@Nullable String email, @NotNull EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.getPersonalName must not be null");
        }
        if (email == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).MAILBOX_PATTERN.matcher(email);
        return m.matches() ? EmailAddressParser.getMatcherParts(m, criteria, extractCfwsPersonalNames)[0] : null;
    }

    @Nullable
    public static String getLocalPart(@Nullable String email, @NotNull EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.getLocalPart must not be null");
        }
        if (email == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).MAILBOX_PATTERN.matcher(email);
        return m.matches() ? EmailAddressParser.getMatcherParts(m, criteria, extractCfwsPersonalNames)[1] : null;
    }

    @Nullable
    public static String getDomain(@Nullable String email, @NotNull EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.getDomain must not be null");
        }
        if (email == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).MAILBOX_PATTERN.matcher(email);
        return m.matches() ? EmailAddressParser.getMatcherParts(m, criteria, extractCfwsPersonalNames)[2] : null;
    }

    @NotNull
    public static InternetAddress[] extractHeaderAddresses(@Nullable String header_txt, @NotNull EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.extractHeaderAddresses must not be null");
        }
        if (header_txt == null || header_txt.equals("")) {
            InternetAddress[] internetAddressArray = new InternetAddress[]{};
            if (internetAddressArray == null) {
                throw new IllegalStateException("NotNull method org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.extractHeaderAddresses must not return null");
            }
            return internetAddressArray;
        }
        Dragons dragons = Dragons.fromCriteria(criteria);
        Matcher m = dragons.MAILBOX_PATTERN.matcher(header_txt);
        Matcher gp = dragons.GROUP_PREFIX_PATTERN.matcher(header_txt);
        ArrayList<InternetAddress> result = new ArrayList<InternetAddress>(1);
        int max = header_txt.length();
        boolean group_start = false;
        boolean group_end = false;
        int just_after_group_end = -1;
        while (true) {
            if (group_end) {
                int next_comma_index = header_txt.indexOf(44, just_after_group_end);
                if (next_comma_index < 0 || next_comma_index >= max - 1) break;
                gp.region(next_comma_index + 1, max);
                m.region(next_comma_index + 1, max);
                group_end = false;
            }
            if (header_txt.charAt(m.regionStart()) == ';') {
                group_start = false;
                m.region(m.regionStart() + 1, max);
                if (m.regionStart() >= max) break;
                gp.region(m.regionStart(), max);
                group_end = true;
                just_after_group_end = m.regionStart();
            }
            if (m.lookingAt()) {
                group_start = false;
                if (m.end() != max && header_txt.charAt(m.end()) != ',' && !(group_end = header_txt.charAt(m.end()) == ';')) break;
                InternetAddress cur_addr = EmailAddressParser.pullFromGroups(m, criteria, extractCfwsPersonalNames);
                if (cur_addr != null) {
                    result.add(cur_addr);
                }
                if (m.end() >= max - 1) break;
                if (!group_end) {
                    gp.region(m.end() + 1, max);
                    m.region(m.end() + 1, max);
                    continue;
                }
                just_after_group_end = m.end() + 1;
                continue;
            }
            if (gp.lookingAt()) {
                if (gp.end() >= max) break;
                m.region(gp.end(), max);
                gp.region(gp.end(), max);
                group_start = true;
                continue;
            }
            if (group_start) {
                int next_semicolon_index = header_txt.indexOf(59, m.regionStart());
                if (next_semicolon_index < 0 || next_semicolon_index >= max - 1) break;
                m.region(next_semicolon_index + 1, max);
                gp.region(next_semicolon_index + 1, max);
                group_start = false;
                group_end = true;
                just_after_group_end = m.regionStart();
                continue;
            }
            if (!group_end) break;
        }
        InternetAddress[] internetAddressArray = result.size() > 0 ? result.toArray(new InternetAddress[0]) : new InternetAddress[]{};
        if (internetAddressArray == null) {
            throw new IllegalStateException("NotNull method org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.extractHeaderAddresses must not return null");
        }
        return internetAddressArray;
    }

    @Nullable
    public static InternetAddress pullFromGroups(@NotNull Matcher m, @NotNull EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        if (m == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.pullFromGroups must not be null");
        }
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.pullFromGroups must not be null");
        }
        String[] parts = EmailAddressParser.getMatcherParts(m, criteria, extractCfwsPersonalNames);
        if (parts[1] != null && parts[2] != null) {
            try {
                return new InternetAddress(parts[1] + "@" + parts[2], parts[0]);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public static String[] getMatcherParts(@NotNull Matcher m, @NotNull EnumSet<EmailAddressCriteria> criteria, boolean extractCfwsPersonalNames) {
        String test_addr;
        if (m == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.getMatcherParts must not be null");
        }
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.getMatcherParts must not be null");
        }
        String current_localpart = null;
        String current_domainpart = null;
        String local_part_qs = null;
        String domain_part_dl = null;
        String personal_string = null;
        boolean allowDomainLiterals = criteria.contains((Object)EmailAddressCriteria.ALLOW_DOMAIN_LITERALS);
        if (criteria.contains((Object)EmailAddressCriteria.ALLOW_QUOTED_IDENTIFIERS)) {
            if (allowDomainLiterals) {
                if (m.group(1) != null) {
                    String domain_part_da;
                    String local_part_da = m.group(5);
                    if (local_part_da == null) {
                        local_part_qs = m.group(6);
                    }
                    if ((domain_part_da = m.group(7)) == null) {
                        domain_part_dl = m.group(8);
                    }
                    current_localpart = local_part_da == null ? local_part_qs : local_part_da;
                    current_domainpart = domain_part_da == null ? domain_part_dl : domain_part_da;
                    personal_string = m.group(2);
                    if (personal_string == null && extractCfwsPersonalNames) {
                        personal_string = m.group(9);
                        personal_string = EmailAddressParser.removeAnyBounding('(', ')', EmailAddressParser.getFirstComment(personal_string, criteria));
                    }
                } else if (m.group(10) != null) {
                    String domain_part_da;
                    String local_part_da = m.group(12);
                    if (local_part_da == null) {
                        local_part_qs = m.group(13);
                    }
                    if ((domain_part_da = m.group(14)) == null) {
                        domain_part_dl = m.group(15);
                    }
                    current_localpart = local_part_da == null ? local_part_qs : local_part_da;
                    String string = current_domainpart = domain_part_da == null ? domain_part_dl : domain_part_da;
                    if (extractCfwsPersonalNames) {
                        personal_string = m.group(16);
                        personal_string = EmailAddressParser.removeAnyBounding('(', ')', EmailAddressParser.getFirstComment(personal_string, criteria));
                    }
                }
            } else if (m.group(1) != null) {
                String local_part_da = m.group(5);
                if (local_part_da == null) {
                    local_part_qs = m.group(6);
                }
                current_localpart = local_part_da == null ? local_part_qs : local_part_da;
                current_domainpart = m.group(7);
                personal_string = m.group(2);
                if (personal_string == null && extractCfwsPersonalNames) {
                    personal_string = m.group(8);
                    personal_string = EmailAddressParser.removeAnyBounding('(', ')', EmailAddressParser.getFirstComment(personal_string, criteria));
                }
            } else if (m.group(9) != null) {
                String local_part_da = m.group(11);
                if (local_part_da == null) {
                    local_part_qs = m.group(12);
                }
                current_localpart = local_part_da == null ? local_part_qs : local_part_da;
                current_domainpart = m.group(13);
                if (extractCfwsPersonalNames) {
                    personal_string = m.group(14);
                    personal_string = EmailAddressParser.removeAnyBounding('(', ')', EmailAddressParser.getFirstComment(personal_string, criteria));
                }
            }
        } else {
            String domain_part_da;
            String local_part_da = m.group(3);
            if (local_part_da == null) {
                local_part_qs = m.group(4);
            }
            if ((domain_part_da = m.group(5)) == null && allowDomainLiterals) {
                domain_part_dl = m.group(6);
            }
            current_localpart = local_part_da == null ? local_part_qs : local_part_da;
            String string = current_domainpart = domain_part_da == null ? domain_part_dl : domain_part_da;
            if (extractCfwsPersonalNames) {
                personal_string = m.group((allowDomainLiterals ? 1 : 0) + 6);
                personal_string = EmailAddressParser.removeAnyBounding('(', ')', EmailAddressParser.getFirstComment(personal_string, criteria));
            }
        }
        if (current_localpart != null) {
            current_localpart = current_localpart.trim();
        }
        if (current_domainpart != null) {
            current_domainpart = current_domainpart.trim();
        }
        if (personal_string != null) {
            personal_string = personal_string.trim();
            personal_string = EmailAddressParser.cleanupPersonalString(personal_string, criteria);
        }
        if (Dragons.fromCriteria(criteria).ADDR_SPEC_PATTERN.matcher(test_addr = EmailAddressParser.removeAnyBounding('\"', '\"', current_localpart) + "@" + current_domainpart).matches()) {
            current_localpart = EmailAddressParser.removeAnyBounding('\"', '\"', current_localpart);
        }
        String[] stringArray = new String[]{personal_string, current_localpart, current_domainpart};
        if (stringArray == null) {
            throw new IllegalStateException("NotNull method org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.getMatcherParts must not return null");
        }
        return stringArray;
    }

    @Nullable
    public static String getFirstComment(@Nullable String text, @NotNull EnumSet<EmailAddressCriteria> criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.getFirstComment must not be null");
        }
        if (text == null) {
            return null;
        }
        Matcher m = Dragons.fromCriteria(criteria).COMMENT_PATTERN.matcher(text);
        if (!m.find()) {
            return null;
        }
        return m.group().trim();
    }

    @Nullable
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="false positive")
    public static String cleanupPersonalString(@Nullable String string, @NotNull EnumSet<EmailAddressCriteria> criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressParser.cleanupPersonalString must not be null");
        }
        if (string == null) {
            return null;
        }
        String text = string.trim();
        Dragons dragons = Dragons.fromCriteria(criteria);
        Matcher m = dragons.QUOTED_STRING_WO_CFWS_PATTERN.matcher(text);
        if (!m.matches()) {
            return text;
        }
        text = Objects.requireNonNull(EmailAddressParser.removeAnyBounding('\"', '\"', m.group()));
        text = dragons.ESCAPED_BSLASH_PATTERN.matcher(text).replaceAll("\\\\");
        text = dragons.ESCAPED_QUOTE_PATTERN.matcher(text).replaceAll("\"");
        return text.trim();
    }

    @Nullable
    public static String removeAnyBounding(char s, char e, @Nullable String str) {
        boolean valueStartsEndsWithSAndE = str != null && str.length() >= 2 && str.startsWith(String.valueOf(s)) && str.endsWith(String.valueOf(e));
        return valueStartsEndsWithSAndE ? str.substring(1, str.length() - 1) : str;
    }
}

