/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.authenticatedsockssupport.socks5client;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.simplejavamail.internal.authenticatedsockssupport.common.SocksException;
import org.simplejavamail.internal.authenticatedsockssupport.socks5client.KeyStoreInfo;
import org.simplejavamail.internal.util.MiscUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SSLConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLConfiguration.class);
    private final KeyStoreInfo keyStoreInfo;
    private final KeyStoreInfo trustKeyStoreInfo;

    private SSLConfiguration(KeyStoreInfo keyStoreInfo, KeyStoreInfo trustKeyStoreInfo) {
        this.keyStoreInfo = keyStoreInfo;
        this.trustKeyStoreInfo = trustKeyStoreInfo;
    }

    public SSLSocketFactory getSSLSocketFactory() throws SocksException {
        SSLSocketFactory sSLSocketFactory;
        MiscUtil.checkNotNull((Object)this.trustKeyStoreInfo, (String)"trustKeyStoreInfo may not be null");
        FileInputStream s1 = null;
        FileInputStream s2 = null;
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            KeyStore trustKeyStore = KeyStore.getInstance(this.trustKeyStoreInfo.getType());
            s1 = new FileInputStream(this.trustKeyStoreInfo.getKeyStorePath());
            trustKeyStore.load(s1, this.trustKeyStoreInfo.getPassword().toCharArray());
            trustManagerFactory.init(trustKeyStore);
            KeyStore keyStore = null;
            if (this.keyStoreInfo != null && this.keyStoreInfo.getKeyStorePath() != null) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyStore = KeyStore.getInstance(this.keyStoreInfo.getType());
                s2 = new FileInputStream(this.keyStoreInfo.getKeyStorePath());
                keyStore.load(s2, this.keyStoreInfo.getPassword().toCharArray());
                keyManagerFactory.init(keyStore, this.keyStoreInfo.getPassword().toCharArray());
                context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            } else {
                context.init(null, trustManagerFactory.getTrustManagers(), null);
            }
            if (keyStore != null) {
                LOGGER.info("SSL: Key store:{}", (Object)this.keyStoreInfo.getKeyStorePath());
            }
            LOGGER.info("SSL: Trust key store:{}", (Object)this.trustKeyStoreInfo.getKeyStorePath());
            sSLSocketFactory = context.getSocketFactory();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            try {
                throw new SocksException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                SSLConfiguration.tryCloseStream(s1);
                SSLConfiguration.tryCloseStream(s2);
                throw throwable;
            }
        }
        SSLConfiguration.tryCloseStream(s1);
        SSLConfiguration.tryCloseStream(s2);
        return sSLSocketFactory;
    }

    private static void tryCloseStream(FileInputStream s1) {
        if (s1 != null) {
            try {
                s1.close();
            }
            catch (IOException e) {
                LOGGER.error("unable to close stream", (Throwable)e);
            }
        }
    }
}

