/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.authenticatedsockssupport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.internal.authenticatedsockssupport.common.Socks5Bridge;
import org.simplejavamail.api.mailer.config.ProxyConfig;
import org.simplejavamail.internal.authenticatedsockssupport.socks5client.ProxyCredentials;
import org.simplejavamail.internal.authenticatedsockssupport.socks5client.Socks5;
import org.simplejavamail.internal.authenticatedsockssupport.socks5client.SocksSocket;
import org.simplejavamail.internal.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatingSocks5Bridge
implements Socks5Bridge {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"socks5bridge");
    @NotNull
    private final ProxyConfig proxyConfig;
    @NotNull
    private final String remoteProxyHost;
    @NotNull
    private final Integer remoteProxyPort;

    AuthenticatingSocks5Bridge(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        this.remoteProxyHost = (String)Preconditions.assumeNonNull((Object)proxyConfig.getRemoteProxyHost());
        this.remoteProxyPort = (Integer)Preconditions.assumeNonNull((Object)proxyConfig.getRemoteProxyPort());
    }

    public Socket connect(String sessionId, InetAddress remoteServerAddress, int remoteServerPort) throws IOException {
        return this.proxyConfig.requiresAuthentication() ? this.createSocketAuthenticated(sessionId, remoteServerAddress, remoteServerPort) : this.createSocketPlainAnonymous(sessionId, remoteServerAddress, remoteServerPort);
    }

    private Socket createSocketAuthenticated(String sessionId, InetAddress remoteServerAddress, int remoteServerPort) throws IOException {
        LOGGER.info("SESSION[{}] bridging to remote proxy {}", (Object)sessionId, (Object)this.proxyConfig);
        Socks5 proxyAuth = new Socks5(new InetSocketAddress(this.remoteProxyHost, (int)this.remoteProxyPort));
        proxyAuth.setCredentials(new ProxyCredentials(this.proxyConfig.getUsername(), this.proxyConfig.getPassword()));
        return new SocksSocket(proxyAuth, proxyAuth.createProxySocket(), new InetSocketAddress(remoteServerAddress, remoteServerPort));
    }

    private Socket createSocketPlainAnonymous(String sessionId, InetAddress remoteServerAddress, int remoteServerPort) throws IOException {
        LOGGER.info("SESSION[{}] bridging anonymously to remote proxy {}:{}", new Object[]{sessionId, this.remoteProxyHost, this.remoteProxyPort});
        Socks5 socksProxyAnonymous = new Socks5(new InetSocketAddress(this.remoteProxyHost, (int)this.remoteProxyPort));
        return new SocksSocket(socksProxyAnonymous, new InetSocketAddress(remoteServerAddress, remoteServerPort));
    }
}

