/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.pherialize;

import de.ailis.pherialize.Mixed;
import de.ailis.pherialize.MixedArray;
import de.ailis.pherialize.exceptions.UnserializeException;
import java.util.ArrayList;
import java.util.List;

public class Unserializer {
    private int pos;
    private final String data;
    private final List<Object> history;

    public Unserializer(String data) {
        this.data = data;
        this.pos = 0;
        this.history = new ArrayList<Object>();
    }

    public Mixed unserializeObject() {
        Mixed result;
        char type = this.data.charAt(this.pos);
        switch (type) {
            case 's': {
                result = this.unserializeString();
                break;
            }
            case 'i': {
                result = this.unserializeInteger();
                break;
            }
            case 'd': {
                result = this.unserializeDouble();
                break;
            }
            case 'b': {
                result = this.unserializeBoolean();
                break;
            }
            case 'N': {
                result = this.unserializeNull();
                break;
            }
            case 'a': {
                return this.unserializeArray();
            }
            case 'R': {
                result = this.unserializeReference();
                break;
            }
            default: {
                throw new UnserializeException("Unable to unserialize unknown type " + type);
            }
        }
        this.history.add(result);
        return result;
    }

    private Mixed unserializeString() {
        int pos = this.data.indexOf(58, this.pos + 2);
        int length = Integer.parseInt(this.data.substring(this.pos + 2, pos));
        this.pos = pos + length + 4;
        return new Mixed(this.data.substring(pos + 2, pos + 2 + length));
    }

    private Mixed unserializeInteger() {
        int pos = this.data.indexOf(59, this.pos + 2);
        Integer result = Integer.valueOf(this.data.substring(this.pos + 2, pos));
        this.pos = pos + 1;
        return new Mixed(result);
    }

    private Mixed unserializeDouble() {
        int pos = this.data.indexOf(59, this.pos + 2);
        Double result = Double.valueOf(this.data.substring(this.pos + 2, pos));
        this.pos = pos + 1;
        return new Mixed(result);
    }

    private Mixed unserializeReference() {
        int pos = this.data.indexOf(59, this.pos + 2);
        int index = Integer.parseInt(this.data.substring(this.pos + 2, pos));
        this.pos = pos + 1;
        return (Mixed)this.history.get(index - 1);
    }

    private Mixed unserializeBoolean() {
        Boolean result = this.data.charAt(this.pos + 2) == '1';
        this.pos += 4;
        return new Mixed(result);
    }

    private Mixed unserializeNull() {
        this.pos += 2;
        return null;
    }

    private Mixed unserializeArray() {
        int pos = this.data.indexOf(58, this.pos + 2);
        int max = Integer.parseInt(this.data.substring(this.pos + 2, pos));
        this.pos = pos + 2;
        MixedArray array = new MixedArray(max);
        Mixed result = new Mixed(array);
        this.history.add(result);
        for (int i = 0; i < max; ++i) {
            Mixed key = this.unserializeObject();
            this.history.remove(this.history.size() - 1);
            Mixed value = this.unserializeObject();
            array.put(key, value);
        }
        ++this.pos;
        return result;
    }
}

