/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sourcekraft.documentburster.common.settings.License;
import com.sourcekraft.documentburster.utils.Utils;
import de.ailis.pherialize.Pherialize;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseUtils {
    private Logger log = LoggerFactory.getLogger(License.class);
    private License license = new License();
    private static String BASE_LICENSE_SERVER_URL = "https://www.pdfburst.com/store/";
    private volatile String cachedCurlPath = null;
    private final int CURL_TIMEOUT_SECS = Integer.parseInt(System.getenv().getOrDefault("LICENSE_CURL_TIMEOUT_SECS", "90"));
    private final int CURL_ATTEMPTS = Integer.parseInt(System.getenv().getOrDefault("LICENSE_CURL_ATTEMPTS", "3"));

    public License getLicense() {
        return this.license;
    }

    public String getLicenseFilePath() {
        return this.license.getLicenseFilePath();
    }

    public void setLicenseFilePath(String licenseFilePath) {
        this.license.setLicenseFilePath(licenseFilePath);
    }

    public void activateLicense() throws Exception {
        this._doAction("activate_license");
        this._getLatestVersionAndChangeLog();
    }

    public void deActivateLicense() throws Exception {
        this._doAction("deactivate_license");
    }

    public void checkLicense() throws Exception {
        this._doAction("check_license");
        this._getLatestVersionAndChangeLog();
    }

    protected Object makeRequest(Client client, String url, String action) throws Exception {
        String reqId = UUID.randomUUID().toString().substring(0, 8);
        if ("JAXRS".equals(this.cachedCurlPath)) {
            this.log.debug("[{}] using cached JAXRS fallback for url={}", (Object)reqId, (Object)url);
            return client.target(url).request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).post(null);
        }
        if (this.cachedCurlPath != null && !"JAXRS".equals(this.cachedCurlPath)) {
            for (int a = 1; a <= this.CURL_ATTEMPTS; ++a) {
                long tStart = System.nanoTime();
                String out = this.tryCurlAndReturnString(this.cachedCurlPath, url, reqId);
                double attemptSec = (double)(System.nanoTime() - tStart) / 1.0E9;
                this.log.debug("[{}] cachedCandidateAttempt elapsed={}s candidate={}", new Object[]{reqId, String.format("%.3f", attemptSec), this.cachedCurlPath});
                if (out != null && this.isValidLicenseResponse(out)) {
                    this.log.debug("[{}] cached candidate {} produced valid response", (Object)reqId, (Object)this.cachedCurlPath);
                    return out;
                }
                this.log.debug("[{}] cached curl {} attempt {}/{} failed/invalid", new Object[]{reqId, this.cachedCurlPath, a, this.CURL_ATTEMPTS});
                try {
                    Thread.sleep(150L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            this.cachedCurlPath = null;
            this.log.debug("[{}] cleared cachedCurlPath after failed attempts", (Object)reqId);
        }
        ArrayList<String> candidates = new ArrayList<String>();
        String portableEnv = System.getenv("PORTABLE_EXECUTABLE_DIR");
        if (portableEnv != null && !portableEnv.isEmpty()) {
            candidates.add(Paths.get(portableEnv, new String[0]).resolve("tools").resolve("curl").resolve("win").resolve("curl.exe").toAbsolutePath().toString());
        }
        candidates.add(Paths.get(System.getProperty("user.dir"), new String[0]).resolve("tools").resolve("curl").resolve("win").resolve("curl.exe").toAbsolutePath().toString());
        candidates.add(Paths.get("", new String[0]).toAbsolutePath().resolve("tools").resolve("curl").resolve("win").resolve("curl.exe").toAbsolutePath().toString());
        candidates.add("curl.exe");
        String located = this.findCurlWithWhere();
        if (located != null && !located.isEmpty()) {
            candidates.add(located);
        }
        LinkedHashSet uniq = new LinkedHashSet(candidates);
        for (String cand : uniq) {
            Path p = Paths.get(cand, new String[0]);
            boolean allowPathLookup = "curl.exe".equalsIgnoreCase(cand);
            if (!(allowPathLookup || p.toFile().exists() && p.toFile().isFile())) {
                this.log.debug("[{}] curl candidate not present on disk, skipping: {}", (Object)reqId, (Object)cand);
                continue;
            }
            for (int a = 1; a <= this.CURL_ATTEMPTS; ++a) {
                long tStart = System.nanoTime();
                String out = this.tryCurlAndReturnString(cand, url, reqId);
                double attemptSec = (double)(System.nanoTime() - tStart) / 1.0E9;
                this.log.debug("[{}] attempt {} for candidate {} elapsed={}s", new Object[]{reqId, a, cand, String.format("%.3f", attemptSec)});
                if (out != null) {
                    if (this.isValidLicenseResponse(out)) {
                        this.cachedCurlPath = cand;
                        this.log.debug("[{}] candidate {} produced valid response and is cached", (Object)reqId, (Object)cand);
                        return out;
                    }
                    this.log.debug("[{}] curl (candidate {}) returned invalid payload attempt {}/{}. will retry/candidate-skip", new Object[]{reqId, cand, a, this.CURL_ATTEMPTS});
                } else {
                    this.log.debug("[{}] curl (candidate {}) failed attempt {}/{}", new Object[]{reqId, cand, a, this.CURL_ATTEMPTS});
                }
                try {
                    Thread.sleep(150L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            this.log.warn("[{}] url={} curl candidate {} exhausted after {} attempts and did not return a valid license payload", new Object[]{reqId, url, cand, this.CURL_ATTEMPTS});
        }
        this.cachedCurlPath = "JAXRS";
        this.log.debug("[{}] falling back to JAX-RS for url={}", (Object)reqId, (Object)url);
        return client.target(url).request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).post(null);
    }

    private boolean isValidLicenseResponse(String responseStr) {
        if (responseStr == null) {
            return false;
        }
        String trimmed = responseStr.trim();
        if (!trimmed.startsWith("{")) {
            String preview = trimmed.length() > 1000 ? trimmed.substring(0, 1000) + "..." : trimmed;
            this.log.info("Invalid license response (not JSON). preview: {}", (Object)preview);
            return false;
        }
        try {
            boolean ok;
            JsonNode n = new ObjectMapper().readTree(trimmed);
            boolean hasLicenseShape = n.has("license") && n.has("item_name");
            boolean hasGetVersionShape = n.has("new_version") && n.has("sections");
            boolean bl = ok = hasLicenseShape || hasGetVersionShape;
            if (!ok) {
                String preview = trimmed.length() > 1000 ? trimmed.substring(0, 1000) + "..." : trimmed;
                this.log.info("Invalid license response (missing expected keys). preview: {}", (Object)preview);
            }
            return ok;
        }
        catch (Exception e) {
            String preview = trimmed.length() > 1000 ? trimmed.substring(0, 1000) + "..." : trimmed;
            this.log.info("Invalid license response (parse error: {}). preview: {}", (Object)e.getMessage(), (Object)preview);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tryCurlAndReturnString(String curlPath, String url, String reqId) {
        boolean useGet;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(curlPath);
        cmd.add("-sS");
        boolean useInsecure = Boolean.parseBoolean(System.getenv().getOrDefault("LICENSE_CURL_INSECURE", "false"));
        if (useInsecure) {
            cmd.add("-k");
        }
        boolean bl = useGet = url != null && url.toLowerCase().contains("edd_action=get_version");
        if (useGet) {
            cmd.add("-H");
            cmd.add("Accept: text/plain");
            cmd.add("-L");
            cmd.add(url);
            this.log.debug("[{}] using GET for get_version url: {}", (Object)reqId, (Object)url);
        } else {
            cmd.add("-X");
            cmd.add("POST");
            cmd.add("-H");
            cmd.add("Accept: text/plain");
            cmd.add("-d");
            cmd.add("");
            cmd.add(url);
        }
        String cmdLine = cmd.stream().collect(Collectors.joining(" "));
        this.log.debug("[{}] invoking curl: {}", (Object)reqId, (Object)cmdLine);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(false);
        Process p = null;
        ByteArrayOutputStream stdoutBaos = new ByteArrayOutputStream();
        ByteArrayOutputStream stderrBaos = new ByteArrayOutputStream();
        Thread stdoutReader = null;
        Thread stderrReader = null;
        try {
            p = pb.start();
            InputStream pis = p.getInputStream();
            InputStream perr = p.getErrorStream();
            stdoutReader = new Thread(() -> {
                try (InputStream is = pis;){
                    int r;
                    byte[] buf = new byte[4096];
                    while ((r = is.read(buf)) != -1) {
                        stdoutBaos.write(buf, 0, r);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, "curl-stdout-" + reqId);
            stderrReader = new Thread(() -> {
                try (InputStream is = perr;){
                    int r;
                    byte[] buf = new byte[4096];
                    while ((r = is.read(buf)) != -1) {
                        stderrBaos.write(buf, 0, r);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, "curl-stderr-" + reqId);
            stdoutReader.setDaemon(true);
            stderrReader.setDaemon(true);
            stdoutReader.start();
            stderrReader.start();
            boolean finished = p.waitFor(this.CURL_TIMEOUT_SECS, TimeUnit.SECONDS);
            if (!finished) {
                p.destroyForcibly();
                this.log.debug("[{}] curl timeout for: {}", (Object)reqId, (Object)curlPath);
                try {
                    stdoutReader.join(200L);
                    stderrReader.join(200L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                String ie = null;
                return ie;
            }
            try {
                stdoutReader.join(1000L);
                stderrReader.join(1000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            String out = stdoutBaos.toString(StandardCharsets.UTF_8.name());
            double readSec = 0.0;
            String stderrPreview = stderrBaos.toString(StandardCharsets.UTF_8.name());
            int exit = p.exitValue();
            if (exit == 0) {
                this.log.debug("[{}] curl succeeded (path={}) exit=0 out-start={}  stderrPreview={}", new Object[]{reqId, curlPath, out == null ? "null" : (out.length() > 200 ? out.substring(0, 200) + "..." : out), stderrPreview.isEmpty() ? "none" : stderrPreview.replaceAll("\\r?\\n", " | ")});
                String string = out;
                return string;
            }
            this.log.debug("[{}] curl failed (path={}, exit={}) out-start={} stderrPreview={}", new Object[]{reqId, curlPath, exit, out == null ? "null" : (out.length() > 200 ? out.substring(0, 200) + "..." : out), stderrPreview.isEmpty() ? "none" : stderrPreview.replaceAll("\\r?\\n", " | ")});
            String string = null;
            return string;
        }
        catch (Exception e) {
            this.log.debug("[{}] curl invocation failed for {}: {}", new Object[]{reqId, curlPath, e.getMessage()});
            String string = null;
            return string;
        }
        finally {
            if (p != null) {
                p.destroyForcibly();
            }
        }
    }

    private String findCurlWithWhere() {
        boolean isWindows = System.getProperty("os.name", "").toLowerCase().contains("win");
        try {
            String out;
            ProcessBuilder pb = isWindows ? new ProcessBuilder("where.exe", "curl.exe") : new ProcessBuilder("which", "curl");
            pb.redirectErrorStream(true);
            Process p = pb.start();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (InputStream is = p.getInputStream();){
                int r;
                byte[] buf = new byte[4096];
                while ((r = is.read(buf)) != -1) {
                    baos.write(buf, 0, r);
                }
            }
            int exit = p.waitFor();
            if (exit == 0 && !(out = baos.toString(StandardCharsets.UTF_8.name()).trim()).isEmpty()) {
                return out.split("\\r?\\n")[0].trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _makeRequestAndHandleResponse(String url, String action) throws Exception {
        Client client = this._newClient();
        try {
            String responseStr;
            long t0 = System.nanoTime();
            Object responseObj = this.makeRequest(client, url, action);
            double elapsedSec = (double)(System.nanoTime() - t0) / 1.0E9;
            String elapsed = String.format("%.3f", elapsedSec);
            if (responseObj instanceof String) {
                responseStr = (String)responseObj;
            } else if (responseObj instanceof Response) {
                Response resp = (Response)responseObj;
                responseStr = (String)resp.readEntity(String.class);
            } else {
                throw new IOException("makeRequest returned unexpected type: " + (responseObj == null ? "null" : responseObj.getClass()));
            }
            JsonNode licenseJSONResult = new ObjectMapper().readTree(responseStr);
            this.license.setStatus(licenseJSONResult.get("license").asText());
            this.license.setProduct(licenseJSONResult.get("item_name").asText());
            this.license.setCustomerName(licenseJSONResult.get("customer_name").asText());
            this.license.setCustomerEmail(licenseJSONResult.get("customer_email").asText());
            this.license.setExpires(licenseJSONResult.get("expires").asText());
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            this.license.setCustomerName("License Exception (most probably SSL Exception)");
            this.license.setCustomerEmail("license@exception");
            this.license.setStatus(License.STATUS_VALID.toLowerCase());
        }
        finally {
            client.close();
            this.license.saveLicense();
        }
    }

    private void _doAction(String action) throws Exception {
        this.license.loadLicense();
        if (StringUtils.isEmpty((CharSequence)this.license.getKey())) {
            throw new IllegalStateException("License key is not defined. Cannot perform action '" + action + "'. Please enter a valid license key before performing this action.");
        }
        String url = BASE_LICENSE_SERVER_URL + "?edd_action=" + action + "&item_name=" + Utils.encodeURIComponent((String)Utils.getProduct()) + "&license=" + Utils.encodeURIComponent((String)this.license.getKey());
        this._makeRequestAndHandleResponse(url, action);
    }

    private Client _newClient() throws Exception {
        TrustManager[] trustManager = new X509TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustManager, null);
        return ClientBuilder.newBuilder().sslContext(sslContext).hostnameVerifier((s1, s2) -> true).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _getLatestVersionAndChangeLog() throws Exception {
        this.license.loadLicense();
        String url = BASE_LICENSE_SERVER_URL + "?edd_action=get_version&item_name=" + Utils.encodeURIComponent((String)Utils.getProduct()) + "&license=" + Utils.encodeURIComponent((String)this.license.getKey());
        String changeLog = "";
        String latestVersion = "";
        Client client = this._newClient();
        try {
            String responseStr;
            Object responseObj = this.makeRequest(client, url, "get_version");
            if (responseObj instanceof String) {
                responseStr = (String)responseObj;
            } else if (responseObj instanceof Response) {
                responseStr = (String)((Response)responseObj).readEntity(String.class);
            } else {
                throw new IOException("makeRequest returned unexpected type: " + (responseObj == null ? "null" : responseObj.getClass()));
            }
            JsonNode licenseJSONResult = new ObjectMapper().readTree(responseStr);
            changeLog = Pherialize.unserialize((String)licenseJSONResult.get("sections").asText()).toArray().getString((Object)"changelog");
            latestVersion = licenseJSONResult.get("new_version").asText();
        }
        catch (Exception e) {
            changeLog = "";
            latestVersion = "";
        }
        finally {
            client.close();
            if (StringUtils.isNotEmpty((CharSequence)changeLog)) {
                changeLog = changeLog.replace("<p>", "\n").replace("</p>", "\n").replace("<br />", "").replace("<br/>", "");
            }
            this.license.setLatestVersion(latestVersion);
            this.license.setChangeLog(changeLog);
            this.license.saveLicense();
        }
    }
}

