/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.utils;

import com.sourcekraft.documentburster.utils.DocumentBursterFreemarkerInitializer;
import freemarker.template.Template;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerRenderingUtils {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerRenderingUtils.class);

    public static String renderTemplate(String templatePath, Map<String, Object> userVariables) throws Exception {
        log.debug("Rendering FreeMarker template: {}", (Object)templatePath);
        File templateFile = new File(templatePath);
        File parentDir = templateFile.getParentFile();
        DocumentBursterFreemarkerInitializer.FREE_MARKER_CFG.setDirectoryForTemplateLoading(parentDir);
        Template template = DocumentBursterFreemarkerInitializer.FREE_MARKER_CFG.getTemplate(templateFile.getName());
        StringWriter writer = new StringWriter();
        template.process(userVariables, (Writer)writer);
        String result = writer.toString();
        log.debug("FreeMarker template rendered successfully, output length: {} chars", (Object)result.length());
        return result;
    }

    public static boolean isHtmlBasedOutputType(String outputType) {
        return "output.html".equals(outputType) || "output.pdf".equals(outputType) || "output.xlsx".equals(outputType) || "output.any".equals(outputType);
    }
}

