/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.sender.factory;

import com.sourcekraft.documentburster.common.settings.EmailConnection;
import com.sourcekraft.documentburster.common.settings.Settings;
import com.sourcekraft.documentburster.common.settings.model.EmailSettings;
import com.sourcekraft.documentburster.context.BurstingContext;
import com.sourcekraft.documentburster.sender.model.EmailMessage;
import com.sourcekraft.documentburster.utils.Utils;
import com.sourcekraft.documentburster.variables.Variables;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class EmailMessageFactory {
    public EmailMessage createEmailMessage(BurstingContext ctx, boolean useTestServer) throws Exception {
        EmailMessage message = new EmailMessage();
        message.token = ctx.token;
        message.ctx = ctx;
        this.processAttachments(message, ctx);
        EmailSettings messageSettings = ctx.settings.getEmailSettings();
        this.setEmailSubject(message, messageSettings.subject, ctx);
        this.setEmailMessage(message, messageSettings.text, messageSettings.html, ctx);
        this.addEmailAddresses("to", messageSettings.to, message, ctx);
        this.addEmailAddresses("cc", messageSettings.cc, message, ctx);
        this.addEmailAddresses("bcc", messageSettings.bcc, message, ctx);
        this.setEmailServerSettings(message, ctx, useTestServer);
        this.setSimpleJavaMailSettings(message, ctx);
        return message;
    }

    private void setSimpleJavaMailSettings(EmailMessage msg, BurstingContext ctx) throws Exception {
        msg.sjm = ctx.settings.getSimpleJavaMail();
    }

    private void setEmailServerSettings(EmailMessage msg, BurstingContext ctx, boolean useTestServer) throws Exception {
        boolean authentication = false;
        if (useTestServer) {
            String authuser = Utils.getStringFromTemplate((String)ctx.settings.getTestEmailServerUserId(), (Variables)ctx.variables, (String)ctx.token);
            if (StringUtils.isNotEmpty((CharSequence)authuser)) {
                authentication = true;
            }
            String authpwd = "";
            if (StringUtils.isNotEmpty((CharSequence)ctx.settings.getTestEmailServerUserPassword())) {
                authpwd = Utils.getStringFromTemplate((String)ctx.settings.getTestEmailServerUserPassword(), (Variables)ctx.variables, (String)ctx.token);
            }
            if (StringUtils.isNotEmpty((CharSequence)authpwd)) {
                authentication = true;
            }
            msg.isAuthentication = authentication;
            if (authentication) {
                msg.authuser = authuser;
                msg.authpwd = authpwd;
            }
            msg.hostName = Utils.getStringFromTemplate((String)ctx.settings.getTestEmailServerHost(), (Variables)ctx.variables, (String)ctx.token);
            msg.smtpPort = Utils.getStringFromTemplate((String)ctx.settings.getTestEmailServerPort(), (Variables)ctx.variables, (String)ctx.token);
            msg.fromAddress = Utils.getStringFromTemplate((String)ctx.settings.getTestEmailServerFrom(), (Variables)ctx.variables, (String)ctx.token);
            msg.fromName = Utils.getStringFromTemplate((String)ctx.settings.getTestEmailServerName(), (Variables)ctx.variables, (String)ctx.token);
            msg.isTls = ctx.settings.isTestEmailServerUseTLS();
            msg.isSsl = ctx.settings.isTestEmailServerUseSSL();
        } else if (!ctx.settings.getEmailServerUseConn()) {
            String authuser = Utils.getStringFromTemplate((String)ctx.settings.getEmailServerUserId(), (Variables)ctx.variables, (String)ctx.token);
            if (StringUtils.isNotEmpty((CharSequence)authuser)) {
                authentication = true;
            }
            String authpwd = "";
            if (StringUtils.isNotEmpty((CharSequence)ctx.settings.getEmailServerUserPassword())) {
                authpwd = Utils.getStringFromTemplate((String)ctx.settings.getEmailServerUserPassword(), (Variables)ctx.variables, (String)ctx.token);
            }
            if (StringUtils.isNotEmpty((CharSequence)authpwd)) {
                authentication = true;
            }
            msg.isAuthentication = authentication;
            if (authentication) {
                msg.authuser = authuser;
                msg.authpwd = authpwd;
            }
            msg.hostName = Utils.getStringFromTemplate((String)ctx.settings.getEmailServerHost(), (Variables)ctx.variables, (String)ctx.token);
            msg.smtpPort = Utils.getStringFromTemplate((String)ctx.settings.getEmailServerPort(), (Variables)ctx.variables, (String)ctx.token);
            msg.fromAddress = Utils.getStringFromTemplate((String)ctx.settings.getEmailServerFrom(), (Variables)ctx.variables, (String)ctx.token);
            msg.fromName = Utils.getStringFromTemplate((String)ctx.settings.getEmailServerName(), (Variables)ctx.variables, (String)ctx.token);
            msg.isTls = ctx.settings.isEmailServerUseTLS();
            msg.isSsl = ctx.settings.isEmailServerUseSSL();
        } else {
            String authuser;
            String connCode = ctx.settings.getEmailServerConnCode();
            if (Objects.isNull(ctx.emailConnection)) {
                EmailConnection emailConnection = new EmailConnection();
                emailConnection.loadDetailsUsingCode(connCode, ctx.settings.getConfigurationFilePath());
                ctx.emailConnection = emailConnection;
            }
            if (StringUtils.isNotEmpty((CharSequence)(authuser = Utils.getStringFromTemplate((String)ctx.emailConnection.getDetails().connection.emailserver.userid, (Variables)ctx.variables, (String)ctx.token)))) {
                authentication = true;
            }
            String authpwd = "";
            if (StringUtils.isNotEmpty((CharSequence)ctx.emailConnection.getDetails().connection.emailserver.userpassword)) {
                authpwd = Utils.getStringFromTemplate((String)ctx.emailConnection.getDetails().connection.emailserver.userpassword, (Variables)ctx.variables, (String)ctx.token);
            }
            if (StringUtils.isNotEmpty((CharSequence)authpwd)) {
                authentication = true;
            }
            msg.isAuthentication = authentication;
            if (authentication) {
                msg.authuser = authuser;
                msg.authpwd = authpwd;
            }
            msg.hostName = Utils.getStringFromTemplate((String)ctx.emailConnection.getDetails().connection.emailserver.host, (Variables)ctx.variables, (String)ctx.token);
            msg.smtpPort = Utils.getStringFromTemplate((String)ctx.emailConnection.getDetails().connection.emailserver.port, (Variables)ctx.variables, (String)ctx.token);
            msg.fromAddress = Utils.getStringFromTemplate((String)ctx.emailConnection.getDetails().connection.emailserver.fromaddress, (Variables)ctx.variables, (String)ctx.token);
            msg.fromName = Utils.getStringFromTemplate((String)ctx.emailConnection.getDetails().connection.emailserver.name, (Variables)ctx.variables, (String)ctx.token);
            msg.isTls = ctx.emailConnection.getDetails().connection.emailserver.usetls;
            msg.isSsl = ctx.emailConnection.getDetails().connection.emailserver.usessl;
        }
    }

    private void processAttachments(EmailMessage msg, BurstingContext ctx) {
        if (ctx.settings.isArchiveAttachments()) {
            msg.attachments.add(ctx.archiveFilePath);
        } else {
            for (String path : ctx.attachments) {
                msg.attachments.add(path);
            }
        }
    }

    private void setEmailSubject(EmailMessage msg, String subject, BurstingContext ctx) throws Exception {
        msg.subject = Utils.getStringFromTemplate((String)subject, (Variables)ctx.variables, (String)ctx.token);
    }

    private void setEmailMessage(EmailMessage msg, String text, String html, BurstingContext ctx) throws Exception {
        msg.textMessage = Utils.getStringFromTemplate((String)text, (Variables)ctx.variables, (String)ctx.token);
        msg.isHtmlEmail = ctx.settings.isHtmlEmail();
        msg.htmlMessage = Utils.getStringFromTemplate((String)html, (Variables)ctx.variables, (String)ctx.token);
    }

    private void addEmailAddresses(String which, String addressesTemplates, EmailMessage msg, BurstingContext ctx) throws Exception {
        String addresses = Utils.getStringFromTemplate((String)addressesTemplates, (Variables)ctx.variables, (String)ctx.token);
        if (StringUtils.isNotEmpty((CharSequence)addresses)) {
            String[] ads;
            String separator = ";";
            if (addresses.contains(",")) {
                separator = ",";
            }
            for (String address : ads = addresses.split(separator)) {
                if (which.equals("to")) {
                    msg.tos.add(address);
                    continue;
                }
                if (which.equals("cc")) {
                    msg.ccs.add(address);
                    continue;
                }
                if (!which.equals("bcc")) continue;
                msg.bccs.add(address);
            }
        }
    }

    public EmailMessage createCheckEmailMessageFromSettings(Settings settings) throws Exception {
        EmailMessage msg = new EmailMessage();
        if (!settings.getEmailServerUseConn()) {
            String authpwd;
            boolean authentication = false;
            String authuser = settings.getEmailServerUserId();
            if (StringUtils.isNotEmpty((CharSequence)authuser)) {
                authentication = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)(authpwd = settings.getEmailServerUserPassword()))) {
                authentication = true;
            }
            msg.isAuthentication = authentication;
            if (authentication) {
                msg.authuser = authuser;
                msg.authpwd = authpwd;
            }
            msg.hostName = settings.getEmailServerHost();
            msg.smtpPort = settings.getEmailServerPort();
            msg.fromAddress = settings.getEmailServerFrom();
            msg.fromName = settings.getEmailServerName();
            msg.isTls = settings.isEmailServerUseTLS();
            msg.isSsl = settings.isEmailServerUseSSL();
            msg.subject = "Great. You Got It!";
            msg.textMessage = "It worked. You are now ready to start distributing your emails. As a best practice always test that the generated emails are as you intend to be. You can do that using the provided Email Tester (Quality Assurance) tool.";
            msg.tos.add(msg.fromAddress);
        } else {
            String connCode = settings.getEmailServerConnCode();
            EmailConnection emailConnection = new EmailConnection();
            emailConnection.loadDetailsUsingCode(connCode, settings.getConfigurationFilePath());
            msg = new EmailMessageFactory().createCheckEmailMessageFromConnection(emailConnection);
        }
        msg.sjm = settings.getSimpleJavaMail();
        return msg;
    }

    public EmailMessage createCheckEmailMessageFromConnection(EmailConnection emailConnection) {
        String authpwd;
        EmailMessage msg = new EmailMessage();
        boolean authentication = false;
        String authuser = emailConnection.getDetails().connection.emailserver.userid;
        if (StringUtils.isNotEmpty((CharSequence)authuser)) {
            authentication = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)(authpwd = emailConnection.getDetails().connection.emailserver.userpassword))) {
            authentication = true;
        }
        msg.isAuthentication = authentication;
        if (authentication) {
            msg.authuser = authuser;
            msg.authpwd = authpwd;
        }
        msg.hostName = emailConnection.getDetails().connection.emailserver.host;
        msg.smtpPort = emailConnection.getDetails().connection.emailserver.port;
        msg.fromAddress = emailConnection.getDetails().connection.emailserver.fromaddress;
        msg.fromName = emailConnection.getDetails().connection.emailserver.name;
        msg.isTls = emailConnection.getDetails().connection.emailserver.usetls;
        msg.isSsl = emailConnection.getDetails().connection.emailserver.usessl;
        msg.subject = "Great. You Got It!";
        msg.textMessage = "It worked. You are now ready to start distributing your emails. As a best practice always test that the generated emails are as you intend to be. You can do that using the provided Email Tester (Quality Assurance) tool.";
        msg.tos.add(msg.fromAddress);
        return msg;
    }
}

