/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.sender;

import com.sourcekraft.documentburster.common.settings.model.UploadSettings;
import com.sourcekraft.documentburster.context.BurstingContext;
import com.sourcekraft.documentburster.sender.AbstractSender;
import com.sourcekraft.documentburster.sender.model.UploadMessage;
import com.sourcekraft.documentburster.utils.Utils;
import com.sourcekraft.documentburster.variables.Variables;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class UploadSender
extends AbstractSender {
    UploadType type;

    public UploadSender(boolean execute, BurstingContext ctx) {
        super(execute, ctx);
    }

    public void setType(UploadType type) {
        this.type = type;
    }

    @Override
    protected void doSend() throws Exception {
        UploadMessage uploadMessage = new UploadMessage();
        uploadMessage.token = this.ctx.token;
        uploadMessage.ctx = this.ctx;
        UploadSettings uploadSettings = this.ctx.settings.getUploadSettings();
        String typeStr = "ftp";
        switch (this.type) {
            case FTP: {
                uploadMessage.uploadCommand = Utils.getStringFromTemplate((String)uploadSettings.ftpcommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "ftp";
                break;
            }
            case FILESHARE: {
                uploadMessage.uploadCommand = Utils.getStringFromTemplate((String)uploadSettings.filesharecommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "fileshare";
                break;
            }
            case FTPS: {
                uploadMessage.uploadCommand = Utils.getStringFromTemplate((String)uploadSettings.ftpscommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "ftps";
                break;
            }
            case SFTP: {
                uploadMessage.uploadCommand = Utils.getStringFromTemplate((String)uploadSettings.sftpcommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "sftp";
                break;
            }
            case HTTP: {
                uploadMessage.uploadCommand = Utils.getStringFromTemplate((String)uploadSettings.httpcommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "http";
                break;
            }
            case CLOUD: {
                uploadMessage.uploadCommand = Utils.getStringFromTemplate((String)uploadSettings.cloudcommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "cloud";
                break;
            }
            default: {
                uploadMessage.uploadCommand = Utils.getStringFromTemplate((String)uploadSettings.ftpcommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "ftp";
            }
        }
        this.log.info("Uploading " + this.ctx.attachments + " using command " + uploadMessage.uploadCommand);
        if (this.ctx.isQARunningMode) {
            FileUtils.writeStringToFile((File)new File(this.ctx.outputFolder + "/quality-assurance/" + this.ctx.token + "_" + typeStr + "_upload.txt"), (String)uploadMessage.toString(), (String)"UTF-8");
        }
        if (this.execute) {
            this.scripting.executeSenderScript(this.ctx.scripts.upload, uploadMessage);
        }
        this.log.info("Attachments " + this.ctx.attachments + " uploaded successfully.");
    }

    public static enum UploadType {
        FTP,
        FILESHARE,
        FTPS,
        SFTP,
        HTTP,
        CLOUD;

    }
}

