/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.sender;

import com.sourcekraft.documentburster.common.settings.model.SmsSettings;
import com.sourcekraft.documentburster.context.BurstingContext;
import com.sourcekraft.documentburster.sender.AbstractSender;
import com.sourcekraft.documentburster.sender.model.SmsMessage;
import com.sourcekraft.documentburster.utils.Utils;
import com.sourcekraft.documentburster.variables.Variables;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class SmsSender
extends AbstractSender {
    SmsType type;

    public SmsSender(boolean execute, BurstingContext ctx) {
        super(execute, ctx);
    }

    public void setType(SmsType type) {
        this.type = type;
    }

    @Override
    protected void doSend() throws Exception {
        SmsSettings smsSettings = this.ctx.settings.getSmsSettings();
        SmsMessage message = new SmsMessage();
        message.token = this.ctx.token;
        message.fromTelephoneNumber = Utils.getStringFromTemplate((String)smsSettings.fromtelephonenumber, (Variables)this.ctx.variables, (String)this.ctx.token);
        message.toTelephoneNumber = Utils.getStringFromTemplate((String)smsSettings.totelephonenumber, (Variables)this.ctx.variables, (String)this.ctx.token);
        message.text = Utils.getStringFromTemplate((String)smsSettings.text, (Variables)this.ctx.variables, (String)this.ctx.token);
        String typeStr = "sms_twilio";
        switch (this.type) {
            case TWILIO: {
                message.twilio.accountsid = Utils.getStringFromTemplate((String)smsSettings.twilio.accountsid, (Variables)this.ctx.variables, (String)this.ctx.token);
                message.twilio.authtoken = Utils.getStringFromTemplate((String)smsSettings.twilio.authtoken, (Variables)this.ctx.variables, (String)this.ctx.token);
                this.ctx.scripts.sms = "twilio.groovy";
                typeStr = "twilio";
                break;
            }
            default: {
                typeStr = "default";
            }
        }
        this.log.info("Sending SMS message '" + (Object)((Object)message) + " through " + typeStr);
        if (this.ctx.isQARunningMode) {
            FileUtils.writeStringToFile((File)new File(this.ctx.outputFolder + "/quality-assurance/" + this.ctx.token + "_sms_" + typeStr + ".txt"), (String)message.toString(), (String)"UTF-8");
        }
        if (this.execute) {
            this.scripting.executeSenderScript(this.ctx.scripts.sms, message);
        }
        this.log.info("SMS message '" + (Object)((Object)message) + "' sent successfully.");
    }

    public static enum SmsType {
        SMS,
        TWILIO;

    }
}

