/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.sender;

import com.sourcekraft.documentburster.context.BurstingContext;
import com.sourcekraft.documentburster.scripting.Scripting;
import com.sourcekraft.documentburster.utils.Utils;
import java.time.temporal.ChronoUnit;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.function.ContextualRunnable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSender {
    protected Logger log = LoggerFactory.getLogger(AbstractSender.class);
    protected boolean execute = true;
    private boolean quarantined = false;
    private boolean sent = false;
    private int numberOfAttachments = 0;
    protected Scripting scripting;
    protected BurstingContext ctx;

    public AbstractSender(boolean execute, BurstingContext ctx) {
        this.execute = execute;
        this.ctx = ctx;
    }

    public void setScripting(Scripting scripting) {
        this.scripting = scripting;
    }

    protected void quarantine() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.ctx.extractedFilePath)) {
            Utils.copyFileToQuarantine((String)this.ctx.quarantineFolder, (String)this.ctx.extractedFilePath);
            ++this.ctx.numberOfQuarantinedFiles;
            this.quarantined = true;
            this.scripting.executeBurstingLifeCycleScript(this.ctx.scripts.quarantineDocument, this.ctx);
        }
    }

    public void send() throws Exception {
        this.log.debug("send()");
        this._processAttachments();
        try {
            this.scripting.executeBurstingLifeCycleScript(this.ctx.scripts.startDistributeDocument, this.ctx);
            if (this.ctx.settings.isEnableRetryPolicy()) {
                this._doSendAndRetryIfAnyError();
            } else {
                this.doSend();
            }
            this.scripting.executeBurstingLifeCycleScript(this.ctx.scripts.endDistributeDocument, this.ctx);
            ++this.ctx.numberOfMessagesSent;
            this.ctx.numberOfDistributedFiles += this.numberOfAttachments;
        }
        catch (Exception e) {
            if (this.ctx.settings.isQuarantineFiles() && StringUtils.isNotBlank((CharSequence)this.ctx.extractedFilePath)) {
                this.quarantine();
            }
            this.ctx.setLastException(e);
            this.scripting.executeBurstingLifeCycleScript(this.ctx.scripts.distributeReportErrorHandling, this.ctx);
        }
    }

    public boolean isQuarantined() {
        return this.quarantined;
    }

    public boolean isSent() {
        return this.sent;
    }

    private void _processAttachments() {
        if (this.ctx.attachments.size() > 0) {
            this.numberOfAttachments = this.ctx.settings.isArchiveAttachments() ? 1 : this.ctx.attachments.size();
        }
    }

    private void _doSendAndRetryIfAnyError() throws Exception {
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handle(Exception.class)).withBackoff((long)this.ctx.settings.getRetryPolicy().delay, (long)this.ctx.settings.getRetryPolicy().maxdelay, ChronoUnit.SECONDS).withMaxRetries(this.ctx.settings.getRetryPolicy().maxretries);
        Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).run(new ContextualRunnable(){

            public void run(ExecutionContext executionContext) throws Exception {
                AbstractSender.this.log.info("SendAndRetryIfAnyError - Send attempt #" + executionContext.getAttemptCount());
                AbstractSender.this.doSend();
            }
        });
    }

    protected abstract void doSend() throws Exception;
}

