/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.job;

import com.sourcekraft.documentburster.GlobalContext;
import com.sourcekraft.documentburster.common.ServicesManager;
import com.sourcekraft.documentburster.common.db.DatabaseConnectionTester;
import com.sourcekraft.documentburster.common.db.DatabaseSchemaFetcher;
import com.sourcekraft.documentburster.common.db.ReportDataResult;
import com.sourcekraft.documentburster.common.db.schema.SchemaInfo;
import com.sourcekraft.documentburster.common.settings.EmailConnection;
import com.sourcekraft.documentburster.common.settings.NewFeatureRequest;
import com.sourcekraft.documentburster.common.settings.Settings;
import com.sourcekraft.documentburster.engine.AbstractBurster;
import com.sourcekraft.documentburster.engine.AbstractReporter;
import com.sourcekraft.documentburster.engine.BursterFactory;
import com.sourcekraft.documentburster.engine.pdf.Merger;
import com.sourcekraft.documentburster.job.JobUtils;
import com.sourcekraft.documentburster.job.model.JobDetails;
import com.sourcekraft.documentburster.job.model.JobProgressDetails;
import com.sourcekraft.documentburster.scripting.Scripting;
import com.sourcekraft.documentburster.sender.factory.EmailMessageFactory;
import com.sourcekraft.documentburster.sender.factory.SmsMessageFactory;
import com.sourcekraft.documentburster.sender.model.EmailMessage;
import com.sourcekraft.documentburster.sender.model.SmsMessage;
import com.sourcekraft.documentburster.utils.LicenseUtils;
import com.sourcekraft.documentburster.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliJob {
    private static Logger log = LoggerFactory.getLogger(CliJob.class);
    private Map<String, String> parameters = new HashMap<String, String>();
    private LicenseUtils licenseUtils = new LicenseUtils();
    public String configurationFilePath;
    private Settings settings;
    private String jobProgressFilePath;
    private String jobFilePath;
    private String jobType = "burst";
    public static String STATUS_COMPLETED = "COMPLETED";
    public static String STATUS_FAILED = "FAILED";
    public static String RUN_MODE_QA = "QA";
    public static String RUN_MODE_LIVE = "LIVE";
    private GlobalContext global;

    public void setGlobal(GlobalContext global) {
        this.global = global;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public CliJob(String configFilePath) {
        log.debug("public CliJob(String configFilePath) constructor configurationFilePath = " + configFilePath);
        this.configurationFilePath = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{configFilePath}) && Files.exists(Paths.get(configFilePath, new String[0]), new LinkOption[0]) ? configFilePath : "./config/burst/settings.xml";
        this.settings = new Settings(this.configurationFilePath);
    }

    public Settings getSettings() throws Exception {
        return this.settings;
    }

    public void setJobProgressFilePath(String jobProgressFilePath) {
        this.jobProgressFilePath = jobProgressFilePath;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public void doCheckEmail() throws Exception {
        EmailMessage message;
        log.debug("doCheckEmail()");
        if (this.configurationFilePath.contains("connections") && this.configurationFilePath.contains("eml-")) {
            EmailConnection emailConnection = new EmailConnection();
            emailConnection.loadDetails(this.configurationFilePath);
            message = new EmailMessageFactory().createCheckEmailMessageFromConnection(emailConnection);
        } else {
            this.settings.setConfigurationFilePath(this.configurationFilePath);
            this.settings.loadSettings();
            message = new EmailMessageFactory().createCheckEmailMessageFromSettings(this.settings);
        }
        File jobFile = null;
        try {
            jobFile = this._createJobFile("email.groovy", "check-email");
            new Scripting().executeSenderScript("email.groovy", message);
        }
        finally {
            if (jobFile != null && jobFile.exists()) {
                jobFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSendFeatureRequestEmail(String newFeatureRequestFilePath) throws Exception {
        log.debug("doSendFeatureRequestEmail()");
        if (StringUtils.isNotBlank((CharSequence)newFeatureRequestFilePath)) {
            File rnfXmlFile = new File(newFeatureRequestFilePath);
            if (rnfXmlFile != null && rnfXmlFile.exists()) {
                EmailConnection defaultEmailConnection = new EmailConnection();
                defaultEmailConnection.loadDetailsDefault("");
                EmailMessage message = new EmailMessageFactory().createCheckEmailMessageFromConnection(defaultEmailConnection);
                NewFeatureRequest featureRequest = new NewFeatureRequest();
                featureRequest.loadDetails(newFeatureRequestFilePath);
                message.subject = featureRequest.getDetails().featurerequest.subject;
                message.textMessage = featureRequest.getDetails().featurerequest.message;
                message.tos.clear();
                message.tos.add("support@pdfburst.com");
                File jobFile = null;
                try {
                    jobFile = this._createJobFile("email.groovy", "send-feature-request-email");
                    new Scripting().executeSenderScript("email.groovy", message);
                }
                finally {
                    rnfXmlFile.delete();
                    if (jobFile != null && jobFile.exists()) {
                        jobFile.delete();
                    }
                }
            } else {
                throw new Exception("'Request New Feature' XML file does not exist: " + newFeatureRequestFilePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResume(String jobProgressFilePath) throws Exception {
        log.debug("doResumeBurst(String jobProgressFilePath) : jobProgressFilePath = " + jobProgressFilePath);
        File jobFile = null;
        File jobProgressFile = new File(jobProgressFilePath);
        try {
            JobProgressDetails jobProgressDetails = JobUtils.loadJobProgressFile(jobProgressFilePath);
            jobProgressFile.delete();
            jobFile = this._createJobFile(jobProgressDetails.filepath, jobProgressDetails.jobtype);
            this.configurationFilePath = jobProgressDetails.configurationFilePath;
            this.jobType = jobProgressDetails.jobtype;
            AbstractBurster burster = this.getBurster(jobProgressDetails.filepath);
            burster.setPreviousJobExecutionProgressDetails(jobProgressDetails);
            burster.setJobFilePath(this.jobFilePath);
            burster.burst(jobProgressDetails.filepath, jobProgressDetails.testall, jobProgressDetails.listoftesttokens, jobProgressDetails.numberofrandomtesttokens);
        }
        finally {
            if (jobFile != null && jobFile.exists()) {
                jobFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBurst(String filePath, boolean testAll, String listOfTestTokens, int numberOfRandomTestTokens) throws Exception {
        log.debug("doBurst(String filePath ) : filePath=" + filePath);
        File jobFile = null;
        try {
            jobFile = this._createJobFile(filePath, this.jobType);
            AbstractBurster burster = this.getBurster(filePath);
            burster.setJobFilePath(this.jobFilePath);
            if (this.jobProgressFilePath != null) {
                burster.setJobFilePath(this.jobProgressFilePath);
            }
            if (burster instanceof AbstractReporter && this.parameters != null && !this.parameters.isEmpty()) {
                ((AbstractReporter)burster).setReportParameters(this.parameters);
            }
            burster.burst(filePath, testAll, listOfTestTokens, numberOfRandomTestTokens);
        }
        finally {
            if (jobFile != null && jobFile.exists()) {
                jobFile.delete();
            }
        }
    }

    private String getJobFilePath() {
        return this.getTempFolder() + Utils.getRandomJobFileName();
    }

    public String getTempFolder() {
        return Utils.getTempFolder();
    }

    private File _createJobFile(String targetFilePath, String jobType) throws Exception {
        this.jobFilePath = this.getJobFilePath();
        JobDetails jobDetails = new JobDetails();
        jobDetails.filepath = targetFilePath;
        jobDetails.jobtype = jobType;
        JobUtils.saveJobDetails(jobDetails, this.jobFilePath);
        return new File(this.jobFilePath);
    }

    protected AbstractBurster getBurster(String filePath) throws Exception {
        AbstractBurster burster = BursterFactory.create(filePath, this.configurationFilePath, this.jobType);
        burster.setGlobal(this.global);
        return burster;
    }

    protected Merger getMerger() throws Exception {
        this.settings.setConfigurationFilePath(this.configurationFilePath);
        this.settings.loadSettings();
        return new Merger(this.settings);
    }

    public String getJobPath() {
        return this.jobFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doMerge(List<String> filePaths, String outputFileName) throws Exception {
        String mergedFilePath = null;
        File jobFile = null;
        try {
            jobFile = this._createJobFile(outputFileName, "merge");
            Merger merger = this.getMerger();
            mergedFilePath = merger.doMerge(filePaths, outputFileName);
        }
        finally {
            if (jobFile != null && jobFile.exists()) {
                jobFile.delete();
            }
        }
        return mergedFilePath;
    }

    public void doActivateLicenseKey() throws Exception {
        log.debug("doActivateLicenseKey()");
        File jobFile = null;
        try {
            jobFile = this._createJobFile(this.licenseUtils.getLicenseFilePath(), "activate-licenseUtils-key");
            this.licenseUtils.activateLicense();
        }
        finally {
            if (jobFile != null && jobFile.exists()) {
                jobFile.delete();
            }
        }
    }

    public void doDeactivateLicense() throws Exception {
        log.debug("doDeActivateLicenseKey()");
        File jobFile = null;
        try {
            jobFile = this._createJobFile(this.licenseUtils.getLicenseFilePath(), "deactivate-licenseUtils-key");
            this.licenseUtils.deActivateLicense();
        }
        finally {
            if (jobFile != null && jobFile.exists()) {
                jobFile.delete();
            }
        }
    }

    public void doCheckLicense() throws Exception {
        log.debug("doCheckLicense()");
        File jobFile = null;
        try {
            jobFile = this._createJobFile(this.licenseUtils.getLicenseFilePath(), "check-licenseUtils-key");
            this.licenseUtils.checkLicense();
        }
        finally {
            if (jobFile != null && jobFile.exists()) {
                jobFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckTwilio(String from, String to) throws Exception {
        log.debug("doCheckTwilio(String from, String to) : from = " + from + ", to = " + to);
        this.settings.setConfigurationFilePath(this.configurationFilePath);
        this.settings.loadSettings();
        SmsMessage message = new SmsMessageFactory().createCheckSmsMessage(from, to);
        message.twilio = this.settings.getSmsSettings().twilio;
        File jobFile = null;
        try {
            jobFile = this._createJobFile("twilio.groovy", "check-twilio");
            new Scripting().executeSenderScript("twilio.groovy", message);
        }
        finally {
            if (jobFile != null && jobFile.exists()) {
                jobFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportDataResult doFetchData(Map<String, String> parameters) throws Exception {
        File jobFile = null;
        ReportDataResult result = new ReportDataResult();
        try {
            jobFile = this._createJobFile(this.configurationFilePath, "fetch-data");
            this.settings.setConfigurationFilePath(this.configurationFilePath);
            this.settings.loadSettings();
            String dsType = this.settings.getReportDataSource().type;
            this.setJobType(dsType);
            AbstractBurster burster = this.getBurster(this.configurationFilePath);
            if (!(burster instanceof AbstractReporter)) {
                throw new IllegalStateException("Fetch data only supported for AbstractReporter-based bursters");
            }
            ((AbstractReporter)burster).setPreviewMode(true);
            ((AbstractReporter)burster).setReportParameters(parameters);
            long startTime = System.currentTimeMillis();
            burster.burst(this.settings.getTemplateName(), false, "", -1);
            long endTime = System.currentTimeMillis();
            result.reportData = burster.getCtx().reportData;
            result.reportColumnNames = burster.getCtx().reportColumnNames;
            result.isPreview = true;
            result.executionTimeMillis = endTime - startTime;
            result.totalRows = result.reportData != null ? result.reportData.size() : 0;
            ReportDataResult reportDataResult = result;
            return reportDataResult;
        }
        catch (Throwable t) {
            String msg;
            String string = msg = t.getMessage() == null || t.getMessage().isEmpty() ? t.toString() : t.getMessage();
            if (!msg.toLowerCase().contains("no burst tokens were provided or fetched for the document")) {
                log.error("Exception: ", t);
            } else {
                log.info(msg);
            }
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
            row.put("ERROR_MESSAGE", msg);
            result.reportData = Arrays.asList(row);
            result.reportColumnNames = Arrays.asList("ERROR_MESSAGE");
            result.isPreview = true;
            result.executionTimeMillis = 0L;
            result.totalRows = 0;
            if (this.global != null) {
                throw t;
            }
            ReportDataResult reportDataResult = result;
            return reportDataResult;
        }
        finally {
            if (jobFile != null && jobFile.exists()) {
                jobFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestAndFetchDatabaseSchema(String connectionFilePath) throws Exception {
        log.info("Starting database connection test and schema fetch for: {}", (Object)connectionFilePath);
        File connectionFile = new File(connectionFilePath);
        if (!connectionFile.exists() || !connectionFile.isFile()) {
            throw new FileNotFoundException("Connection file not found or is not a file: " + connectionFilePath);
        }
        String jobName = connectionFile.getName();
        File jobFile = null;
        try {
            jobFile = this._createJobFile(connectionFilePath, "test-and-fetch-database-schema-" + jobName);
            log.debug("Created job file: {}", (Object)this.jobFilePath);
            DatabaseConnectionTester tester = new DatabaseConnectionTester();
            log.info("Attempting to test database connection...");
            tester.testConnection(connectionFilePath);
            log.info("Database connection test successful.");
            DatabaseSchemaFetcher fetcher = new DatabaseSchemaFetcher();
            log.info("Attempting to fetch database schema...");
            SchemaInfo schemaInfo = fetcher.fetchSchema(connectionFilePath);
            log.info("Successfully fetched database schema.");
            Path inputPath = connectionFile.toPath();
            Path parentDir = inputPath.getParent();
            if (parentDir == null) {
                throw new Exception("Cannot determine parent directory for connection file.");
            }
            String baseName = connectionFile.getName();
            if (baseName.toLowerCase().endsWith(".xml")) {
                baseName = baseName.substring(0, baseName.length() - 4);
            }
            String outputFileName = baseName + "-information-schema.json";
            String outputJsonPath = parentDir.resolve(outputFileName).toString();
            log.debug("Determined output schema JSON path: {}", (Object)outputJsonPath);
            log.info("Attempting to save schema to JSON file: {}", (Object)outputJsonPath);
            fetcher.saveSchemaToJson(schemaInfo, outputJsonPath);
            log.info("Successfully saved schema to: {}", (Object)outputJsonPath);
            log.info("Database connection test and schema fetch completed successfully for: {}", (Object)connectionFilePath);
        }
        finally {
            if (jobFile != null && jobFile.exists()) {
                log.debug("Deleting job file: {}", (Object)jobFile.getAbsolutePath());
                jobFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doService(String serviceName, String commandLine) throws Exception {
        File jobFile = null;
        try {
            jobFile = this._createJobFile(serviceName, commandLine);
            ServicesManager.execute((String)commandLine);
        }
        finally {
            if (jobFile != null && jobFile.exists()) {
                jobFile.delete();
            }
        }
    }
}

