/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine.reporting;

import com.sourcekraft.documentburster.engine.AbstractReporter;
import com.univocity.parsers.fixed.FixedWidthFields;
import com.univocity.parsers.fixed.FixedWidthParser;
import com.univocity.parsers.fixed.FixedWidthParserSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class FixedWidthReporter
extends AbstractReporter {
    public FixedWidthReporter(String configFilePath) {
        super(configFilePath);
    }

    @Override
    protected void fetchData() throws Exception {
        String[] columnDefs = this.ctx.settings.getReportDataSource().fixedwidthoptions.columns.split("\n");
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        ArrayList<String> reportColumnNames = new ArrayList<String>();
        for (String def : columnDefs) {
            String[] parts;
            if (def.trim().isEmpty() || (parts = def.split(",")).length < 2) continue;
            reportColumnNames.add(parts[0].trim());
            String lengthStr = parts[1].trim();
            lengths.add(Integer.parseInt(lengthStr));
        }
        FixedWidthFields fields = new FixedWidthFields(lengths.stream().mapToInt(i -> i).toArray());
        FixedWidthParserSettings settings = new FixedWidthParserSettings(fields);
        settings.setSkipEmptyLines(true);
        settings.setIgnoreLeadingWhitespaces(this.ctx.settings.getReportDataSource().fixedwidthoptions.ignoreleadingwhitespace);
        settings.setIgnoreTrailingWhitespaces(true);
        if (this.ctx.settings.getReportDataSource().fixedwidthoptions.skiplines > 0) {
            settings.setNumberOfRowsToSkip((long)this.ctx.settings.getReportDataSource().fixedwidthoptions.skiplines);
        }
        FixedWidthParser parser = new FixedWidthParser(settings);
        List rawData = parser.parseAll(new File(this.filePath));
        this.ctx.reportData = new ArrayList();
        for (String[] row : rawData) {
            LinkedHashMap<String, Object> rowMap = new LinkedHashMap<String, Object>();
            for (int i2 = 0; i2 < Math.min(row.length, reportColumnNames.size()); ++i2) {
                rowMap.put((String)reportColumnNames.get(i2), this.toObject(row[i2]));
            }
            if (rowMap.isEmpty() || !rowMap.values().stream().anyMatch(v -> v != null && !v.toString().trim().isEmpty())) continue;
            this.ctx.reportData.add(rowMap);
        }
    }
}

