/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine.reporting;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.sourcekraft.documentburster.engine.AbstractReporter;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReporter
extends AbstractReporter {
    private static final Logger log = LoggerFactory.getLogger(CsvReporter.class);

    public CsvReporter(String configFilePath) {
        super(configFilePath);
    }

    @Override
    protected void fetchData() throws Exception {
        BufferedReader bufferedReader;
        log.trace("Entering fetchData...");
        char separatorChar = ',';
        String sSeparator = this.ctx.settings.getReportDataSource().csvoptions.separatorchar;
        if (StringUtils.isNotEmpty((CharSequence)sSeparator) && !sSeparator.equals("autodetect")) {
            separatorChar = sSeparator.contains("[tab character]") || sSeparator.equals("\\t") ? (char)'\t' : (char)sSeparator.charAt(0);
        }
        log.debug("Using separator character: '{}'", (Object)Character.valueOf(separatorChar));
        char quotationChar = '\"';
        String sQuotation = this.ctx.settings.getReportDataSource().csvoptions.quotationchar;
        if (!StringUtils.isEmpty((CharSequence)sQuotation)) {
            quotationChar = sQuotation.charAt(0);
        }
        log.debug("Using quotation character: '{}'", (Object)Character.valueOf(quotationChar));
        char escapeChar = '\\';
        String sEscape = this.ctx.settings.getReportDataSource().csvoptions.escapechar;
        if (!StringUtils.isEmpty((CharSequence)sEscape)) {
            escapeChar = sEscape.charAt(0);
        }
        log.debug("Using escape character: '{}'", (Object)Character.valueOf(escapeChar));
        boolean ignoreLeadingWhitespace = this.ctx.settings.getReportDataSource().csvoptions.ignoreleadingwhitespace;
        boolean strictQuotes = this.ctx.settings.getReportDataSource().csvoptions.strictquotations;
        boolean ignoreQuotations = this.ctx.settings.getReportDataSource().csvoptions.ignorequotations;
        int skipLines = this.ctx.settings.getReportDataSource().csvoptions.skiplines;
        String headerSetting = this.ctx.settings.getReportDataSource().csvoptions.header;
        if (skipLines < 0) {
            log.warn("Invalid negative skipLines ({}) provided. Defaulting to 0.", (Object)skipLines);
            skipLines = 0;
        }
        boolean hasHeader = !"noheader".equalsIgnoreCase(headerSetting);
        log.debug("CSV Options: headerSetting={}, skipLines={}, hasHeader={}, ignoreLeadingWhitespace={}, strictQuotes={}, ignoreQuotations={}", new Object[]{headerSetting, skipLines, hasHeader, ignoreLeadingWhitespace, strictQuotes, ignoreQuotations});
        CSVParser parser = new CSVParserBuilder().withSeparator(separatorChar).withQuoteChar(quotationChar).withEscapeChar(escapeChar).withStrictQuotes(strictQuotes).withIgnoreQuotations(ignoreQuotations).withIgnoreLeadingWhiteSpace(ignoreLeadingWhitespace).build();
        this.ctx.reportData = new ArrayList();
        this.ctx.reportColumnNames = new ArrayList();
        Object[] headers = null;
        if (hasHeader) {
            log.debug("Attempting to read header from the first line of the file.");
            try {
                bufferedReader = Files.newBufferedReader(Paths.get(this.filePath, new String[0]), StandardCharsets.UTF_8);
                try (CSVReader headerReader = new CSVReaderBuilder((Reader)bufferedReader).withCSVParser((ICSVParser)parser).withSkipLines(0).build();){
                    headers = headerReader.readNext();
                    if (headers == null) {
                        log.warn("Could not read header from the first line. File might be empty. Will attempt to generate generic headers from data.");
                    } else {
                        log.debug("Successfully read header from first line ({} columns): {}", (Object)headers.length, (Object)Arrays.toString(headers));
                        if (headers.length == 1 && ((String)headers[0]).contains(String.valueOf(separatorChar))) {
                            log.warn("Header row ('{}') only has one column and contains the separator '{}'. Check if separator is correct.", headers[0], (Object)Character.valueOf(separatorChar));
                        }
                        if (skipLines < 1) {
                            log.warn("Header setting implies at least one line (the header) should be skipped, but skipLines is {}. Adjusting skipLines to 1.", (Object)skipLines);
                            skipLines = 1;
                        }
                    }
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
            }
            catch (Exception e) {
                log.error("Error reading header from the first line of file '{}'. Will attempt to generate generic headers from data.", (Object)this.filePath, (Object)e);
                headers = null;
            }
        } else {
            log.debug("Header setting is 'noheader'. No header row will be read.");
        }
        log.debug("Configuring main CSVReader to skip {} lines before reading data.", (Object)skipLines);
        bufferedReader = Files.newBufferedReader(Paths.get(this.filePath, new String[0]), StandardCharsets.UTF_8);
        try (CSVReader dataReader = new CSVReaderBuilder((Reader)bufferedReader).withCSVParser((ICSVParser)parser).withSkipLines(skipLines).build();){
            String[] row;
            int dataRowIndex = 0;
            while ((row = dataReader.readNext()) != null) {
                int i;
                log.trace("Reading data row index: {} (physical line approx {})", (Object)dataRowIndex, (Object)(skipLines + dataRowIndex + 1));
                if (ignoreLeadingWhitespace) {
                    for (i = 0; i < row.length; ++i) {
                        if (row[i] == null) continue;
                        row[i] = row[i].trim();
                    }
                    log.trace("Applied trim() to row fields due to ignoreleadingwhitespace=true");
                }
                if (headers == null && dataRowIndex == 0) {
                    headers = new String[row.length];
                    for (i = 0; i < row.length; ++i) {
                        headers[i] = "col" + i;
                    }
                    log.debug("Generated generic headers based on first data row read: {}", (Object)Arrays.toString(headers));
                } else if (headers == null) {
                    log.error("Headers are null but reading subsequent data row {}. Stopping data read.", (Object)dataRowIndex);
                    break;
                }
                if (dataRowIndex == 0 && headers.length == 1 && row.length == 1 && row[0].contains(String.valueOf(separatorChar))) {
                    log.warn("First data row ('{}') also suggests the configured separator '{}' might be incorrect.", (Object)row[0], (Object)Character.valueOf(separatorChar));
                }
                LinkedHashMap<Object, Object> rowMap = new LinkedHashMap<Object, Object>();
                for (int j = 0; j < headers.length; ++j) {
                    Object headerName = headers[j];
                    String value = j < row.length ? row[j] : "";
                    Object uniqueHeaderName = headerName;
                    int duplicateCount = 2;
                    while (rowMap.containsKey(uniqueHeaderName)) {
                        uniqueHeaderName = (String)headerName + "_" + duplicateCount++;
                    }
                    if (!((String)uniqueHeaderName).equals(headerName)) {
                        log.trace("Duplicate header '{}' found, using '{}' instead for this row.", headerName, uniqueHeaderName);
                    }
                    rowMap.put(uniqueHeaderName, this.toObject(value));
                }
                this.ctx.reportData.add(rowMap);
                log.trace("Added data row map: {}", rowMap);
                ++dataRowIndex;
            }
            log.info("Finished reading CSV data. Total data rows processed: {}", (Object)dataRowIndex);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        if (headers != null) {
            ArrayList<Object> finalHeaders = new ArrayList<Object>();
            LinkedHashMap<Object, Integer> headerCounts = new LinkedHashMap<Object, Integer>();
            for (Object header : headers) {
                int count = headerCounts.getOrDefault(header, 0) + 1;
                headerCounts.put(header, count);
                Object uniqueHeader = count > 1 ? (String)header + "_" + count : header;
                finalHeaders.add(uniqueHeader);
            }
            this.ctx.reportColumnNames.addAll(finalHeaders);
            log.debug("Stored final column names (duplicates adjusted): {}", (Object)this.ctx.reportColumnNames);
        } else if (!this.ctx.reportData.isEmpty()) {
            log.warn("No headers were read or generated, but data rows exist. Column names context will be empty.");
        } else {
            log.debug("No headers found and no data rows processed.");
        }
        log.info("CSV data fetched successfully. Headers: {}. Data rows: {}", (Object)this.ctx.reportColumnNames.size(), (Object)this.ctx.reportData.size());
        log.trace("Exiting fetchData.");
    }
}

