/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine.pdf.extractor;

import com.sourcekraft.documentburster.common.settings.Settings;
import com.sourcekraft.documentburster.utils.Utils;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfExtractor {
    private Logger log = LoggerFactory.getLogger(PdfExtractor.class);
    private PDDocument originalPdfDocument;
    private PDDocument outputDocument = null;
    private String outputFileName;
    private String token;
    private Settings settings;

    public PdfExtractor(PDDocument pdfDocument, Settings settings, String outputFileName, String token) {
        this.log.debug("settings = " + settings + ", outputFileName = " + outputFileName + ", token = " + token);
        this.originalPdfDocument = pdfDocument;
        this.settings = settings;
        this.outputFileName = outputFileName;
        this.token = token;
    }

    public void doExtract(List<PDPage> pages) throws Exception {
        this.log.debug("token = " + this.token);
        this.createNewDocument();
        for (PDPage page : pages) {
            this.extractPage(page);
        }
        this.outputDocument.save(this.outputFileName);
        this.outputDocument.getDocument().close();
        this.outputDocument.close();
    }

    private void createNewDocument() throws Exception {
        this.log.debug("token = " + this.token);
        PDDocumentInformation docInformation = this.originalPdfDocument.getDocumentInformation();
        String productName = Utils.getProductName((String)this.settings.getVersion());
        docInformation.setCreator(productName);
        docInformation.setProducer(productName);
        docInformation.setKeywords(this.token);
        this.outputDocument = new PDDocument();
        this.outputDocument.setDocumentInformation(docInformation);
        this.outputDocument.getDocumentCatalog().setViewerPreferences(this.originalPdfDocument.getDocumentCatalog().getViewerPreferences());
    }

    private void extractPage(PDPage page) throws Exception {
        this.log.debug("token = " + this.token);
        PDPage imported = this.outputDocument.importPage(page);
        imported.setCropBox(page.getCropBox());
        imported.setMediaBox(page.getMediaBox());
        imported.setResources(page.getResources());
        imported.setRotation(page.getRotation());
    }
}

