/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine.pdf;

import com.sourcekraft.documentburster.engine.AbstractBurster;
import com.sourcekraft.documentburster.engine.pdf.Pdf2ndTimeSplitter;
import com.sourcekraft.documentburster.engine.pdf.extractor.PdfExtractor;
import com.sourcekraft.documentburster.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfBurster
extends AbstractBurster {
    private Logger log = LoggerFactory.getLogger(PdfBurster.class);
    private static final String CFG_START_SHORT = "<c>";
    private static final String CFG_END_SHORT = "</c>";
    private static final String CFG_START_LONG = "<config>";
    private static final String CFG_END_LONG = "</config>";
    private PDDocument document;
    protected Map<String, List<PDPage>> burstDocuments;
    private PDPage currentPage;
    private String[] lastNonEmptyTokens;

    public PdfBurster(String configFilePath) {
        super(configFilePath);
    }

    @Override
    protected void initializeResources() throws Exception {
        this.ctx.burstTokens = new ArrayList();
        this.burstDocuments = new HashMap<String, List<PDPage>>();
        this.document = PDDocument.load((File)new File(this.filePath));
    }

    @Override
    protected void closeResources() throws Exception {
        if (this.document != null) {
            this.document.close();
        }
    }

    @Override
    protected void parseBurstingMetaData() throws Exception {
        int i;
        int numberOfPages;
        this.ctx.numberOfPages = numberOfPages = this.document.getNumberOfPages();
        this.ctx.previousPageText = "";
        this.ctx.currentPageText = "";
        this.ctx.currentPageIndex = -1;
        this.requestedCancelOrPauseProcessing = this.checkIfRequestedCancelOrPauseProcessing();
        for (i = 1; i < numberOfPages + 1; ++i) {
            if (this.requestedCancelOrPauseProcessing) continue;
            this.ctx.currentPageIndex = i;
            this.scripting.executeBurstingLifeCycleScript(this.ctx.scripts.startParsePage, this.ctx);
            this.processPage(i);
            this.scripting.executeBurstingLifeCycleScript(this.ctx.scripts.endParsePage, this.ctx);
            this.ctx.previousPageText = this.ctx.currentPageText;
            this.ctx.currentPageText = "";
            this.requestedCancelOrPauseProcessing = this.checkIfRequestedCancelOrPauseProcessing();
        }
        this.ctx.previousPageText = "";
        this.ctx.currentPageText = "";
        this.ctx.currentPageIndex = -1;
        if (this.ctx.burstTokens.size() == 0) {
            this.log.info("No burst tokens were found in the document -> Burting the document into " + numberOfPages + " documents of one page each...");
            for (i = 1; i <= numberOfPages; ++i) {
                String token = Integer.toString(i);
                this.ctx.burstTokens.add(token);
                ArrayList<PDPage> pages = new ArrayList<PDPage>();
                pages.add(this.document.getDocumentCatalog().getPages().get(i - 1));
                this.burstDocuments.put(token, pages);
            }
        }
    }

    public void processPage(int pageIndex) throws Exception {
        PDFTextStripper stripper = new PDFTextStripper(){

            protected void endPage(PDPage page) {
                PdfBurster.this.currentPage = page;
            }
        };
        if (this.ctx.settings.getAverageCharTolerance() > 0.0f) {
            stripper.setAverageCharTolerance(this.ctx.settings.getAverageCharTolerance());
        }
        if (this.ctx.settings.getSpacingTolerance() > 0.0f) {
            stripper.setSpacingTolerance(this.ctx.settings.getSpacingTolerance());
        }
        stripper.setSortByPosition(this.ctx.settings.isSortByPosition());
        stripper.setSuppressDuplicateOverlappingText(this.ctx.settings.isSuppressDuplicateOverlappingText());
        stripper.setShouldSeparateByBeads(this.ctx.settings.isShouldSeparateByBeads());
        stripper.setStartPage(pageIndex);
        stripper.setEndPage(pageIndex);
        this.ctx.currentPageText = stripper.getText(this.document);
        if (pageIndex == 1) {
            this.checkForCustomConfigFile();
        }
        stripper = null;
        this.scripting.executeBurstingLifeCycleScript(this.ctx.scripts.parsePageTokens, this.ctx);
        if (this.ctx.settings.isReuseTokensWhenNotFound()) {
            if (this.ctx.currentPageTokens == null || this.ctx.currentPageTokens.length == 0) {
                this.ctx.currentPageTokens = this.lastNonEmptyTokens;
            } else {
                this.lastNonEmptyTokens = this.ctx.currentPageTokens;
            }
        }
        if (this.ctx.currentPageTokens != null && this.ctx.currentPageTokens.length > 0) {
            for (int i = 0; i < this.ctx.currentPageTokens.length; ++i) {
                String token = Utils.removeControlCharactersFromString((String)this.ctx.currentPageTokens[i].trim());
                if (token.length() <= 0) continue;
                if (this.ctx.burstTokens.contains(token)) {
                    this.burstDocuments.get(token).add(this.currentPage);
                } else {
                    this.ctx.burstTokens.add(token);
                    ArrayList<PDPage> pages = new ArrayList<PDPage>();
                    pages.add(this.currentPage);
                    this.burstDocuments.put(token, pages);
                }
                this.ctx.variables.parseUserVariables(token, this.ctx.currentPageText);
            }
        }
        this.log.info("Done reading page " + pageIndex + " ...");
        this.log.debug("Page " + pageIndex + " contains following tokens: " + Arrays.toString(this.ctx.currentPageTokens));
        this.currentPage = null;
    }

    protected void checkForCustomConfigFile() throws Exception {
        String customConfigFilePath = StringUtils.substringBetween((String)this.ctx.currentPageText, (String)CFG_START_SHORT, (String)CFG_END_SHORT);
        if (StringUtils.isEmpty((CharSequence)customConfigFilePath)) {
            customConfigFilePath = StringUtils.substringBetween((String)this.ctx.currentPageText, (String)CFG_START_LONG, (String)CFG_END_LONG);
        }
        this.log.debug("customConfigFilePath = " + customConfigFilePath);
        if (StringUtils.isNotEmpty((CharSequence)customConfigFilePath)) {
            this.ctx.configurationFilePath = customConfigFilePath;
            this.ctx.settings.setConfigurationFilePath(customConfigFilePath);
            this.executeController();
        }
    }

    @Override
    protected void extractOutputBurstDocument() throws Exception {
        List<PDPage> pages = this.burstDocuments.get(this.ctx.token);
        PdfExtractor extractor = this.getPdfExtractor(this.document, this.ctx.extractedFilePath, this.ctx.token);
        extractor.doExtract(pages);
        this.writeDistributedBy();
        if (this.ctx.settings.isSplit2ndTime() && !this.ctx.configurationFilePath.contains("split_2nd_time")) {
            this._split2ndTime(this.ctx.extractedFilePath);
        }
    }

    private void _split2ndTime(String filePathToSplit2ndTime) throws Exception {
        Pdf2ndTimeSplitter split2ndSplitter = new Pdf2ndTimeSplitter(this);
        split2ndSplitter.burst(filePathToSplit2ndTime, false, "", -1);
    }

    protected PdfExtractor getPdfExtractor(PDDocument pdf, String outputFileName, String token) {
        this.log.debug("outputFileName = " + outputFileName + ", token = " + token);
        return new PdfExtractor(pdf, this.ctx.settings, outputFileName, token);
    }

    private void writeDistributedBy() {
        try {
            this.scripting.executeBurstingLifeCycleScript(this.ctx.scripts.distributedBy, this.ctx);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

