/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine.excel;

import com.sourcekraft.documentburster.engine.AbstractBurster;
import com.sourcekraft.documentburster.engine.excel.ExcelBurstMetaData;
import com.sourcekraft.documentburster.engine.excel.ExcelUtils;
import com.sourcekraft.documentburster.engine.excel.extractor.PoiExcelExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiExcelBurster
extends AbstractBurster {
    private Logger log = LoggerFactory.getLogger(PoiExcelBurster.class);
    private String tempWorkBookPath;
    private ExcelBurstMetaData burstMetaData = new ExcelBurstMetaData();

    public PoiExcelBurster(String configFilePath) {
        super(configFilePath);
    }

    @Override
    protected void initializeResources() throws Exception {
        this.ctx.burstTokens = new ArrayList();
        this.tempWorkBookPath = this.getTempWorkBookPath();
    }

    @Override
    protected void closeResources() throws Exception {
        File tempWorkBook;
        if (!this.burstMetaData.getBurstMethod().equals("distinct-sheets") && (tempWorkBook = new File(this.tempWorkBookPath)).exists()) {
            try {
                FileUtils.forceDelete((File)tempWorkBook);
            }
            catch (Exception e) {
                FileUtils.forceDeleteOnExit((File)tempWorkBook);
            }
        }
    }

    private String getBurstMethod(Workbook workBook) {
        String method = "distinct-sheets";
        Sheet burstMetaDataSheet = workBook.getSheet("burst");
        Row secondRow = null;
        if (burstMetaDataSheet != null) {
            secondRow = burstMetaDataSheet.getRow(1);
            Cell burstMethodCell = null;
            if (secondRow != null) {
                burstMethodCell = secondRow.getCell(0);
            }
            if (burstMethodCell != null) {
                method = burstMethodCell.getStringCellValue();
            }
        }
        return method;
    }

    @Override
    protected void parseBurstingMetaData() throws Exception {
        FileInputStream input = new FileInputStream(new File(this.filePath));
        Workbook workBook = WorkbookFactory.create((InputStream)input);
        String burstMethod = this.getBurstMethod(workBook);
        this.validateBurstMethod(burstMethod);
        this.burstMetaData.setBurstMethod(burstMethod);
        Sheet burstMetaDataSheet = workBook.getSheet("burst");
        this.ctx.burstTokens = burstMetaDataSheet == null ? this.getBurstTokensFromDistinctSheets(workBook) : this.getBurstTokensAndParseBurstMetaData(workBook, burstMetaDataSheet);
        if (this.ctx.burstTokens.size() == 0) {
            this.log.warn("The list of burst tokens found in the 'burst' sheet metadata is empty. Is that what you want? Please consider to provide a valid list of burst tokens in the 'burstTokens' column of the 'burst' metadata sheet!");
        }
        this.log.debug("Excel burstMetaData : " + (Object)((Object)this.burstMetaData));
    }

    private List<String> getBurstTokensAndParseBurstMetaData(Workbook workBook, Sheet burstMetaDataSheet) throws Exception {
        ArrayList<String> tokens = new ArrayList<String>();
        Row metaDataRow = burstMetaDataSheet.getRow(1);
        if (!this.burstMetaData.getBurstMethod().equals("distinct-sheets")) {
            this.parseBurstSheetAndColumnIndex(workBook, metaDataRow);
        }
        this._checkForCustomConfigFile(metaDataRow);
        for (Row row : burstMetaDataSheet) {
            String token;
            Cell burstTokensCell = row.getCell(3);
            if (burstTokensCell == null || !StringUtils.isNotEmpty((CharSequence)(token = ExcelUtils.getCellValueAsString(burstTokensCell))) || token.endsWith("burstTokens") || tokens.contains(token)) continue;
            token = token.trim();
            tokens.add(token);
            this.parseUserVariablesForCurrentToken(row, token);
        }
        return tokens;
    }

    private void _checkForCustomConfigFile(Row metaDataRow) throws Exception {
        String customConfigFilePath = null;
        Cell configFileCell = metaDataRow.getCell(5);
        if (configFileCell != null) {
            customConfigFilePath = configFileCell.getStringCellValue();
        }
        if (StringUtils.isNotEmpty(customConfigFilePath)) {
            this.ctx.configurationFilePath = customConfigFilePath;
            this.ctx.settings.setConfigurationFilePath(customConfigFilePath);
            this.executeController();
        }
    }

    private void parseBurstSheetAndColumnIndex(Workbook workBook, Row metaDataRow) throws Exception {
        Cell burstSheetIndexCell = metaDataRow.getCell(1);
        Cell burstColumnIndexCell = metaDataRow.getCell(2);
        int sheetIndex = 0;
        if (burstSheetIndexCell == null) {
            throw new Exception("The mandatory numeric 'burstSheetIndex' is missing in the  'burst' sheet metadata. Please provide a valid numeric(0 based) 'burstSheetIndex'. -1 is a allowed conventional value which meens to burst using the first sheet.");
        }
        sheetIndex = Integer.valueOf(ExcelUtils.getNumericCellValueAsString(burstSheetIndexCell));
        if (sheetIndex > 0) {
            this.burstMetaData.setBurstSheetIndex(sheetIndex);
        } else {
            this.burstMetaData.setBurstSheetIndex(0);
        }
        int columnIndex = -1;
        if (burstColumnIndexCell == null) {
            throw new Exception("The mandatory numeric 'burstColumnIndex' is missing in the  'burst' sheet metadata. Please provide a valid numeric(0 based) 'burstColumnIndex'. -1 is a allowed conventional value which meens to burst using the last column from the bursting sheet.");
        }
        columnIndex = Integer.valueOf(ExcelUtils.getNumericCellValueAsString(burstColumnIndexCell));
        if (columnIndex >= 0) {
            this.burstMetaData.setBurstColumnIndex(columnIndex);
        } else {
            Sheet burstSheet = workBook.getSheetAt(this.burstMetaData.getBurstSheetIndex());
            this.burstMetaData.setBurstColumnIndex(burstSheet.getRow(0).getLastCellNum() - 1);
        }
    }

    private void parseUserVariablesForCurrentToken(Row row, String token) {
        Cell variablesCell = row.getCell(4);
        String variablesText = null;
        if (variablesCell != null) {
            variablesText = variablesCell.getStringCellValue();
        }
        if (StringUtils.isNotEmpty(variablesText) && !variablesText.equals("userVariables") && StringUtils.isNotEmpty((CharSequence)token) && !token.endsWith("burstTokens")) {
            this.ctx.variables.parseUserVariables(token, variablesText);
        }
    }

    private List<String> getBurstTokensFromDistinctSheets(Workbook workBook) {
        ArrayList<String> tokens = new ArrayList<String>();
        int numberOfSheets = workBook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            tokens.add(workBook.getSheetName(i));
        }
        return tokens;
    }

    private void validateBurstMethod(String burstMethod) throws Exception {
        if (StringUtils.isEmpty((CharSequence)burstMethod)) {
            throw new Exception("The mandatory 'burstMethod' is missing in the  'burst' sheet metadata. Please provide a valid 'burstMethod' such as 'distinct-sheets' or 'distinct-column-values'!");
        }
        if (!(burstMethod.equals("distinct-sheets") || burstMethod.equals("distinct-column-values") || burstMethod.equals("distinct-column-values-copy"))) {
            throw new Exception("The 'burstMethod' is misspelled in the 'burst' sheet metadata. Please provide a valid 'burstMethod' such as 'distinct-sheets' or 'distinct-column-values'!");
        }
    }

    @Override
    protected void extractOutputBurstDocument() throws Exception {
        this.log.debug("ctx = " + this.ctx + " , burstMetaData = " + (Object)((Object)this.burstMetaData));
        PoiExcelExtractor extractor = new PoiExcelExtractor(this.ctx.inputDocumentFilePath, this.ctx.extractedFilePath, this.ctx.token);
        if (this.burstMetaData.getBurstMethod().equals("distinct-sheets")) {
            extractor.doExtractSheet();
        } else {
            int burstSheetIndex = this.burstMetaData.getBurstSheetIndex();
            int burstColumnIndex = this.burstMetaData.getBurstColumnIndex();
            if (!new File(this.tempWorkBookPath).exists()) {
                this.evaluateAllInputFormula();
                this.createEmptyWorkbookTemplate(burstSheetIndex);
            }
            this.log.debug("tempWorkBookPath = " + this.tempWorkBookPath);
            extractor.setTempWorkbookPath(this.tempWorkBookPath);
            extractor.doExtractForDistinctColumnValueCopy(burstSheetIndex, burstColumnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateAllInputFormula() throws Exception {
        this.log.debug("evaluateAllInputFormula()");
        FileInputStream input = null;
        FileOutputStream fileOut = null;
        try {
            input = new FileInputStream(new File(this.filePath));
            Workbook workBook = WorkbookFactory.create((InputStream)input);
            FormulaEvaluator evaluator = workBook.getCreationHelper().createFormulaEvaluator();
            for (int sheetNum = 0; sheetNum < workBook.getNumberOfSheets(); ++sheetNum) {
                Sheet sheet = workBook.getSheetAt(sheetNum);
                for (Row row : sheet) {
                    for (Cell cell : row) {
                        if (cell.getCellType() != CellType.FORMULA) continue;
                        evaluator.evaluateFormulaCell(cell);
                    }
                }
            }
            fileOut = new FileOutputStream(this.filePath);
            workBook.write((OutputStream)fileOut);
            fileOut.flush();
        }
        catch (Throwable throwable) {
            this.closeResources(input, fileOut);
            throw throwable;
        }
        this.closeResources(input, fileOut);
    }

    private void closeResources(InputStream input, FileOutputStream fileOut) throws IOException {
        if (fileOut != null) {
            fileOut.close();
        }
        if (input != null) {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmptyWorkbookTemplate(int burstSheetIndex) throws Exception {
        this.log.debug("burstSheetIndex = " + burstSheetIndex);
        FileInputStream input = null;
        FileOutputStream fileOut = null;
        try {
            input = new FileInputStream(new File(this.filePath));
            Workbook workBook = WorkbookFactory.create((InputStream)input);
            this.cleanSheet(workBook.getSheetAt(burstSheetIndex));
            int numberOfSheets = workBook.getNumberOfSheets();
            workBook.removeSheetAt(numberOfSheets - 1);
            fileOut = new FileOutputStream(this.tempWorkBookPath);
            workBook.write((OutputStream)fileOut);
            fileOut.flush();
        }
        catch (Throwable throwable) {
            this.closeResources(input, fileOut);
            throw throwable;
        }
        this.closeResources(input, fileOut);
    }

    protected String getTempWorkBookPath() {
        String baseName = FilenameUtils.getBaseName((String)this.filePath);
        String extension = FilenameUtils.getExtension((String)this.filePath);
        Random generator = new Random(Long.MAX_VALUE);
        return "./temp/" + baseName + "_" + generator.nextInt() + "." + extension;
    }

    private void cleanSheet(Sheet sheet) {
        int numberOfRows = sheet.getPhysicalNumberOfRows();
        while (numberOfRows > 0) {
            sheet.removeRow(sheet.getRow(numberOfRows - 1));
            numberOfRows = sheet.getPhysicalNumberOfRows();
        }
    }
}

