/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.NumberToTextConverter;

public class ExcelUtils {
    public static String getCellValueAsString(Cell cell) {
        String cellValue;
        if (cell == null) {
            return "";
        }
        CellType cellType = cell.getCellType();
        block0 : switch (cellType) {
            case STRING: {
                cellValue = cell.getRichStringCellValue().getString();
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    cellValue = cell.getDateCellValue().toString();
                    break;
                }
                cellValue = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                cellValue = Boolean.toString(cell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                CellType formulaResultType = cell.getCachedFormulaResultType();
                switch (formulaResultType) {
                    case STRING: {
                        cellValue = cell.getStringCellValue();
                        break block0;
                    }
                    case NUMERIC: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            cellValue = cell.getDateCellValue().toString();
                            break block0;
                        }
                        cellValue = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                        break block0;
                    }
                    case BOOLEAN: {
                        cellValue = Boolean.toString(cell.getBooleanCellValue());
                        break block0;
                    }
                }
                cellValue = "";
                break;
            }
            case BLANK: {
                cellValue = "";
                break;
            }
            case ERROR: {
                cellValue = "ERROR: " + cell.getErrorCellValue();
                break;
            }
            default: {
                cellValue = "";
            }
        }
        return cellValue;
    }

    public static String getNumericCellValueAsString(Cell cell) {
        double value = cell.getNumericCellValue();
        CellStyle cellStyle = cell.getCellStyle();
        short formatIndex = cellStyle.getDataFormat();
        DataFormatter formatter = new DataFormatter();
        return formatter.formatRawCellContents(value, (int)formatIndex, cellStyle.getDataFormatString());
    }

    public static String getSheetText(Sheet sheet) {
        StringBuilder text = new StringBuilder();
        for (Row row : sheet) {
            for (Cell cell : row) {
                String cellValue = ExcelUtils.getCellValueAsString(cell);
                if (cellValue.isEmpty()) continue;
                text.append(cellValue).append(" ");
            }
            text.append("\n");
        }
        return text.toString();
    }

    public static String getExcelText(File excelFile) throws IOException {
        StringBuilder text = new StringBuilder();
        try (FileInputStream fis = new FileInputStream(excelFile);
             Workbook workbook = WorkbookFactory.create((InputStream)fis);){
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                Sheet sheet = workbook.getSheetAt(i);
                text.append(ExcelUtils.getSheetText(sheet));
            }
        }
        return text.toString();
    }
}

