/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine;

import com.sourcekraft.documentburster.GlobalContext;
import com.sourcekraft.documentburster.common.db.DatabaseConnectionManager;
import com.sourcekraft.documentburster.common.db.SqlExecutor;
import com.sourcekraft.documentburster.common.settings.Settings;
import com.sourcekraft.documentburster.common.settings.model.Attachment;
import com.sourcekraft.documentburster.context.BurstingContext;
import com.sourcekraft.documentburster.job.JobUtils;
import com.sourcekraft.documentburster.job.model.JobProgressDetails;
import com.sourcekraft.documentburster.scripting.Scripting;
import com.sourcekraft.documentburster.sender.AbstractSender;
import com.sourcekraft.documentburster.sender.factory.SendersFactory;
import com.sourcekraft.documentburster.utils.LicenseUtils;
import com.sourcekraft.documentburster.utils.Scripts;
import com.sourcekraft.documentburster.utils.Utils;
import com.sourcekraft.documentburster.variables.Variables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBurster {
    protected static Logger log = LoggerFactory.getLogger(AbstractBurster.class);
    private static final Pattern BURSTING_PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{[^}]+\\}");
    private long startExecutionTime = 0L;
    protected int licenseLimit = 9999;
    private boolean licenseLimitExceeded = false;
    private JobProgressDetails previousJobExecutionProgressDetails = null;
    private GlobalContext global = new GlobalContext();
    protected boolean requestedCancelOrPauseProcessing = false;
    protected String configurationFilePath;
    protected Scripting scripting;
    protected String jobType;
    protected String jobFilePath;
    protected String filePath;
    protected String fileName;
    protected BurstingContext ctx;
    protected LicenseUtils licenseUtils = new LicenseUtils();

    public AbstractBurster(String configFilePath) {
        this.configurationFilePath = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{configFilePath}) && (configFilePath.contains("split_2nd_time") || Files.exists(Paths.get(configFilePath, new String[0]), new LinkOption[0])) ? configFilePath : "./config/burst/settings.xml";
    }

    public int getLicenseLimit() {
        return this.licenseLimit;
    }

    public String getTempFolder() {
        return Utils.getTempFolder();
    }

    protected void fetchData() throws Exception {
    }

    protected void parseBurstingMetaData() throws Exception {
    }

    protected void processOutputDocument() throws Exception {
        this.extractOutputBurstDocument();
        this.ctx.extractedFilePaths.put(this.ctx.token, this.ctx.extractedFilePath);
        ++this.ctx.numberOfExtractedFiles;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public void setJobFilePath(String jobFilePath) {
        this.jobFilePath = jobFilePath;
    }

    public void setPreviousJobExecutionProgressDetails(JobProgressDetails jobProgressDetails) {
        this.previousJobExecutionProgressDetails = jobProgressDetails;
    }

    protected void executeBurstingLifeCycleScript(String scriptFileName, BurstingContext context) throws Exception {
        this.scripting.executeBurstingLifeCycleScript(scriptFileName, this.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void burst(String pathToFile, boolean testAll, String listOfTestTokens, int numberOfRandomTestTokens) throws Exception {
        log.info("Bursting document: '" + pathToFile + "' ...");
        this.checkLicense();
        this.filePath = pathToFile;
        this.fileName = FilenameUtils.getName((String)pathToFile);
        this._initializeBursting();
        this.ctx.inputDocumentFilePath = pathToFile;
        try {
            this.setUpScriptingRoots();
            this.executeBurstingLifeCycleScript(this.ctx.scripts.startBursting, this.ctx);
            this.executeController();
            this.validateConfigurationValues();
            this.initializeResources();
            this.fetchData();
            this.executeBurstingLifeCycleScript(this.ctx.scripts.transformFetchedData, this.ctx);
            this.parseBurstingMetaData();
            log.debug("burstTokens = " + this.ctx.burstTokens);
            this.requestedCancelOrPauseProcessing = this.checkIfRequestedCancelOrPauseProcessing();
            boolean isSingleReportMode = false;
            String burstFileName = this.ctx.settings.getBurstFileName();
            if (burstFileName != null && !burstFileName.isEmpty()) {
                if (!BURSTING_PLACEHOLDER_PATTERN.matcher(burstFileName).find()) {
                    if (this.ctx.reportData != null && !this.ctx.reportData.isEmpty()) {
                        isSingleReportMode = true;
                    } else {
                        log.warn("Filename '{}' suggests single report mode, but reportData is empty. Cannot generate report.", (Object)burstFileName);
                    }
                }
            } else {
                log.warn("BurstFileName is null or empty. Cannot determine report mode or generate file.");
            }
            if (isSingleReportMode) {
                log.info("Detected single report mode (Filename: '{}', reportData present). Processing once.", (Object)burstFileName);
                if (!this.requestedCancelOrPauseProcessing) {
                    this.ctx.token = "1";
                    this.ctx.variables.set("burst_token", (Object)this.ctx.token);
                    this.ctx.variables.setUserVariable(this.ctx.token, "burst_token", (Object)this.ctx.token);
                    this.ctx.variables.setUserVariable(this.ctx.token, "row_index", (Object)"0");
                    this.ctx.variables.setUserVariable(this.ctx.token, "row_number", (Object)"1");
                    this.ctx.variables.set("reportData", (Object)this.ctx.reportData);
                    log.debug("Made ctx.reportData available to template as 'reportData'");
                    this._processReportForCurrentToken(this.shouldSendFiles(), true);
                }
            } else {
                if (this.ctx.burstTokens.size() == 0) {
                    throw new Exception("No burst tokens were provided or fetched for the document : " + pathToFile);
                }
                if (!this.requestedCancelOrPauseProcessing) {
                    String backupFilePath;
                    File backupFile;
                    boolean shouldSendFiles = this.shouldSendFiles();
                    List<Object> listOfTokens = new ArrayList();
                    if (this._isRunningInQualityAssuranceMode(testAll, listOfTestTokens, numberOfRandomTestTokens)) {
                        this.ctx.settings.setFailJobIfAnyDistributionFails(false);
                        this.ctx.testName = this.ctx.testName + "quality-assurance-test-mode";
                        this.ctx.isQARunningMode = true;
                        if (StringUtils.isNotBlank((CharSequence)listOfTestTokens)) {
                            listOfTokens = Arrays.asList(listOfTestTokens.split(","));
                            if (this.ctx.burstTokens.containsAll(listOfTokens)) {
                                this.ctx.burstTokens.retainAll(listOfTokens);
                            } else {
                                throw new IllegalArgumentException("You provided the list: " + listOfTestTokens + ", which is not correct. Please provide a comma separated list of burst tokens which should be tested. Each of the elements from this list should be a valid burst token from '" + pathToFile + "'!");
                            }
                        }
                        if (numberOfRandomTestTokens > 0) {
                            Collections.shuffle(this.ctx.burstTokens);
                            while (this.ctx.burstTokens.size() > numberOfRandomTestTokens) {
                                this.ctx.burstTokens.remove(this.ctx.burstTokens.size() - 1);
                            }
                        }
                    }
                    if (this.previousJobExecutionProgressDetails != null) {
                        this._validatePreviousJobExecutionProgressDetails();
                    }
                    String lastTokenInDocument = (String)this.ctx.burstTokens.get(this.ctx.burstTokens.size() - 1);
                    this.requestedCancelOrPauseProcessing = this.checkIfRequestedCancelOrPauseProcessing();
                    boolean doMore = !this.requestedCancelOrPauseProcessing;
                    int doneCount = 0;
                    Iterator iterator = this.ctx.burstTokens.iterator();
                    while (iterator.hasNext()) {
                        String token;
                        this.ctx.token = token = (String)iterator.next();
                        this.ctx.variables.set("burst_token", (Object)this.ctx.token);
                        this.ctx.variables.set("burst_index", (Object)(doneCount + 1));
                        if (!doMore) continue;
                        if (this.previousJobExecutionProgressDetails != null) {
                            boolean wasAlreadyProcessed = this._checkIfCurrentTokenWasAlreadyProcessedInPreviousJobExecution();
                            if (!wasAlreadyProcessed) {
                                this._processReportForCurrentToken(shouldSendFiles, !testAll);
                            }
                        } else {
                            this._processReportForCurrentToken(shouldSendFiles, !testAll);
                        }
                        if (token.equals(lastTokenInDocument)) {
                            File progressFile = new File(this.getTempFolder() + this.getJobProgressFileName());
                            progressFile.delete();
                        } else {
                            this._updateJobProgressAndSaveToFile(testAll, listOfTestTokens, numberOfRandomTestTokens);
                        }
                        this.licenseLimitExceeded = ++doneCount >= this.licenseLimit;
                        this.requestedCancelOrPauseProcessing = this.checkIfRequestedCancelOrPauseProcessing();
                        doMore = !this.requestedCancelOrPauseProcessing && !this.licenseLimitExceeded;
                    }
                    boolean isDeleteFiles = this.ctx.settings.isDeleteFiles();
                    if (isDeleteFiles && (backupFile = new File(backupFilePath = this.ctx.backupFolder + "/" + FilenameUtils.getName((String)pathToFile))).exists() && !FileUtils.deleteQuietly((File)backupFile)) {
                        log.error("Failed to delete " + backupFilePath);
                    }
                    this.ctx.token = "";
                    this.ctx.extractedFilePath = "";
                    if (this.licenseLimitExceeded) {
                        log.warn("DEMO version limit - DocumentBurster DEMO version can burst and distribute up to " + this.licenseLimit + " reports. If you need more please license DocumentBurster from https://www.pdfburst.com/store/ ");
                    }
                }
            }
        }
        finally {
            this.closeResources();
            this.backupFile();
            this.executeBurstingLifeCycleScript(this.ctx.scripts.endBursting, this.ctx);
            log.info("DONE bursting document");
            this.writeStatsFile();
        }
    }

    private void validateConfigurationValues() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.ctx.settings.getBurstFileName())) {
            throw new Exception("'Burst File Name' cannot be empty, please provide a valid 'Burst File Name' configuration value for the configuration template called '" + this.ctx.settings.getTemplateName() + "'");
        }
        if (StringUtils.isBlank((CharSequence)this.ctx.settings.getOutputFolder())) {
            throw new Exception("'Output Folder' cannot be empty, please provide a valid 'Output Folder' configuration value for the configuration template called '" + this.ctx.settings.getTemplateName() + "'");
        }
        if (this.shouldSendFiles() && StringUtils.isBlank((CharSequence)this.ctx.settings.getQuarantineFolder())) {
            throw new Exception("'Quarantine Folder' cannot be empty, please provide a valid 'Quarantine Folder' configuration value for the configuration template called '" + this.ctx.settings.getTemplateName() + "'");
        }
    }

    protected boolean shouldSendFiles() {
        boolean isSendFilesEmail = this.ctx.settings.getSendFiles().email;
        boolean isSendFilesUpload = this.ctx.settings.getSendFiles().upload;
        boolean isSendFilesWeb = this.ctx.settings.getSendFiles().web;
        boolean isSendFilesSms = this.ctx.settings.getSendFiles().sms;
        return isSendFilesEmail || isSendFilesUpload || isSendFilesWeb || isSendFilesSms;
    }

    public void setLicenseUtils(LicenseUtils licenseUtils) {
        this.licenseUtils = licenseUtils;
    }

    protected void setUpScriptingRoots() {
    }

    public void setGlobal(GlobalContext global) {
        this.global = global;
    }

    public String getCancelJobFileName() {
        String jobFileBaseName = FilenameUtils.getBaseName((String)this.jobFilePath);
        return jobFileBaseName + ".cancel";
    }

    public String getPauseJobFileName() {
        String jobFileBaseName = FilenameUtils.getBaseName((String)this.jobFilePath);
        return jobFileBaseName + ".pause";
    }

    public String getJobProgressFileName() {
        String jobFileBaseName = FilenameUtils.getBaseName((String)this.jobFilePath);
        return jobFileBaseName + ".progress";
    }

    public BurstingContext getCtx() {
        return this.ctx;
    }

    public Scripting getScripting() {
        return this.scripting;
    }

    protected void initializeResources() throws Exception {
    }

    protected void closeResources() throws Exception {
    }

    protected abstract void extractOutputBurstDocument() throws Exception;

    protected void executeController() throws Exception {
        this.executeBurstingLifeCycleScript("controller.groovy", this.ctx);
        this._initializeVariables();
    }

    protected boolean checkIfRequestedCancelOrPauseProcessing() {
        if (this.requestedCancelOrPauseProcessing) {
            return this.requestedCancelOrPauseProcessing;
        }
        File pauseFile = new File(this.getTempFolder() + this.getPauseJobFileName());
        boolean shouldPause = pauseFile.exists();
        if (shouldPause) {
            log.info("***User requested PAUSE***");
            pauseFile.delete();
            return shouldPause;
        }
        File cancelFile = new File(this.getTempFolder() + this.getCancelJobFileName());
        boolean shouldCancel = cancelFile.exists();
        if (shouldCancel) {
            log.info("***User requested CANCEL***");
            cancelFile.delete();
            File progressFile = new File(this.getTempFolder() + this.getJobProgressFileName());
            if (progressFile.exists()) {
                progressFile.delete();
            }
            return shouldCancel;
        }
        return this.requestedCancelOrPauseProcessing;
    }

    private void _initializeBursting() throws Exception {
        this.startExecutionTime = System.nanoTime();
        this.ctx = new BurstingContext();
        this.ctx.configurationFilePath = this.configurationFilePath;
        this.ctx.settings = new Settings(this.configurationFilePath);
        this.ctx.dbManager = new DatabaseConnectionManager(this.ctx.settings);
        this.ctx.sql = new SqlExecutor(this.ctx.dbManager);
        this.ctx.scripts = new Scripts();
        this.scripting = new Scripting();
        this.requestedCancelOrPauseProcessing = false;
    }

    private void _initializeVariables() {
        this.ctx.variables = new Variables(this.fileName, this.ctx.settings.getLanguage(), this.ctx.settings.getCountry(), this.ctx.settings.getNumberOfUserVariables());
    }

    private void _initializeLogsArchivesFolder() throws Exception {
        this.global.logsArchivesFolder = this.ctx.logsArchivesFolder = Utils.getStringFromTemplate((String)this.ctx.settings.getLogsArchivesFolder(), (Variables)this.ctx.variables, (String)this.ctx.token);
    }

    protected void writeStatsFile() throws Exception {
        if (Objects.isNull(this.ctx.variables)) {
            return;
        }
        this._initializeLogsArchivesFolder();
        File logsArchivesDir = new File(this.ctx.logsArchivesFolder);
        if (logsArchivesDir.exists()) {
            throw new IllegalArgumentException("Folder '" + this.ctx.logsArchivesFolder + "' already exists. Please provide a logsarchivesfolder configuration which is guaranteed to generate a new logs/archives folder for each bursting session!");
        }
        FileUtils.forceMkdir((File)logsArchivesDir);
        this.ctx.variables.set("num_pages", (Object)this.ctx.numberOfPages);
        if (this.ctx.burstTokens != null) {
            this.ctx.variables.set("num_tokens", (Object)this.ctx.burstTokens.size());
        } else {
            this.ctx.variables.set("num_tokens", (Object)0);
        }
        this.ctx.variables.set("num_files_extracted", (Object)this.ctx.numberOfExtractedFiles);
        this.ctx.variables.set("num_messages_sent", (Object)this.ctx.numberOfMessagesSent);
        this.ctx.variables.set("num_files_distributed", (Object)this.ctx.numberOfDistributedFiles);
        this.ctx.variables.set("num_files_skipped_distribution", (Object)this.ctx.numberOfSkippedFiles);
        this.ctx.variables.set("num_files_quarantined", (Object)this.ctx.numberOfQuarantinedFiles);
        String statsFileContentTemplate = "\n\nInput Document = '" + this.ctx.inputDocumentFilePath + "'\n\n";
        statsFileContentTemplate = statsFileContentTemplate + "Execution Time = " + Utils.getHumanReadableTime((Long)(System.nanoTime() - this.startExecutionTime)) + "\n\n";
        if (StringUtils.isNotBlank((CharSequence)this.ctx.inputDocumentFilePath) && this.ctx.inputDocumentFilePath.endsWith(".pdf")) {
            statsFileContentTemplate = statsFileContentTemplate + "Number Of Pages = ${num_pages}\n";
        }
        statsFileContentTemplate = statsFileContentTemplate + "Number Of Tokens Read = ${num_tokens}\n";
        statsFileContentTemplate = statsFileContentTemplate + "Number Of Documents Extracted = ${num_files_extracted}\n";
        statsFileContentTemplate = statsFileContentTemplate + "Number Of Messages Sent = ${num_messages_sent}\n";
        statsFileContentTemplate = statsFileContentTemplate + "Number Of Documents Distributed = ${num_files_distributed}\n";
        if (this.ctx.numberOfSkippedFiles > 0) {
            statsFileContentTemplate = statsFileContentTemplate + "Number Of Documents Skipped = ${num_files_skipped_distribution}\n";
        }
        if (this.ctx.numberOfQuarantinedFiles > 0) {
            statsFileContentTemplate = statsFileContentTemplate + "Number Of Documents Quarantined = ${num_files_quarantined}\n";
        }
        statsFileContentTemplate = statsFileContentTemplate + "\n";
        if (this.ctx.outputFolder != null && this.ctx.outputFolder.length() > 0) {
            statsFileContentTemplate = statsFileContentTemplate + "Output Folder = '${output_folder}'\n";
        }
        if (this.ctx.quarantineFolder != null && this.ctx.quarantineFolder.length() > 0) {
            statsFileContentTemplate = statsFileContentTemplate + "Quarantine Folder = '${quarantine_folder}'\n";
        }
        statsFileContentTemplate = statsFileContentTemplate + "\n";
        String statsFileContent = Utils.getStringFromTemplate((String)statsFileContentTemplate, (Variables)this.ctx.variables, (String)this.ctx.token);
        log.info(statsFileContent);
        statsFileContentTemplate = statsFileContentTemplate + "sendfiles.email = " + this.ctx.settings.getSendFiles().email;
        statsFileContentTemplate = statsFileContentTemplate + "\n";
        statsFileContentTemplate = statsFileContentTemplate + "sendfiles.upload = " + this.ctx.settings.getSendFiles().upload;
        statsFileContentTemplate = statsFileContentTemplate + "\n";
        statsFileContentTemplate = statsFileContentTemplate + "sendfiles.web = " + this.ctx.settings.getSendFiles().web;
        statsFileContentTemplate = statsFileContentTemplate + "\n";
        statsFileContentTemplate = statsFileContentTemplate + "sendfiles.sms = " + this.ctx.settings.getSendFiles().sms;
        statsFileContentTemplate = statsFileContentTemplate + "\n\n";
        statsFileContentTemplate = statsFileContentTemplate + "failjobifanydistributionfails = " + this.ctx.settings.isFailJobIfAnyDistributionFails();
        statsFileContentTemplate = statsFileContentTemplate + "\n\n";
        statsFileContent = Utils.getStringFromTemplate((String)statsFileContentTemplate, (Variables)this.ctx.variables, (String)this.ctx.token);
        this.ctx.variables.set("stats_info", (Object)Utils.getStringFromTemplate((String)"${num_pages}pages-${num_files_extracted}extracted-${num_files_distributed}distributed", (Variables)this.ctx.variables, (String)this.ctx.token));
        String statsFileName = Utils.getStringFromTemplate((String)this.ctx.settings.getStatsFileName(), (Variables)this.ctx.variables, (String)this.ctx.token);
        String statsFilePath = this.ctx.logsArchivesFolder + "/" + statsFileName;
        File statsFile = new File(statsFilePath);
        if (statsFile.createNewFile()) {
            BufferedWriter writer = new BufferedWriter(new FileWriter(statsFilePath));
            writer.write(statsFileContent);
            writer.close();
        }
        this._doStats(statsFileContent);
    }

    private void _doStats(String statsFileContent) throws Exception {
    }

    private boolean _isRunningInQualityAssuranceMode(boolean testAll, String listOfTestTokens, int numberOfRandomTestTokens) {
        return testAll || StringUtils.isNotBlank((CharSequence)listOfTestTokens) || numberOfRandomTestTokens > 0;
    }

    private void _processReportForCurrentToken(boolean isSendFiles, boolean executeDistribution) throws Exception {
        if (this.requestedCancelOrPauseProcessing) {
            return;
        }
        String skip = this.ctx.variables.getUserVariables(this.ctx.token).get("skip").toString();
        this.ctx.skipCurrentFileDistribution = Boolean.valueOf(skip);
        log.debug("token = " + this.ctx.token + ", ctx.skipCurrentFileDistribution = " + this.ctx.skipCurrentFileDistribution);
        this.extractDocument();
        if (!this.ctx.configurationFilePath.contains("split_2nd_time")) {
            this.processAttachments();
            if (isSendFiles && !this.ctx.skipCurrentFileDistribution) {
                double delay = this.ctx.settings.getDelayEachDistributionBy();
                if (delay > 0.0) {
                    Thread.sleep((long)(delay * 1000.0));
                }
                this._distributeReport(executeDistribution);
            } else if (isSendFiles && this.ctx.skipCurrentFileDistribution) {
                ++this.ctx.numberOfSkippedFiles;
            }
        }
    }

    protected void extractDocument() throws Exception {
        this.executeBurstingLifeCycleScript(this.ctx.scripts.beforeTemplateProcessing, this.ctx);
        this.executeBurstingLifeCycleScript(this.ctx.scripts.startExtractDocument, this.ctx);
        this.createOutputFoldersIfTheyDontExist();
        String burstFileName = Utils.getFileNameOfBurstDocument((String)this.ctx.settings.getBurstFileName(), (String)this.ctx.token);
        this.ctx.extractedFilePath = this.ctx.outputFolder + "/" + Utils.getStringFromTemplate((String)burstFileName, (Variables)this.ctx.variables, (String)this.ctx.token);
        this.ctx.variables.set("extracted_file_path", (Object)this.ctx.extractedFilePath);
        if (this.ctx.settings.getDumpRecordDataAsXml()) {
            this.dumpCurrentRecordDataAsXml();
        }
        this.processOutputDocument();
        this.executeBurstingLifeCycleScript(this.ctx.scripts.endExtractDocument, this.ctx);
        log.info("Document '" + this.ctx.extractedFilePath + "' was extracted for token '" + this.ctx.token + "'");
    }

    protected void dumpCurrentRecordDataAsXml() throws Exception {
        String xmlDumpFilePath = this.ctx.extractedFilePath.substring(0, this.ctx.extractedFilePath.length() - 4) + "-record-data.xml";
        String xmlDumpFileContent = Utils.dumpRowAsXml((Map)this.ctx.variables.getUserVariables(this.ctx.token));
        FileUtils.writeStringToFile((File)new File(xmlDumpFilePath), (String)xmlDumpFileContent, (String)"UTF-8");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processAttachments() throws Exception {
        this.ctx.attachments.clear();
        this.ctx.archiveFilePath = "";
        List attachments = this.ctx.settings.getAttachments();
        if (attachments.size() > 0) {
            for (Attachment attachment : attachments) {
                String attachmentPath = "";
                if (!attachment.path.contains("extracted_file_paths_after_splitting_2nd_time")) {
                    attachmentPath = Utils.getStringFromTemplate((String)attachment.path, (Variables)this.ctx.variables, (String)this.ctx.token);
                    this.ctx.attachments.add(attachmentPath);
                    continue;
                }
                if (!attachment.path.contains("extracted_file_paths_after_splitting_2nd_time")) continue;
                for (Map.Entry entry : this.ctx.extractedFilePathsAfterSplitting2ndTime.entrySet()) {
                    attachmentPath = (String)entry.getValue();
                    if (!new File(attachmentPath).exists()) continue;
                    this.ctx.attachments.add(attachmentPath);
                }
            }
            if (this.ctx.settings.isArchiveAttachments()) {
                String archiveFileName = Utils.getStringFromTemplate((String)this.ctx.settings.getArchiveFileName(), (Variables)this.ctx.variables, (String)this.ctx.token);
                if (!StringUtils.isNotBlank((CharSequence)archiveFileName)) throw new Exception("You need to provide a valid 'archiveFileName'");
                this.ctx.archiveFilePath = this.ctx.outputFolder + "/" + archiveFileName;
                log.debug("Archiving attachments to '" + this.ctx.archiveFilePath + "'");
                this.executeBurstingLifeCycleScript(this.ctx.scripts.archive, this.ctx);
            }
        } else {
            log.debug("There are no attachments defined for the token '" + this.ctx.token + "'!");
        }
        log.debug("ctx.attachments = " + this.ctx.attachments);
    }

    private void _distributeReport(boolean execute) throws Exception {
        List<Object> senders = new ArrayList();
        try {
            senders = this._getSenders(execute);
            if (senders != null && senders.size() > 0) {
                for (AbstractSender abstractSender : senders) {
                    abstractSender.setScripting(this.scripting);
                    abstractSender.send();
                }
            }
            this._checkAndDeleteFile();
        }
        catch (IllegalArgumentException e) {
            if (this.ctx.settings.isQuarantineFiles()) {
                this.quarantineDocument();
            }
            this.ctx.setLastException((Exception)e);
            this.executeBurstingLifeCycleScript(this.ctx.scripts.distributeReportErrorHandling, this.ctx);
        }
    }

    private void _updateJobProgressAndSaveToFile(boolean testAll, String listOfTestTokens, int numberOfRandomTestTokens) throws Exception {
        if (!this.licenseUtils.getLicense().itWasPaid()) {
            return;
        }
        Date d = Calendar.getInstance().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        String currentDate = sdf.format(d);
        int tokensCount = this.ctx.burstTokens.size();
        int pagesCount = this.ctx.numberOfPages;
        String lastTokenProcessed = this.ctx.token;
        String lastTokenInDocument = (String)this.ctx.burstTokens.get(this.ctx.burstTokens.size() - 1);
        int indexOfLastTokenProcessed = this.ctx.burstTokens.indexOf(lastTokenProcessed);
        int numberOfRemainingTokens = this.ctx.burstTokens.size() - 1 - indexOfLastTokenProcessed;
        JobProgressDetails currentJobExecutionProgressDetails = new JobProgressDetails();
        currentJobExecutionProgressDetails.currentdate = currentDate;
        currentJobExecutionProgressDetails.filepath = this.filePath;
        currentJobExecutionProgressDetails.jobtype = this.jobType;
        currentJobExecutionProgressDetails.configurationFilePath = this.configurationFilePath;
        currentJobExecutionProgressDetails.lasttokenprocessed = lastTokenProcessed;
        currentJobExecutionProgressDetails.lasttokenindocument = lastTokenInDocument;
        currentJobExecutionProgressDetails.testall = testAll;
        currentJobExecutionProgressDetails.listoftesttokens = listOfTestTokens;
        currentJobExecutionProgressDetails.numberofrandomtesttokens = numberOfRandomTestTokens;
        currentJobExecutionProgressDetails.tokenscount = tokensCount;
        currentJobExecutionProgressDetails.pagescount = pagesCount;
        currentJobExecutionProgressDetails.numberofremainingtokens = numberOfRemainingTokens;
        currentJobExecutionProgressDetails.indexoflasttokenprocessed = indexOfLastTokenProcessed;
        String progressFilePath = this.getTempFolder() + this.getJobProgressFileName();
        File progressFile = new File(progressFilePath);
        if (progressFile.exists()) {
            progressFile.delete();
        }
        JobUtils.saveJobProgressDetails(currentJobExecutionProgressDetails, progressFilePath);
    }

    protected void backupFile() throws Exception {
        File backupFile;
        if (this.ctx.settings.isDeleteFiles()) {
            return;
        }
        this.ctx.backupFolder = Utils.getStringFromTemplate((String)this.ctx.settings.getBackupFolder(), (Variables)this.ctx.variables, (String)this.ctx.token);
        File backupDir = new File(this.ctx.backupFolder);
        if (!backupDir.exists()) {
            FileUtils.forceMkdir((File)backupDir);
        }
        if (!(backupFile = new File(this.ctx.backupFolder + "/" + this.fileName)).exists()) {
            FileUtils.copyFile((File)new File(this.filePath), (File)backupFile);
        }
    }

    protected void createOutputFoldersIfTheyDontExist() throws Exception {
        this.ctx.quarantineFolder = Utils.getStringFromTemplate((String)this.ctx.settings.getQuarantineFolder(), (Variables)this.ctx.variables, (String)this.ctx.token);
        this.ctx.variables.set("quarantine_folder", (Object)this.ctx.quarantineFolder);
        this.ctx.outputFolder = Utils.getStringFromTemplate((String)this.ctx.settings.getOutputFolder(), (Variables)this.ctx.variables, (String)this.ctx.token);
        this.ctx.variables.set("output_folder", (Object)this.ctx.outputFolder);
        File outputDir = new File(this.ctx.outputFolder);
        if (!outputDir.exists()) {
            FileUtils.forceMkdir((File)outputDir);
            if (this.ctx.isQARunningMode) {
                FileUtils.forceMkdir((File)new File(this.ctx.outputFolder + "/quality-assurance"));
            }
        }
    }

    private List<AbstractSender> _getSenders(boolean execute) throws Exception {
        log.debug("getSenders()");
        List<AbstractSender> senders = SendersFactory.makeSenders(this.ctx, execute);
        return senders;
    }

    protected void quarantineDocument() throws Exception {
        Utils.copyFileToQuarantine((String)this.ctx.quarantineFolder, (String)this.ctx.extractedFilePath);
        ++this.ctx.numberOfQuarantinedFiles;
        this.executeBurstingLifeCycleScript(this.ctx.scripts.quarantineDocument, this.ctx);
    }

    protected void checkLicense() throws Exception {
        this.licenseUtils.getLicense().loadLicense();
        if (this.licenseUtils.getLicense().isDemo()) {
            return;
        }
        this.licenseUtils.checkLicense();
        if (this.licenseUtils.getLicense().itWasPaid()) {
            this.licenseLimit = Integer.MAX_VALUE;
        }
        if (this.licenseUtils.getLicense().isExpired()) {
            log.warn("License expired - Please renew license - https://www.pdfburst.com/renew.html");
        }
    }

    private void _checkAndDeleteFile() throws Exception {
        boolean isDeleteFiles = this.ctx.settings.isDeleteFiles();
        if (isDeleteFiles) {
            File extractedFile = new File(this.ctx.extractedFilePath);
            if (extractedFile.delete()) {
                log.info("Document '" + this.ctx.extractedFilePath + "' was deleted because {deletefiles} configuration is true");
            } else {
                log.error("Failed to delete " + this.ctx.extractedFilePath);
            }
        }
    }

    private boolean _checkIfCurrentTokenWasAlreadyProcessedInPreviousJobExecution() {
        int indexLastTokenProcessedInPreviousJobExecution = this.ctx.burstTokens.indexOf(this.previousJobExecutionProgressDetails.lasttokenprocessed);
        int indexTokenCurrent = this.ctx.burstTokens.indexOf(this.ctx.token);
        return indexTokenCurrent <= indexLastTokenProcessedInPreviousJobExecution;
    }

    private void _validatePreviousJobExecutionProgressDetails() throws IllegalArgumentException {
        if (this.previousJobExecutionProgressDetails.tokenscount != this.ctx.burstTokens.size()) {
            throw new IllegalArgumentException(this.previousJobExecutionProgressDetails.filepath + " shows tokensCount as " + this.previousJobExecutionProgressDetails.tokenscount + " but " + this.previousJobExecutionProgressDetails.filepath + " has " + this.ctx.burstTokens.size() + " tokens!");
        }
        if (!this.previousJobExecutionProgressDetails.lasttokenindocument.equals(this.ctx.burstTokens.get(this.ctx.burstTokens.size() - 1))) {
            throw new IllegalArgumentException(this.previousJobExecutionProgressDetails.filepath + " shows lastTokenInDocument as " + this.previousJobExecutionProgressDetails.lasttokenindocument + " but the last token in " + this.previousJobExecutionProgressDetails.filepath + " is " + (String)this.ctx.burstTokens.get(this.ctx.burstTokens.size() - 1));
        }
        int indexOfLastTokenProcessed = this.ctx.burstTokens.indexOf(this.previousJobExecutionProgressDetails.lasttokenprocessed);
        int numberOfRemainingTokens = this.ctx.burstTokens.size() - 1 - indexOfLastTokenProcessed;
        if (this.previousJobExecutionProgressDetails.indexoflasttokenprocessed != indexOfLastTokenProcessed) {
            throw new IllegalArgumentException(this.previousJobExecutionProgressDetails.filepath + " shows indexOf " + this.previousJobExecutionProgressDetails.lasttokenprocessed + " as " + this.previousJobExecutionProgressDetails.indexoflasttokenprocessed + " but the index of " + this.previousJobExecutionProgressDetails.lasttokenprocessed + " in the " + this.previousJobExecutionProgressDetails.filepath + " is " + indexOfLastTokenProcessed);
        }
        if (this.previousJobExecutionProgressDetails.numberofremainingtokens != numberOfRemainingTokens) {
            throw new IllegalArgumentException(this.previousJobExecutionProgressDetails.filepath + " shows numberOfRemainingTokens as " + this.previousJobExecutionProgressDetails.numberofremainingtokens + " but in the file " + this.previousJobExecutionProgressDetails.filepath + " there are " + numberOfRemainingTokens + " remaining tokens!");
        }
        if (this.ctx.numberOfPages > -1 && this.previousJobExecutionProgressDetails.pagescount != this.ctx.numberOfPages) {
            throw new IllegalArgumentException(this.previousJobExecutionProgressDetails.filepath + " shows pagesCount as " + this.previousJobExecutionProgressDetails.pagescount + " but " + this.previousJobExecutionProgressDetails.filepath + " has " + this.ctx.numberOfPages + " pages!");
        }
    }
}

