/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster;

import com.sourcekraft.documentburster.GlobalContext;
import com.sourcekraft.documentburster.common.settings.Settings;
import com.sourcekraft.documentburster.job.CliJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="reportburster", mixinStandardHelpOptions=true, version={"ReportBurster 10.3.0"}, description={"Report bursting and report generation software"}, subcommands={BurstCommand.class, GenerateCommand.class, ResumeCommand.class, DocumentCommand.class, SystemCommand.class, ServiceCommand.class})
public class MainProgram
implements Callable<Integer> {
    private static Logger log = LoggerFactory.getLogger(MainProgram.class);
    public static final String JOB_TYPE_BURST = "burst";
    public static final String JOB_TYPE_GENERATE = "generate";
    public static final String JOB_TYPE_MERGE = "merge";
    private GlobalContext global = new GlobalContext();
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    public void setGlobal(GlobalContext global) {
        this.global = global;
    }

    public GlobalContext getGlobal() {
        return this.global;
    }

    @Override
    public Integer call() {
        this.spec.commandLine().usage(System.out);
        return 0;
    }

    public void execute(String[] args) throws Throwable {
        int exitCode = new CommandLine((Object)this).execute(args);
        if (exitCode != 0) {
            throw new RuntimeException("Command execution failed with exit code: " + exitCode);
        }
    }

    @CommandLine.Command(name="service", description={"Manage services (e.g., databases, queues) via Docker."}, mixinStandardHelpOptions=false, customSynopsis={"service <category> <command> [service-name] [args...]"})
    public static class ServiceCommand
    extends BaseCommand
    implements Callable<Integer> {
        @CommandLine.ParentCommand
        MainProgram parent;
        @CommandLine.Parameters(description={"The full service command string (e.g., 'database start northwind postgresql')."}, arity="1..*")
        private List<String> commandAndArgs;
        @CommandLine.Unmatched
        private List<String> unmatchedArgs;

        @Override
        protected MainProgram getMainProgram() {
            return this.parent;
        }

        @Override
        public Integer call() throws Exception {
            System.setProperty("testcontainers.reuse.enable", "true");
            if (this.commandAndArgs == null || this.commandAndArgs.isEmpty()) {
                System.err.println("Error: No service command provided.");
                return 1;
            }
            ArrayList<String> allArgs = new ArrayList<String>(this.commandAndArgs);
            if (this.unmatchedArgs != null) {
                allArgs.addAll(this.unmatchedArgs);
            }
            String serviceName = (String)allArgs.get(2);
            String commandLine = String.join((CharSequence)" ", allArgs);
            CliJob job = this.getJob(null);
            job.doService(serviceName, commandLine);
            return 0;
        }
    }

    @CommandLine.Command(name="system", description={"System operations"}, subcommands={TestEmailCommand.class, TestSmsCommand.class, LicenseCommand.class, FeatureRequestCommand.class, TestAndFetchDatabaseSchemaCommand.class})
    public static class SystemCommand
    implements Callable<Integer> {
        @CommandLine.ParentCommand
        MainProgram parent;
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;

        @Override
        public Integer call() {
            this.spec.commandLine().usage(System.out);
            return 0;
        }

        @CommandLine.Command(name="feature-request", description={"Submit a feature request"})
        public static class FeatureRequestCommand
        extends BaseCommand
        implements Callable<Integer> {
            @CommandLine.ParentCommand
            SystemCommand systemCommand;
            @CommandLine.Option(names={"-f", "--file"}, required=true, description={"XML file with feature request details"})
            private File featureRequestFile;

            @Override
            protected MainProgram getMainProgram() {
                return this.systemCommand.parent;
            }

            @Override
            public Integer call() throws Exception {
                if (!this.featureRequestFile.exists()) {
                    throw new FileNotFoundException("Feature request file does not exist: " + this.featureRequestFile.getAbsolutePath());
                }
                CliJob job = this.getJob(null);
                job.doSendFeatureRequestEmail(this.featureRequestFile.getAbsolutePath());
                return 0;
            }
        }

        @CommandLine.Command(name="license", description={"License management"}, subcommands={ActivateCommand.class, DeactivateCommand.class, CheckCommand.class})
        public static class LicenseCommand
        implements Callable<Integer> {
            @CommandLine.ParentCommand
            SystemCommand systemCommand;
            @CommandLine.Spec
            CommandLine.Model.CommandSpec spec;

            @Override
            public Integer call() {
                this.spec.commandLine().usage(System.out);
                return 0;
            }

            @CommandLine.Command(name="check", description={"Check license status"})
            public static class CheckCommand
            extends LicenseBaseCommand
            implements Callable<Integer> {
                @Override
                public Integer call() throws Exception {
                    CliJob job = this.getJob(null);
                    job.doCheckLicense();
                    return 0;
                }
            }

            @CommandLine.Command(name="deactivate", description={"Deactivate license key"})
            public static class DeactivateCommand
            extends LicenseBaseCommand
            implements Callable<Integer> {
                @Override
                public Integer call() throws Exception {
                    CliJob job = this.getJob(null);
                    job.doDeactivateLicense();
                    return 0;
                }
            }

            @CommandLine.Command(name="activate", description={"Activate license key"})
            public static class ActivateCommand
            extends LicenseBaseCommand
            implements Callable<Integer> {
                @Override
                public Integer call() throws Exception {
                    CliJob job = this.getJob(null);
                    job.doActivateLicenseKey();
                    return 0;
                }
            }

            static abstract class LicenseBaseCommand
            extends BaseCommand {
                @CommandLine.ParentCommand
                LicenseCommand licenseCommand;

                LicenseBaseCommand() {
                }

                @Override
                protected MainProgram getMainProgram() {
                    return this.licenseCommand.systemCommand.parent;
                }
            }
        }

        @CommandLine.Command(name="test-sql-query", description={"Test SQL query execution"})
        static class TestSqlQueryCommand
        extends BaseCommand
        implements Callable<Integer> {
            @CommandLine.ParentCommand
            SystemCommand systemCommand;
            @CommandLine.Option(names={"--sql-query"}, required=true, description={"SQL query to execute"})
            private String sqlQuery;
            @CommandLine.Mixin
            protected ConfigOptions config;
            @CommandLine.Option(names={"-p", "--param"}, description={"Query parameters in key=value format (can be repeated)"}, paramLabel="KEY=VALUE")
            private Map<String, String> parameters = new HashMap<String, String>();

            TestSqlQueryCommand() {
            }

            @Override
            protected MainProgram getMainProgram() {
                return this.systemCommand.parent;
            }

            @Override
            public Integer call() throws Exception {
                CliJob job = this.getJob(this.config.configFile);
                job.doFetchData(this.parameters);
                return 0;
            }
        }

        @CommandLine.Command(name="test-and-fetch-database-schema", description={"Test database connection and fetch schema information"})
        static class TestAndFetchDatabaseSchemaCommand
        extends BaseCommand
        implements Callable<Integer> {
            @CommandLine.ParentCommand
            SystemCommand systemCommand;
            @CommandLine.Option(names={"--database-connection-file"}, required=true, description={"Path to the database connection XML file (e.g., config/connections/db-my-db/db-my-db.xml)"})
            private File databaseConnectionFile;

            TestAndFetchDatabaseSchemaCommand() {
            }

            @Override
            protected MainProgram getMainProgram() {
                return this.systemCommand.parent;
            }

            @Override
            public Integer call() throws Exception {
                log.info("Initiating test-and-fetch-database-schema via CliJob...");
                if (!this.databaseConnectionFile.exists()) {
                    throw new FileNotFoundException("Database connection file does not exist: " + this.databaseConnectionFile.getAbsolutePath());
                }
                if (!this.databaseConnectionFile.isFile()) {
                    throw new IllegalArgumentException("Database connection file path does not point to a file: " + this.databaseConnectionFile.getAbsolutePath());
                }
                CliJob job = this.getJob(this.databaseConnectionFile.getAbsolutePath());
                job.doTestAndFetchDatabaseSchema(this.databaseConnectionFile.getAbsolutePath());
                log.info("CliJob execution for test-and-fetch-database-schema requested.");
                return 0;
            }
        }

        @CommandLine.Command(name="test-sms", description={"Test SMS through Twilio"})
        static class TestSmsCommand
        extends BaseCommand
        implements Callable<Integer> {
            @CommandLine.ParentCommand
            SystemCommand systemCommand;
            @CommandLine.Option(names={"--from", "--from-number"}, required=true, description={"From phone number"})
            private String fromNumber;
            @CommandLine.Option(names={"--to", "--to-number"}, required=true, description={"To phone number"})
            private String toNumber;
            @CommandLine.Mixin
            private ConfigOptions config;

            TestSmsCommand() {
            }

            @Override
            protected MainProgram getMainProgram() {
                return this.systemCommand.parent;
            }

            @Override
            public Integer call() throws Exception {
                CliJob job = this.getJob(this.config.configFile);
                job.doCheckTwilio(this.fromNumber, this.toNumber);
                return 0;
            }
        }

        @CommandLine.Command(name="test-email", description={"Test email connection"})
        static class TestEmailCommand
        extends BaseCommand
        implements Callable<Integer> {
            @CommandLine.ParentCommand
            SystemCommand systemCommand;
            @CommandLine.Option(names={"--email-connection-file"}, required=true, description={"Path to the email connection XML file (e.g., config/connections/eml-my-email.xml)"})
            private File emailConnectionFile;

            TestEmailCommand() {
            }

            @Override
            protected MainProgram getMainProgram() {
                return this.systemCommand.parent;
            }

            @Override
            public Integer call() throws Exception {
                if (!this.emailConnectionFile.exists()) {
                    throw new FileNotFoundException("Email connection file does not exist: " + this.emailConnectionFile.getAbsolutePath());
                }
                if (!this.emailConnectionFile.isFile()) {
                    throw new IllegalArgumentException("Email connection file path does not point to a file: " + this.emailConnectionFile.getAbsolutePath());
                }
                CliJob job = this.getJob(this.emailConnectionFile.getAbsolutePath());
                job.doCheckEmail();
                return 0;
            }
        }
    }

    @CommandLine.Command(name="document", description={"Document operations"}, subcommands={MergeCommand.class})
    public static class DocumentCommand
    implements Callable<Integer> {
        @CommandLine.ParentCommand
        MainProgram parent;
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;

        @Override
        public Integer call() {
            this.spec.commandLine().usage(System.out);
            return 0;
        }

        @CommandLine.Command(name="merge", description={"Merge multiple documents into one"})
        public static class MergeCommand
        extends BaseCommand
        implements Callable<Integer> {
            @CommandLine.ParentCommand
            DocumentCommand documentCommand;
            @CommandLine.Parameters(index="0", description={"File containing list of documents to merge"}, arity="1")
            private File listFile;
            @CommandLine.Option(names={"-o", "--output"}, description={"Output file name"})
            private String outputFileName;
            @CommandLine.Option(names={"-b", "--burst"}, description={"Burst the merged file"})
            private boolean burst = false;
            @CommandLine.Mixin
            private ConfigOptions config;

            @Override
            protected MainProgram getMainProgram() {
                return this.documentCommand.parent;
            }

            @Override
            public Integer call() throws Exception {
                if (!this.listFile.exists()) {
                    throw new FileNotFoundException("List file does not exist: " + this.listFile.getAbsolutePath());
                }
                List<String> filePaths = Files.readAllLines(this.listFile.toPath(), StandardCharsets.UTF_8);
                for (String filePath : filePaths) {
                    File file = new File(filePath);
                    if (file.exists()) continue;
                    throw new FileNotFoundException("Input file does not exist: " + filePath);
                }
                CliJob job = this.getJob(this.config.configFile);
                String outputMergedFilePath = job.doMerge(filePaths, this.outputFileName);
                if (this.burst) {
                    job.doBurst(outputMergedFilePath, false, "", -1);
                }
                FileUtils.deleteQuietly((File)this.listFile);
                return 0;
            }
        }
    }

    @CommandLine.Command(name="resume", description={"Resume a previously paused job"})
    public static class ResumeCommand
    extends BaseCommand
    implements Callable<Integer> {
        @CommandLine.ParentCommand
        MainProgram parent;
        @CommandLine.Parameters(index="0", description={"Job progress file to resume"}, arity="1")
        private File jobProgressFile;

        @Override
        protected MainProgram getMainProgram() {
            return this.parent;
        }

        @Override
        public Integer call() throws Exception {
            if (!this.jobProgressFile.exists()) {
                throw new FileNotFoundException("Job progress file does not exist: " + this.jobProgressFile.getAbsolutePath());
            }
            CliJob job = this.getJob(null);
            job.doResume(this.jobProgressFile.getAbsolutePath());
            return 0;
        }
    }

    @CommandLine.Command(name="generate", description={"Generate reports from input data"})
    public static class GenerateCommand
    extends BaseCommand
    implements Callable<Integer> {
        @CommandLine.ParentCommand
        MainProgram parent;
        @CommandLine.Parameters(index="0", description={"Input to process"}, arity="1")
        private String input;
        @CommandLine.Mixin
        private ConfigOptions config;
        @CommandLine.Mixin
        private QaOptions qa;
        @CommandLine.Option(names={"-p", "--param"}, description={"Report parameters in key=value format (can be repeated)"}, paramLabel="KEY=VALUE")
        private Map<String, String> parameters = new HashMap<String, String>();

        @Override
        protected MainProgram getMainProgram() {
            return this.parent;
        }

        @Override
        public Integer call() throws Exception {
            if (this.config.configFile == null) {
                throw new CommandLine.ParameterException(this.parent.spec.commandLine(), "Configuration file (-c/--config) is required");
            }
            int randomTestsCount = this.qa.getRandomTestsCount();
            if (randomTestsCount > 0 && randomTestsCount <= 0) {
                throw new CommandLine.ParameterException(this.parent.spec.commandLine(), "Number of random tests must be positive");
            }
            Settings settings = new Settings(this.config.configFile);
            settings.loadSettings();
            boolean isReportGenerationJob = settings.getCapabilities().reportgenerationmailmerge;
            CliJob job = this.getJob(this.config.configFile);
            job.setJobType(isReportGenerationJob ? settings.getReportDataSource().type : MainProgram.JOB_TYPE_BURST);
            job.setParameters(this.parameters);
            job.doBurst(this.input, this.qa.isTestAll(), this.qa.getTestList(), this.qa.getRandomTestsCount());
            return 0;
        }
    }

    @CommandLine.Command(name="burst", description={"Burst a document into multiple documents"})
    public static class BurstCommand
    extends BaseCommand
    implements Callable<Integer> {
        @CommandLine.ParentCommand
        protected MainProgram parent;
        @CommandLine.Parameters(index="0", description={"Input file to process"}, arity="1")
        protected File inputFile;
        @CommandLine.Mixin
        protected ConfigOptions config;
        @CommandLine.Mixin
        protected QaOptions qa;

        @Override
        protected MainProgram getMainProgram() {
            return this.parent;
        }

        @Override
        public Integer call() throws Exception {
            if (!this.inputFile.exists()) {
                throw new FileNotFoundException("Input file does not exist: " + this.inputFile.getAbsolutePath());
            }
            int randomTestsCount = this.qa.getRandomTestsCount();
            if (randomTestsCount != -1 && randomTestsCount <= 0) {
                throw new CommandLine.ParameterException(this.parent.spec.commandLine(), "Number of randomly selected entries to test must be positive");
            }
            CliJob job = this.getJob(this.config.configFile);
            job.doBurst(this.inputFile.getAbsolutePath(), this.qa.isTestAll(), this.qa.getTestList(), this.qa.getRandomTestsCount());
            return 0;
        }
    }

    static abstract class BaseCommand {
        BaseCommand() {
        }

        protected CliJob getJob(String configFilePath) throws Exception {
            File file;
            if (StringUtils.isNotEmpty((CharSequence)configFilePath) && !(file = new File(configFilePath)).exists()) {
                throw new FileNotFoundException("Configuration file does not exist: " + configFilePath);
            }
            MainProgram parent = this.getMainProgram();
            CliJob job = new CliJob(configFilePath);
            job.setGlobal(parent.global);
            return job;
        }

        protected abstract MainProgram getMainProgram();
    }

    public static class QaOptions {
        @CommandLine.ArgGroup(exclusive=true, multiplicity="0..1")
        private TestOptions testOptions = new TestOptions();

        public boolean isTestAll() {
            return this.testOptions != null && this.testOptions.testAll;
        }

        public String getTestList() {
            return this.testOptions == null || this.testOptions.testList == null ? "" : this.testOptions.testList;
        }

        public int getRandomTestsCount() {
            return this.testOptions == null || this.testOptions.randomTests == null ? -1 : this.testOptions.randomTests;
        }

        static class TestOptions {
            @CommandLine.Option(names={"-ta", "--testall"}, description={"Test all entries"})
            boolean testAll = false;
            @CommandLine.Option(names={"-tl", "--testlist"}, description={"Comma separated list of entries to test"})
            String testList;
            @CommandLine.Option(names={"-tr", "--testrandom"}, description={"Number of randomly selected entries to test (must be positive)"}, paramLabel="<count>")
            Integer randomTests;

            TestOptions() {
            }
        }
    }

    public static class ConfigOptions {
        @CommandLine.Option(names={"-c", "--config"}, description={"Configuration file path"})
        String configFile;
    }
}

