You are an HTML customization assistant. Your task is to take the **Customization instructions** provided below and apply them to the **Reference HTML template**. Generate the updated HTML code based on the instructions.

**Customization Instructions**

1. Change the title in the head element from "Invoice2" to "Creative Services Proposal"
2. Update the service provider name from "John Doe" to "Alex Rivera"
3. Change the service provider role from "UI / UX" to "Creative Director"
4. Update the client name from "Martin Sen" to "Emily Parker"
5. Change the client company from "Hp Solutions" to "Bright Ideas Marketing"
6. Update the locations from "Seattle, United States" and "Boston, United States" to "Toronto, Canada" and "Vancouver, Canada" respectively
7. Change the service name from "Proposal for Web Design & Development" to "Proposal for Brand Identity Redesign"
8. Update the date from "September 06, 2017" to "June 15, 2024"
9. Modify the rate from "$50 / hour" to "$85 / hour" and update all monetary values accordingly
10. Change the estimated time from "100 hours" to "75 hours"
11. Update the project timeline from "August 10, 2017" - "September 10, 2017" to "July 1, 2024" - "August 15, 2024"
12. Change the files provided description from "PSD files and front-end markup" to "Adobe Illustrator files and brand guidelines"
13. Update the task descriptions:
    - First task: Change "Web Design" to "Brand Strategy" with description "Research and development of brand positioning and identity concepts."
    - Second task: Change "Web Development" to "Visual Identity Design" with description "Creating logo variations, color palette, typography, and brand applications."
14. Update the hours from "50" each to "35" for first task and "40" for second task
15. Recalculate all monetary values to reflect the new rates and hours
16. Change the background color of "front-invoice-top" and "bottom-bar" from "#323149" to "#2a7d8c"
17. Update the contact information to "alexrivera.design", "hello@alexrivera.design", and "+1 (647) 555-1234"

**Reference HTML Template**

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Invoice2</title>
    <style>
      /* Base styles */
      body {
        font-family: "Montserrat", Arial, sans-serif;
        margin: 0;
        padding: 0;
        background-color: #f5f5f5;
      }
      .container {
        width: 100%;
        max-width: 1170px;
        padding-right: 15px;
        padding-left: 15px;
        margin-right: auto;
        margin-left: auto;
      }
      .row {
        margin-right: -15px;
        margin-left: -15px;
        display: flex;
        flex-wrap: wrap;
      }
      .col-xs-12,
      .col-sm-6,
      .col-sm-10,
      .col-md-9,
      .col-sm-4,
      .col-sm-8,
      .col-md-12 {
        position: relative;
        min-height: 1px;
        padding-right: 15px;
        padding-left: 15px;
        width: 100%;
        box-sizing: border-box;
      }
      .col-xs-12 {
        width: 100%;
      }
      @media (min-width: 768px) {
        .col-sm-4 {
          width: 33.33333333%;
        }
        .col-sm-6 {
          width: 50%;
        }
        .col-sm-8 {
          width: 66.66666667%;
        }
        .col-sm-10 {
          width: 83.33333333%;
        }
      }
      @media (min-width: 992px) {
        .col-md-9 {
          width: 75%;
        }
        .col-md-12 {
          width: 100%;
        }
      }
      .clearfix:before,
      .clearfix:after {
        display: table;
        content: " ";
      }
      .clearfix:after {
        clear: both;
      }
      .text-left {
        text-align: left;
      }
      .text-center {
        text-align: center;
      }
      .text-right {
        text-align: right;
      }
      .pull-right {
        float: right;
      }

      /* Table styles */
      .table {
        width: 100%;
        max-width: 100%;
        margin-bottom: 20px;
        border-collapse: collapse;
      }
      .table > thead > tr > th,
      .table > tbody > tr > td {
        padding: 8px;
        line-height: 1.42857143;
        vertical-align: top;
      }
      .table > thead > tr > th {
        vertical-align: bottom;
        border-bottom: 2px solid #ddd;
      }
      .table > tbody > tr > td {
        border-top: 1px solid #ddd;
      }
      .borderless td,
      .borderless th {
        border: none !important;
      }

      /* Front Invoice Styles */
      .front-invoice-wrapper {
        margin: 20px auto;
        max-width: 700px;
        box-shadow: 0 3px 6px rgba(0, 0, 0, 0.16), 0 3px 6px rgba(0, 0, 0, 0.23);
      }
      .front-invoice-top {
        background-color: #323149;
        padding: 40px 60px;
      }
      .front-invoice-top-left h2,
      .front-invoice-top-right h2 {
        color: #ffffff;
        font-size: 22px;
        margin-bottom: 4px;
      }
      .front-invoice-top-left h3,
      .front-invoice-top-right h3 {
        color: rgba(255, 255, 255, 0.7);
        font-size: 15px;
        font-weight: 400;
        margin-top: 0;
        margin-bottom: 5px;
      }
      .front-invoice-top-left h5,
      .front-invoice-top-right h5 {
        color: rgba(255, 255, 255, 0.7);
        font-size: 14px;
        font-weight: 400;
        margin-top: 0;
      }
      .front-invoice-top-right {
        text-align: right;
      }
      .service-name {
        color: #ffffff;
        font-size: 22px;
        font-weight: 500;
        margin-top: 60px;
      }
      .date {
        color: rgba(255, 255, 255, 0.8);
        font-size: 14px;
      }
      .front-invoice-bottom {
        background-color: #ffffff;
        padding: 40px 60px;
        position: relative;
      }
      .custom-table td {
        font-size: 13px;
        padding: 6px !important;
        font-weight: 500;
      }
      .description {
        line-height: 1.6;
      }
      .specs {
        margin-top: 30px;
        font-size: 14px;
      }

      /* Back Invoice Styles */
      .invoice-wrapper {
        margin: 20px auto;
        max-width: 700px;
        box-shadow: 0 3px 6px rgba(0, 0, 0, 0.16), 0 3px 6px rgba(0, 0, 0, 0.23);
      }
      .invoice-top {
        background: linear-gradient(135deg, #fafafa, #eeeeee);
        padding: 60px 60px 80px;
      }
      .invoice-top-left h2,
      .invoice-top-right h2 {
        font-size: 22px;
        margin-bottom: 4px;
      }
      .invoice-top-left h3,
      .invoice-top-right h3 {
        font-size: 15px;
        font-weight: 400;
        margin-top: 0;
        margin-bottom: 5px;
      }
      .invoice-top-left h5,
      .invoice-top-right h5 {
        font-size: 14px;
        font-weight: 400;
        margin-top: 0;
      }
      .invoice-top-left h4 {
        margin-top: 40px;
        font-size: 22px;
      }
      .invoice-top-left h6 {
        font-size: 14px;
        font-weight: 400;
      }
      .invoice-top-right h2,
      .invoice-top-right h3,
      .invoice-top-right h5 {
        text-align: right;
      }
      .invoice-bottom {
        background-color: #ffffff;
        padding: 40px 60px;
        position: relative;
      }
      .task-table-wrapper {
        margin-top: -14%;
      }
      .task-table-wrapper .table > thead > tr > th {
        border: none;
        padding-left: 0;
      }
      .task-table-wrapper .table > tbody > tr:first-child > td {
        border-top: 0;
      }
      .task-table-wrapper .table > tbody > tr > td {
        padding-top: 25px;
        padding-left: 0;
      }
      .task-table-wrapper .table > tbody > tr > td > h4 {
        margin-top: 0;
      }
      .task-table-wrapper .table tbody .desc {
        width: 60%;
      }
      .desc h3 {
        margin-top: 0;
        font-size: 20px;
      }
      .desc h5 {
        font-weight: 400;
        line-height: 1.4;
        font-size: 14px;
      }
      .invoice-bottom-total {
        background-color: #fafafa;
        overflow: auto;
        margin-top: 50px;
      }
      .no-padding {
        padding-left: 0;
        padding-right: 0;
      }
      .invoice-bottom-total .tax-box,
      .invoice-bottom-total .add-box,
      .invoice-bottom-total .sub-total-box {
        display: inline-block;
        margin-right: 10px;
        padding: 10px;
      }
      .invoice-bottom-total .total-box {
        background-color: #323149;
        padding: 10px;
      }
      .invoice-bottom-total .total-box h6 {
        margin-top: 0;
        color: #ffffff;
        text-align: right;
      }
      .invoice-bottom-total .total-box h3 {
        margin-bottom: 0;
        color: #ffffff;
        text-align: right;
      }
      .divider {
        margin-top: 50px;
        margin-bottom: 5px;
        border: 0;
        border-top: 1px solid #eee;
      }
      .bottom-bar {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 26px;
        background-color: #323149;
      }
    </style>
  </head>
  <body>
    <section class="front">
      <div class="container">
        <div class="row">
          <div class="col-xs-12">
            <div class="front-invoice-wrapper">
              <div class="front-invoice-top">
                <div class="row">
                  <div class="col-sm-6">
                    <div class="front-invoice-top-left">
                      <h2>John Doe</h2>
                      <h3>UI / UX</h3>
                      <h5>Seattle, United States</h5>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="front-invoice-top-right">
                      <h2>Martin Sen</h2>
                      <h3>Hp Solutions</h3>
                      <h5>Boston, United States</h5>
                      <img
                        src="acme.png"
                        class="img-responsive pull-right logo"
                      />
                    </div>
                  </div>
                  <div class="clearfix"></div>
                  <div class="col-xs-12">
                    <h1 class="service-name">
                      Proposal for Web Design &amp; Development
                    </h1>
                    <h6 class="date">September 06, 2017</h6>
                  </div>
                </div>
              </div>
              <div class="front-invoice-bottom">
                <div class="row">
                  <div class="col-xs-12">
                    <p class="description">
                      Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                      Consequuntur illo, iure eveniet, iste quidem nihil nemo
                      molestiae! Repellat quidem, saepe, dignissimos dolor
                      soluta nobis similique nemo voluptatem sed omnis velit!
                    </p>
                    <h6 class="specs">Specifications are as follows:</h6>
                  </div>
                  <div class="col-xs-12 col-sm-10 col-md-9">
                    <table class="table borderless custom-table">
                      <tbody>
                        <tr>
                          <td>Rate:</td>
                          <td>$50 / hour</td>
                        </tr>
                        <tr>
                          <td>Estimated Time:</td>
                          <td>100 hours</td>
                        </tr>
                        <tr>
                          <td>Start Date:</td>
                          <td>August 10, 2017</td>
                        </tr>
                        <tr>
                          <td>End Date:</td>
                          <td>September 10, 2017</td>
                        </tr>
                        <tr>
                          <td>Files provided:</td>
                          <td>PSD files and front-end markup</td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <section class="back">
      <div class="container">
        <div class="row">
          <div class="col-xs-12">
            <div class="invoice-wrapper">
              <div class="invoice-top">
                <div class="row">
                  <div class="col-sm-6">
                    <div class="invoice-top-left">
                      <h2>John Doe</h2>
                      <h3>UI / UX</h3>
                      <h5>Seattle, United States</h5>

                      <h4>Invoice</h4>
                      <h6>September 06, 2017</h6>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="invoice-top-right">
                      <h2>Martin Sen</h2>
                      <h3>Hp Solutions</h3>
                      <h5>Boston, United States</h5>
                    </div>
                  </div>
                </div>
              </div>
              <div class="invoice-bottom">
                <div class="row">
                  <div class="col-xs-12">
                    <div class="task-table-wrapper">
                      <table class="table">
                        <thead>
                          <tr>
                            <th>TASK DESCRIPTION</th>
                            <th>RATE</th>
                            <th>HOURS</th>
                            <th>TOTAL</th>
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <td class="desc">
                              <h3>Web Design</h3>
                              <h5>
                                Design the wireframes and PSD mockups of
                                website.
                              </h5>
                            </td>
                            <td><h4>$50</h4></td>
                            <td><h4>50</h4></td>
                            <td><h4>$2500</h4></td>
                          </tr>
                          <tr>
                            <td class="desc">
                              <h3>Web Development</h3>
                              <h5>
                                Making the responsive website from the PSD file
                                &amp; hosting on server.
                              </h5>
                            </td>
                            <td><h4>$50</h4></td>
                            <td><h4>50</h4></td>
                            <td><h4>$2500</h4></td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                  <div class="clearfix"></div>
                  <div class="col-md-12">
                    <div class="invoice-bottom-total">
                      <div class="col-sm-8 no-padding">
                        <div class="sub-total-box">
                          <h6>SUBTOTAL</h6>
                          <h5>$5000</h5>
                        </div>
                        <div class="add-box">
                          <h3>+</h3>
                        </div>
                        <div class="tax-box">
                          <h6>TAXES</h6>
                          <h5>$586</h5>
                        </div>
                      </div>
                      <div class="col-sm-4 no-padding">
                        <div class="total-box">
                          <h6>TOTAL</h6>
                          <h3>$5586</h3>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="clearfix"></div>
                  <div class="col-xs-12">
                    <hr class="divider" />
                  </div>
                  <div class="col-sm-4">
                    <h6 class="text-left">johndoe.com</h6>
                  </div>
                  <div class="col-sm-4">
                    <h6 class="text-center">contact@johndoe.com</h6>
                  </div>
                  <div class="col-sm-4">
                    <h6 class="text-right">+91 8097678988</h6>
                  </div>
                </div>
                <div class="bottom-bar"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </body>
</html>
```

Output only the complete updated HTML template with the applied changes.
