/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.writer.excel;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.certait.htmlexporter.css.Style;
import uk.co.certait.htmlexporter.css.StyleMap;
import uk.co.certait.htmlexporter.ss.CellRange;
import uk.co.certait.htmlexporter.ss.Function;
import uk.co.certait.htmlexporter.writer.AbstractTableCellWriter;
import uk.co.certait.htmlexporter.writer.excel.ExcelCellCommentGenerator;
import uk.co.certait.htmlexporter.writer.excel.ExcelCellRangeResolver;
import uk.co.certait.htmlexporter.writer.excel.ExcelFunctionCell;
import uk.co.certait.htmlexporter.writer.excel.ExcelStyleGenerator;

public class ExcelTableCellWriter
extends AbstractTableCellWriter {
    private static final Logger logger = LoggerFactory.getLogger(ExcelTableCellWriter.class);
    private Sheet sheet;
    private StyleMap styleMapper;
    private ExcelStyleGenerator styleGenerator;

    public ExcelTableCellWriter(Sheet sheet, StyleMap styleMapper) {
        this.sheet = sheet;
        this.styleMapper = styleMapper;
        this.styleGenerator = new ExcelStyleGenerator();
    }

    @Override
    public void renderCell(Element element, int rowIndex, int columnIndex) {
        Cell cell = this.sheet.getRow(rowIndex).createCell(columnIndex);
        if (this.isDateCell(element)) {
            SimpleDateFormat df = new SimpleDateFormat(this.getDateCellFormat(element));
            try {
                cell.setCellValue(df.parse(this.getElementText(element)));
            }
            catch (ParseException pex) {
                logger.error("Error processing date cell with format specified as {} and value {}", new Object[]{this.getDateCellFormat(element), this.getElementText(element), pex});
            }
        } else {
            Double numericValue = this.getNumericValue(element);
            if (numericValue != null) {
                if (this.isPercentageCell(element)) {
                    cell.setCellValue(numericValue / 100.0);
                } else {
                    cell.setCellValue(numericValue.doubleValue());
                }
            } else {
                cell = this.sheet.getRow(rowIndex).createCell(columnIndex, CellType.STRING);
                cell.setCellValue(this.getElementText(element));
            }
        }
        Style style = this.styleMapper.getStyleForElement(element);
        cell.setCellStyle(this.styleGenerator.getStyle(element, cell, style));
        String commentText = this.getCellCommentText(element);
        if (commentText != null) {
            ExcelCellCommentGenerator.addCellComment(cell, commentText, this.getCellCommentDimension(element));
        }
        if (this.definesFreezePane(element)) {
            this.sheet.createFreezePane(columnIndex, rowIndex);
        }
    }

    @Override
    public void addFunctionCell(int rowIndex, int columnIndex, CellRange range, Function function) {
        Cell cell = this.sheet.getRow(rowIndex).getCell(columnIndex);
        new ExcelFunctionCell(cell, range, new ExcelCellRangeResolver(), function);
    }
}

